/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies;

import com.google.common.collect.Lists;
import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.dependencies.DependencyAnalysisFactory;
import com.teamscale.index.dependencies.DependencyExtractionIndexes;
import com.teamscale.index.dependencies.DependencyExtractionSettings;
import com.teamscale.index.dependencies.DependencyIndexBase;
import com.teamscale.index.dependencies.DependencyListIndex;
import com.teamscale.index.dependencies.ExternalDependencyIndex;
import com.teamscale.index.dependencies.ExternalDependencyInfo;
import com.teamscale.index.dependencies.IDependencyExtractor;
import com.teamscale.index.dependencies.IFileDependencyFilteringStrategy;
import com.teamscale.index.dependencies.ITypeLookupEnvironment;
import com.teamscale.index.dependencies.ProjectModuleIndex;
import com.teamscale.index.dependencies.TypeDeltaIndex;
import com.teamscale.index.dependencies.TypeDependencies;
import com.teamscale.index.dependencies.TypeDependencyIndex;
import com.teamscale.index.dependencies.TypeIndex;
import com.teamscale.index.dependencies.TypeIndexCache;
import com.teamscale.index.dependencies.TypeLookupEnvironmentFactory;
import com.teamscale.index.dependencies.UnresolvedDependenciesIndex;
import com.teamscale.index.dependencies.VariableWriteDependencyIndex;
import com.teamscale.index.dependencies.abap.AbapDependencyCollection;
import com.teamscale.index.dependencies.abap.AbapThirdPartyPathsIndex;
import com.teamscale.index.dependencies.dart.DartPackagePathsIndex;
import com.teamscale.index.dependencies.javascript.TsConfigPathsIndex;
import com.teamscale.index.resource.BinaryElementIndex;
import com.teamscale.index.resource.CompileCommandIndex;
import com.teamscale.index.resource.FileIncludeLookup;
import com.teamscale.index.resource.PreprocessorExpansionsIndex;
import com.teamscale.index.resource.SimulinkDataDictionaryIndex;
import com.teamscale.index.resource.SimulinkModelInfoIndex;
import com.teamscale.index.resource.SystemIncludeFileCacheIndex;
import com.teamscale.index.resource.SystemIncludeFileLookup;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.path_lookup.PathLookupIndex;
import com.teamscale.index.resource.path_lookup.PreloadedMatchingPathsLookup;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.abap.EAbapObjectType;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.PartitionIndexBase;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class DependencySynchronizer
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final EnumSet<ELanguage> LANGUAGES_WITH_FILE_INCLUDE_LOOKUP = EnumSet.of(ELanguage.PHP, ELanguage.C, ELanguage.CPP, ELanguage.CPP_MS_CLI);
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="content")
    private TokenElementIndex contentIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private PathLookupIndex pathLookupIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private BinaryElementIndex binaryElementIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private SimulinkModelInfoIndex simulinkModelInfoIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private SimulinkDataDictionaryIndex simulinkDataDictionaryIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ExternalDependencyIndex externalDependencyIndex;
    @DeltaSource(value=ExternalDependencyIndex.class)
    private KeyDelta externalDependencyDelta;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="dependencies")
    private DependencyListIndex dependencyIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="inverse-dependencies")
    private DependencyListIndex inverseDependencyIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private TypeDependencyIndex typeDependencyIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private UnresolvedDependenciesIndex unresolvedDependenciesIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ProjectModuleIndex projectModuleIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private MetaIndex metaIndex;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_WRITE)
    private SystemIncludeFileCacheIndex systemIncludeFileCacheIndex;
    public static final String INCLUDE_THIRD_PARTY_DEPENDENCIES_OPTION_NAME = "include-third-party-dependencies";
    @StepParameter(value="include-third-party-dependencies", optional=true)
    private boolean includeThirdPartyDependencies = false;
    public static final String PERFORM_CASE_SENSITIVE_HEADER_RESOLUTION_OPTION_NAME = "perform-case-sensitive-header-resolution";
    @StepParameter(value="perform-case-sensitive-header-resolution", optional=true)
    private boolean performCaseSensitiveHeaderResolution = false;
    public static final String FIND_DEPENDENCIES_IN_EXCLUDED_CODE_OPTION_NAME = "find-dependencies-in-excluded-code";
    @StepParameter(value="find-dependencies-in-excluded-code", optional=true)
    private boolean findCppDependenciesInExcludedCode = false;
    public static final String INCLUDE_INTERMEDIARY_TYPES_IN_CALL_CHAIN_OPTION_NAME = "include-intermediary-types-in-call-chain";
    @StepParameter(value="include-intermediary-types-in-call-chain", optional=true)
    private boolean includeIntermediaryTypesInCallChain = false;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TypeIndex typeIndex;
    @DeltaSource(value=TypeDeltaIndex.class)
    private KeyDelta typeDeltaIndexDelta;
    @DeltaSource(value=SimulinkDataDictionaryIndex.class)
    private KeyDelta simulinkDataDictionaryDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TsConfigPathsIndex tsconfigPathsIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private AbapThirdPartyPathsIndex abapThirdPartyPathsIndex;
    @DeltaSource(value=AbapThirdPartyPathsIndex.class)
    private KeyDelta abapThirdPartyPathsIndexDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private CompileCommandIndex compileCommandIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private PreprocessorExpansionsIndex preprocessorExpansionsIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private DartPackagePathsIndex dartPackagePathsIndex;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY)
    private AbapThirdPartyPathsIndex abapThirdPartyPathsIndexPrevRevision;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private VariableWriteDependencyIndex variableWriteIndex;
    private FileIncludeLookup fileIncludeLookup = null;
    private TypeIndexCache typeIndexCache;

    public void execute() throws StorageException {
        this.typeIndexCache = new TypeIndexCache(this.typeIndex);
        List deletedPaths = this.typeDeltaIndexDelta.getDeletedKeysAsStrings();
        List modifiedPaths = this.typeDeltaIndexDelta.getAddedOrChangedKeysAsStrings();
        if (!this.abapThirdPartyPathsIndexDelta.isEmpty()) {
            List<String> outdatedThirdPartyTypes = this.determineChangedThirdPartyTypes();
            modifiedPaths.addAll(this.findFilesDependingOnThirdPartyTypes(new HashSet<String>(outdatedThirdPartyTypes)));
        }
        Set<String> pathsToUpdate = this.getPathsToUpdate(deletedPaths, modifiedPaths);
        PairList fileDependencies = new PairList();
        PairList typeDependencies = new PairList();
        this.collectDependencies(pathsToUpdate, (PairList<String, ArrayList<String>>)fileDependencies, (PairList<String, ArrayList<TypeDependencies>>)typeDependencies);
        HashSet modifiedOrDeletedPaths = CollectionUtils.unionSet((Collection)modifiedPaths, (Collection[])new Collection[]{deletedPaths});
        DependencyIndexBase.removeInverseDependencies(this.dependencyIndex, this.inverseDependencyIndex, new ArrayList<String>(modifiedOrDeletedPaths));
        this.dependencyIndex.removeDependencies(deletedPaths);
        this.inverseDependencyIndex.removeDependencies(deletedPaths);
        this.typeDependencyIndex.removeTypeDependencies(deletedPaths);
        this.unresolvedDependenciesIndex.removePaths(deletedPaths);
        this.typeDependencyIndex.setTypeDependencies((PairList<String, ArrayList<TypeDependencies>>)typeDependencies);
        this.dependencyIndex.setDependencies((PairList<String, ArrayList<String>>)fileDependencies);
        DependencyIndexBase.updateInverseDependencyIndex(this.inverseDependencyIndex, (PairList<String, ArrayList<String>>)fileDependencies, this.contentIndex.getAllUniformPaths());
    }

    private Set<String> findFilesDependingOnThirdPartyTypes(Set<String> outdatedThirdPartyTypes) throws StorageException {
        if (outdatedThirdPartyTypes.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (Pair entry : this.dependencyIndex.getAllDependencies()) {
            if (!CollectionUtils.anyMatch((Collection)((Collection)entry.getSecond()), outdatedThirdPartyTypes::contains)) continue;
            result.add((String)entry.getFirst());
        }
        return result;
    }

    private List<String> determineChangedThirdPartyTypes() throws StorageException {
        ArrayList<String> outdatedThirdPartyTypes = new ArrayList<String>(this.abapThirdPartyPathsIndexPrevRevision.getObjectPathsForKeys(this.abapThirdPartyPathsIndexDelta.getDeletedKeysAsStrings()));
        List addedOrChangedKeys = this.abapThirdPartyPathsIndexDelta.getAddedOrChangedKeysAsStrings();
        List<String> previousThirdPartyPaths = this.abapThirdPartyPathsIndexPrevRevision.getObjectPathsForKeys(addedOrChangedKeys);
        for (int i = 0; i < addedOrChangedKeys.size(); ++i) {
            if (previousThirdPartyPaths.get(i) == null) {
                String addedObjectName = AbapThirdPartyPathsIndex.getObjectName((String)addedOrChangedKeys.get(i));
                EAbapObjectType addedObjectType = AbapThirdPartyPathsIndex.getObjectType((String)addedOrChangedKeys.get(i));
                outdatedThirdPartyTypes.add(AbapDependencyCollection.getDependencyNameForUnknownObjectOfType(addedObjectName, addedObjectType));
                outdatedThirdPartyTypes.add(AbapDependencyCollection.getDependencyNameForUnknownObjectAndType(addedObjectName));
                continue;
            }
            outdatedThirdPartyTypes.add(previousThirdPartyPaths.get(i));
        }
        return outdatedThirdPartyTypes;
    }

    private Set<String> getPathsToUpdate(List<String> deletedPaths, List<String> modifiedPaths) throws StorageException {
        if (!this.simulinkDataDictionaryDelta.isEmpty()) {
            return new HashSet<String>(this.typeIndexCache.getAllFiles());
        }
        HashSet<String> pathsToUpdate = new HashSet<String>(modifiedPaths);
        pathsToUpdate.addAll(this.getInverseDependencies(deletedPaths));
        pathsToUpdate.addAll(this.getInverseDependencies(modifiedPaths));
        CollectionUtils.removeAll(pathsToUpdate, deletedPaths);
        pathsToUpdate.addAll(PartitionIndexBase.getUniformPaths((Collection)this.externalDependencyDelta.getAddedOrChangedKeysAsStrings()));
        pathsToUpdate.addAll(PartitionIndexBase.getUniformPaths((Collection)this.externalDependencyDelta.getDeletedKeysAsStrings()));
        Set<String> types = this.typeIndex.getTypeNamesForFiles(modifiedPaths).stream().flatMap(Collection::stream).collect(Collectors.toSet());
        if (!types.isEmpty()) {
            pathsToUpdate.addAll(this.unresolvedDependenciesIndex.getPathsForTypes(types));
        }
        return pathsToUpdate;
    }

    private void collectDependencies(Collection<String> paths, PairList<String, ArrayList<String>> fileDependencies, PairList<String, ArrayList<TypeDependencies>> pathToTypeDependencies) throws StorageException {
        TypeLookupEnvironmentFactory lookupFactory = new TypeLookupEnvironmentFactory(this.typeIndexCache, this.projectModuleIndex);
        ArrayList<String> pathList = new ArrayList<String>(paths);
        ListMap<String, ExternalDependencyInfo> dependencyInfos = this.externalDependencyIndex.getAllDependenciesForFiles(pathList);
        PairList unresolvedDependencyValues = new PairList();
        HashMap<String, ELanguage> languageCache = new HashMap<String, ELanguage>(pathList.size());
        List pathChunks = Lists.partition(pathList, (int)500);
        for (List pathChunk : pathChunks) {
            this.collectDependenciesForChunk(pathToTypeDependencies, lookupFactory, dependencyInfos, (PairList<String, ArrayList<String>>)unresolvedDependencyValues, pathChunk, languageCache);
        }
        ListMap<String, String> typesToFiles = this.buildTypesToFilesMapping(pathToTypeDependencies);
        for (int i = 0; i < pathToTypeDependencies.size(); ++i) {
            String uniformPath = (String)pathToTypeDependencies.getFirst(i);
            if (uniformPath.endsWith(".yaml")) continue;
            fileDependencies.add((Object)uniformPath, this.getFileDependencies(uniformPath, (List)pathToTypeDependencies.getSecond(i), typesToFiles, (List)dependencyInfos.getCollectionOrEmpty((Object)uniformPath), lookupFactory, languageCache));
        }
        this.unresolvedDependenciesIndex.setUnresolvedDependencies((PairList<String, ArrayList<String>>)unresolvedDependencyValues);
    }

    private void collectDependenciesForChunk(PairList<String, ArrayList<TypeDependencies>> pathToTypeDependencies, TypeLookupEnvironmentFactory lookupFactory, ListMap<String, ExternalDependencyInfo> dependencyInfos, PairList<String, ArrayList<String>> unresolvedDependencyValues, List<String> pathChunk, Map<String, ELanguage> languageCache) throws StorageException {
        List elements = CollectionUtils.filter(this.contentIndex.getTokenElements(pathChunk), Objects::nonNull);
        this.unregisterVariableWrites(elements);
        this.registerVariableWrites(elements);
        for (TokenElementInfo element : elements) {
            languageCache.put(element.getUniformPath(), element.getLanguage());
            try {
                this.collectDependencies(element, pathToTypeDependencies, lookupFactory, dependencyInfos, unresolvedDependencyValues, this.getFileIncludeLookup(element.getLanguage()));
            }
            catch (AssertionError | ConQATException e) {
                LOGGER.error("Error while collecting dependencies in " + element.getUniformPath() + ": " + ((Throwable)e).getMessage(), (Throwable)e);
            }
        }
    }

    private FileIncludeLookup getFileIncludeLookup(ELanguage language) throws StorageException {
        if (!LANGUAGES_WITH_FILE_INCLUDE_LOOKUP.contains(language)) {
            return null;
        }
        if (this.fileIncludeLookup == null) {
            PreloadedMatchingPathsLookup preloadedPathLookup = this.pathLookupIndex.createPreloadedLookup();
            SystemIncludeFileLookup systemIncludeFileLookup = SystemIncludeFileLookup.create(this.metaIndex, this.systemIncludeFileCacheIndex);
            this.fileIncludeLookup = new FileIncludeLookup(preloadedPathLookup, systemIncludeFileLookup);
        }
        return this.fileIncludeLookup;
    }

    private void registerVariableWrites(List<TokenElementInfo> elements) throws StorageException {
        for (TokenElementInfo element : elements) {
            DependencyAnalysisFactory.createVariableWriteDependencyStrategy(element.getLanguage()).registerVariableWrite(element, this.variableWriteIndex);
        }
    }

    private void unregisterVariableWrites(List<TokenElementInfo> elements) throws StorageException {
        for (TokenElementInfo element : elements) {
            DependencyAnalysisFactory.createVariableWriteDependencyStrategy(element.getLanguage()).unregisterVariableWrites(element, this.variableWriteIndex);
        }
    }

    private void collectDependencies(TokenElementInfo element, PairList<String, ArrayList<TypeDependencies>> pathToTypeDependencies, TypeLookupEnvironmentFactory lookupFactory, ListMap<String, ExternalDependencyInfo> dependencyInfos, PairList<String, ArrayList<String>> unresolvedDependencyValues, @Nullable FileIncludeLookup fileIncludeLookup) throws ConQATException {
        String uniformPath = element.getUniformPath();
        ELanguage language = element.getLanguage();
        IDependencyExtractor extractor = DependencyAnalysisFactory.createDependencyExtractor(language);
        DependencyExtractionSettings dependencyExtractionSettings = new DependencyExtractionSettings(this.includeThirdPartyDependencies, this.includeIntermediaryTypesInCallChain, this.performCaseSensitiveHeaderResolution, this.findCppDependenciesInExcludedCode);
        ITypeLookupEnvironment lookupEnvironment = lookupFactory.getLookupEnvironment(uniformPath, language);
        lookupEnvironment.clearUnresolvedTypes();
        DependencyExtractionIndexes dependencyExtractionIndexes = new DependencyExtractionIndexes(this.contentIndex, this.binaryElementIndex, this.simulinkModelInfoIndex, this.simulinkDataDictionaryIndex, this.variableWriteIndex, this.abapThirdPartyPathsIndex, this.tsconfigPathsIndex, fileIncludeLookup, this.compileCommandIndex, this.preprocessorExpansionsIndex, this.dartPackagePathsIndex);
        ArrayList<TypeDependencies> dependencies = new ArrayList<TypeDependencies>(extractor.extractDependencies(element, dependencyExtractionIndexes, lookupEnvironment, dependencyExtractionSettings));
        unresolvedDependencyValues.add((Object)uniformPath, (Object)CollectionUtils.sort(lookupEnvironment.getUnresolvedTypes()));
        DependencySynchronizer.collectExternallyUploadedDependencies(uniformPath, dependencies, dependencyInfos);
        pathToTypeDependencies.add((Object)uniformPath, new ArrayList<TypeDependencies>(dependencies));
    }

    private ListMap<String, String> buildTypesToFilesMapping(PairList<String, ArrayList<TypeDependencies>> typeDependencies) throws StorageException {
        HashSet<String> allDependencies = new HashSet<String>();
        for (int i = 0; i < typeDependencies.size(); ++i) {
            for (TypeDependencies dependency : (ArrayList)typeDependencies.getSecond(i)) {
                allDependencies.addAll((Collection<String>)dependency.getDependencies());
            }
        }
        ArrayList<String> allDependenciesToLoad = new ArrayList<String>(allDependencies);
        ListMap typesToFiles = new ListMap();
        List<List<String>> allFilesLists = this.typeIndexCache.getFilesForTypes(allDependenciesToLoad);
        for (int i = 0; i < allDependenciesToLoad.size(); ++i) {
            typesToFiles.addAll((Object)((String)allDependenciesToLoad.get(i)), (Collection)allFilesLists.get(i));
        }
        return typesToFiles;
    }

    private static void collectExternallyUploadedDependencies(String path, List<TypeDependencies> dependencies, ListMap<String, ExternalDependencyInfo> dependencyInfos) {
        List externalDependencyInfos = (List)dependencyInfos.getCollection((Object)path);
        if (externalDependencyInfos == null || externalDependencyInfos.isEmpty()) {
            return;
        }
        ListMap dependencyLocations = new ListMap();
        for (ExternalDependencyInfo externalDependencyInfo : externalDependencyInfos) {
            for (ExternalDependencyInfo.Dependency externalDependency : externalDependencyInfo.getDependencies()) {
                dependencyLocations.addAll((Object)externalDependency.getTarget(), externalDependency.getLocations());
            }
        }
        dependencies.add(new TypeDependencies(path, (ListMap<String, ElementLocation>)dependencyLocations));
    }

    private ArrayList<String> getFileDependencies(String uniformPath, List<TypeDependencies> dependencies, ListMap<String, String> typesToFiles, List<ExternalDependencyInfo> externalDependencies, TypeLookupEnvironmentFactory typeLookupEnvironmentFactory, Map<String, ELanguage> languageCache) {
        IFileDependencyFilteringStrategy typeDependencyMappingStrategy = DependencyAnalysisFactory.createTypeDependencyMappingStrategy(languageCache.get(uniformPath));
        HashSet<String> result = new HashSet<String>();
        ArrayList<String> dependencyList = new ArrayList<String>();
        for (TypeDependencies typeDependencies : dependencies) {
            dependencyList.addAll((Collection<String>)typeDependencies.getDependencies());
        }
        for (String string : dependencyList) {
            List uniformPaths = (List)typesToFiles.getCollection((Object)string);
            if (uniformPaths != null && !uniformPaths.isEmpty()) {
                HashSet<String> paths = new HashSet<String>(uniformPaths);
                paths.remove(uniformPath);
                result.addAll(typeDependencyMappingStrategy.filterDependencies(uniformPath, paths, typeLookupEnvironmentFactory));
                continue;
            }
            if (!this.includeThirdPartyDependencies && !DependencySynchronizer.containsExternalDependencyTo(externalDependencies, string)) continue;
            result.add(string);
        }
        return new ArrayList<String>(CollectionUtils.sort(result));
    }

    private static boolean containsExternalDependencyTo(List<ExternalDependencyInfo> externalDependencies, String dependency) {
        return CollectionUtils.map(externalDependencies, ExternalDependencyInfo::getDependencies).stream().flatMap(Collection::stream).map(ExternalDependencyInfo.Dependency::getTarget).collect(Collectors.toSet()).contains(dependency);
    }

    private List<String> getInverseDependencies(List<String> uniformPaths) throws StorageException {
        ArrayList<String> result = new ArrayList<String>();
        for (ArrayList<String> value : this.inverseDependencyIndex.getDependencies(uniformPaths)) {
            if (value == null) continue;
            result.addAll(value);
        }
        return result;
    }
}

