/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.clangtidy;

import com.teamscale.index.configuration.tools.AnalysisToolsConfigurationUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.io.ProcessUtils;

public class ProcessWrapper {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String TIMEOUT_MESSAGE_FORMAT_STRING = "Timeout (waited %s minutes) while running command: %s";
    public static final Pattern TIMEOUT_MESSAGE_PATTERN = Pattern.compile(String.format("Timeout (waited %s minutes) while running command: %s", "\\d+", ".*"));
    private final List<String> command = new ArrayList<String>();
    private Consumer<String> outputConsumer;
    private Consumer<String> errorConsumer;
    private File workingDirectory;
    public boolean writeExceptionsToErrorOutput = false;
    private final Map<String, String> environmentVariables;
    private final boolean preventJemallocUsage;

    public ProcessWrapper(String exe, Map<String, String> environmentVariables, boolean preventJemallocUsage) {
        this.command.add(exe);
        this.environmentVariables = environmentVariables;
        this.preventJemallocUsage = preventJemallocUsage;
    }

    public ProcessWrapper(String exe) {
        this(exe, false);
    }

    public ProcessWrapper(String exe, boolean preventJemallocUsage) {
        this(exe, Map.of(), preventJemallocUsage);
    }

    public ProcessWrapper(String exe, Map<String, String> environmentVariables) {
        this(exe, environmentVariables, false);
    }

    public void addArgument(String argument) {
        this.command.add(argument);
    }

    public String getCommand() {
        ArrayList<Object> commandParts = new ArrayList<Object>();
        for (String commandPart : this.command) {
            if (!commandPart.contains(" ")) {
                commandParts.add(commandPart);
                continue;
            }
            boolean hasSingleQuotes = commandPart.contains("'");
            boolean hasDoubleQuotes = commandPart.contains("\"");
            if (!hasSingleQuotes) {
                commandParts.add("'" + commandPart + "'");
                continue;
            }
            if (hasSingleQuotes && !hasDoubleQuotes) {
                commandParts.add("\"" + commandPart + "\"");
                continue;
            }
            commandParts.add(commandPart);
        }
        return String.join((CharSequence)" ", commandParts);
    }

    public void setOutputConsumer(Consumer<String> outputConsumer) {
        this.outputConsumer = outputConsumer;
    }

    public void setErrorConsumer(Consumer<String> errorConsumer) {
        this.errorConsumer = errorConsumer;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public int run(long timeoutMinutes) throws IOException, TimeoutException {
        int returnCode;
        CCSMAssert.isNotNull(this.outputConsumer, (String)"Tried to run a process without output stream consumer");
        CCSMAssert.isNotNull(this.errorConsumer, (String)"Tried to run a process without error stream consumer");
        ProcessBuilder pb = new ProcessBuilder(this.command);
        pb.environment().putAll(this.environmentVariables);
        if (this.preventJemallocUsage) {
            AnalysisToolsConfigurationUtils.preventUsageOfJemalloc(pb);
        }
        if (this.workingDirectory != null) {
            pb.directory(this.workingDirectory);
        }
        if ((returnCode = ProcessUtils.execute((ProcessBuilder)pb, null, (long)(timeoutMinutes * 60L), (ProcessUtils.IStreamConsumer)new ProcessOutputReader(this.outputConsumer), (ProcessUtils.IStreamConsumer)new ProcessOutputReader(this.errorConsumer))) == -1) {
            throw new TimeoutException("Timeout while waiting for external clang-tidy process");
        }
        return returnCode;
    }

    private static void handleExceptionDuringProcessCall(Exception e, boolean writeExceptionsToErrorOutput, Consumer<String> errorConsumer) {
        if (writeExceptionsToErrorOutput) {
            errorConsumer.accept(e.getMessage());
        } else {
            LOGGER.error((Object)e);
        }
    }

    public int runWithTimeout(int timeoutMinutes) {
        int returnCode = -1;
        try {
            returnCode = this.run(timeoutMinutes);
        }
        catch (IOException e) {
            ProcessWrapper.handleExceptionDuringProcessCall(e, this.writeExceptionsToErrorOutput, this.errorConsumer);
        }
        catch (TimeoutException e) {
            if (this.writeExceptionsToErrorOutput) {
                this.errorConsumer.accept(String.format(TIMEOUT_MESSAGE_FORMAT_STRING, timeoutMinutes, this.getCommand()));
                this.errorConsumer.accept(e.getMessage());
            }
            LOGGER.error("Timeout (waited {} minutes) while running command: {}", (Object)timeoutMinutes, (Object)this.getCommand(), (Object)e);
        }
        return returnCode;
    }

    public int runWithTimeoutException(int timeoutMinutes) throws TimeoutException {
        int returnCode = -1;
        try {
            returnCode = this.run(timeoutMinutes);
        }
        catch (IOException e) {
            ProcessWrapper.handleExceptionDuringProcessCall(e, this.writeExceptionsToErrorOutput, this.errorConsumer);
        }
        return returnCode;
    }

    private static class ProcessOutputReader
    implements ProcessUtils.IStreamConsumer {
        private final Consumer<String> outputHandler;

        private ProcessOutputReader(Consumer<String> outputHandler) {
            CCSMAssert.isNotNull(outputHandler, (String)"The outputHandler consumer of the ProcessOutputReader may not be null");
            this.outputHandler = outputHandler;
        }

        public void consume(InputStream stream) throws IOException {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, ProcessUtils.CONSOLE_CHARSET));){
                String line;
                while ((line = reader.readLine()) != null) {
                    this.outputHandler.accept(line);
                }
            }
        }
    }
}

