/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.flake8;

import com.teamscale.index.configuration.tools.Flake8Configuration;
import com.teamscale.index.findings.PythonRunner;
import com.teamscale.index.findings.flake8.Flake8VersionInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.error.FormatException;
import org.conqat.lib.commons.filesystem.CanonicalFile;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.io.ProcessUtils;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.SimpleNLPUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

class Flake8Runner {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String FLAKE8_EXEC = "flake8";
    private static final int OUTPUT_LINE_LENGTH = 4096;
    private static final PythonRunner PYTHON_RUNNER = new PythonRunner("flake8", 4096);
    private static final String CONFIG_FILE_NAME = "flake8.cfg";
    private static final int ANALYSIS_EXEC_TIMEOUT = 1200;
    private static final String MAX_PARALLEL_JOBS_VM_OPTION = "com.teamscale.flake8.max-parallel-jobs";
    private static final int MAX_PARALLEL_JOBS = Integer.getInteger("com.teamscale.flake8.max-parallel-jobs", 2);
    private static final String REPORT_LINE_FORMAT = "%(code)s;%(row)d;%(col)d;%(text)s -- %(path)s";
    private static final Pattern MESSAGE_PATH_SEPARATOR = Pattern.compile("(.*) -- (.*?)");
    static final Pattern BACKTICK_PATTERN = Pattern.compile("`.*?`");
    static final Pattern END_OF_SENTENCE_PATTERN = Pattern.compile("[^.][.](\\s+|$)");

    Flake8Runner() {
    }

    private static @NonNull Flake8VersionInfo loadExpectedFlake8Version() throws FormatException {
        String expectedVersionRaw = Resource.of(Flake8Configuration.class, (String)"flake8/version.txt").getContent();
        return Flake8VersionInfo.parse(expectedVersionRaw);
    }

    public static @NonNull String executeVersionInfoRaw() throws IOException {
        ProcessUtils.ExecutionResult result = PYTHON_RUNNER.exec(null, 10, "--version");
        return result.getStdout().trim();
    }

    public static @NonNull Flake8VersionInfo executeVersionInfo() throws IOException, FormatException {
        return Flake8VersionInfo.parse(Flake8Runner.executeVersionInfoRaw());
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ProcessUtils.ExecutionResult executeAnalysisRaw(@Nullable CanonicalFile workingDir) throws IOException {
        return PYTHON_RUNNER.exec((File)workingDir, 1200, "--config=flake8.cfg", "--jobs=" + MAX_PARALLEL_JOBS, "--format=%(code)s;%(row)d;%(col)d;%(text)s -- %(path)s", "--exit-zero", "--disable-noqa");
    }

    public static @NonNull List<FindingInfo> executeAnalysis(@Nullable CanonicalFile workingDir) throws IOException {
        ProcessUtils.ExecutionResult executionResult = Flake8Runner.executeAnalysisRaw(workingDir);
        String analysisReport = executionResult.getStdout();
        if (StringUtils.isEmpty((String)analysisReport)) {
            return CollectionUtils.emptyList();
        }
        return Flake8Runner.parseRawAnalysisResults(analysisReport);
    }

    public static void prepareWorkingDirAndConfig(@NonNull CanonicalFile workingDir, @NonNull Set<String> enabledChecks, @Nullable Map<String, String> options) throws IOException {
        FileSystemUtils.ensureDirectoryExists((File)workingDir);
        CanonicalFile configFile = new CanonicalFile((File)workingDir, CONFIG_FILE_NAME);
        String configuration = Flake8Runner.generateConfigFileContent(enabledChecks, options);
        FileSystemUtils.writeFileUTF8((File)configFile, (String)configuration);
    }

    @VisibleForTesting
    static @NonNull String generateConfigFileContent(@NonNull Set<String> enabledChecks, @Nullable Map<String, String> options) {
        CCSMAssert.isTrue((enabledChecks != null && !enabledChecks.isEmpty() ? 1 : 0) != 0, (String)"At least one check must be enabled");
        Object joinedOptions = "";
        if (!CollectionUtils.isNullOrEmpty(options)) {
            joinedOptions = "\n" + options.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> (String)e.getKey() + " = " + (String)e.getValue()).collect(Collectors.joining("\n")) + "\n";
        }
        String joinedCheckIds = enabledChecks.stream().map(Flake8Configuration::stripCheckIdPrefix).sorted().collect(Collectors.joining(",\n\t"));
        return "[flake8]\nselect =\n\t" + joinedCheckIds + "\n" + (String)joinedOptions;
    }

    public static void verifyFlake8Version() throws ConQATException {
        try {
            Flake8VersionInfo expectedVersion = Flake8Runner.loadExpectedFlake8Version();
            Flake8VersionInfo installedVersion = Flake8Runner.executeVersionInfo();
            if (!expectedVersion.isCompatible(installedVersion)) {
                throw new ConQATException("Incompatible Flake8 version detected. Required version: " + String.valueOf(expectedVersion) + " Detected version: " + String.valueOf(installedVersion));
            }
        }
        catch (FormatException e) {
            throw new ConQATException("Could not parse Flake8 version. Ensure that a compatible Flake8 version is installed.", (Throwable)e);
        }
        catch (IOException e) {
            PythonRunner.verifyPythonExecutable();
            throw new ConQATException("Error during Flake8 execution. Ensure that compatible Python3 and Flake8 versions are installed.", (Throwable)e);
        }
    }

    @VisibleForTesting
    static @NonNull List<FindingInfo> parseRawAnalysisResults(@Nullable String rawResults) {
        if (StringUtils.isEmpty((String)rawResults)) {
            return CollectionUtils.emptyList();
        }
        String[] rawLines = StringUtils.splitLines((String)rawResults);
        ArrayList<FindingInfo> parsedFindings = new ArrayList<FindingInfo>(rawLines.length);
        for (String rawLine : rawLines) {
            Flake8Runner.parseRawResultLine(rawLine, parsedFindings);
        }
        return parsedFindings;
    }

    private static void parseRawResultLine(@NonNull String rawLine, @NonNull List<FindingInfo> parsedFindings) {
        try {
            String[] parts = rawLine.split(";", 4);
            if (parts.length != 4) {
                Flake8Runner.logParseError("wrong split", rawLine, null);
                return;
            }
            Pair<String, String> messageAndPath = Flake8Runner.parseResultMessageAndPath(rawLine, parts);
            if (messageAndPath == null) {
                return;
            }
            String checkId = parts[0];
            if (StringUtils.isEmpty((String)checkId)) {
                Flake8Runner.logParseError("missing checkID", rawLine, null);
                return;
            }
            int row = Integer.parseInt(parts[1]);
            int column = Integer.parseInt(parts[2]);
            parsedFindings.add(new FindingInfo(checkId, row, column, (String)messageAndPath.getFirst(), (String)messageAndPath.getSecond()));
        }
        catch (NumberFormatException e) {
            Flake8Runner.logParseError("number parsing failed", rawLine, e);
        }
    }

    private static @Nullable Pair<String, String> parseResultMessageAndPath(@NonNull String rawLine, String @NonNull [] parts) {
        Matcher matcher = MESSAGE_PATH_SEPARATOR.matcher(parts[3]);
        if (!matcher.matches()) {
            Flake8Runner.logParseError("wrong message/path separation", rawLine, null);
            return null;
        }
        String message = matcher.group(1);
        if (StringUtils.isEmpty((String)message)) {
            Flake8Runner.logParseError("missing message", rawLine, null);
            return null;
        }
        String path = matcher.group(2);
        if (StringUtils.isEmpty((String)path)) {
            Flake8Runner.logParseError("missing path", rawLine, null);
            return null;
        }
        return Pair.createPair((Object)message, (Object)path);
    }

    private static void logParseError(@NonNull String messageDetails, @NonNull String rawLine, @Nullable Throwable throwable) {
        if (throwable != null) {
            LOGGER.error("Cannot parse Flake8 result line; {}. Line is skipped: '{}'", (Object)messageDetails, (Object)rawLine, (Object)throwable);
        } else {
            LOGGER.error("Cannot parse Flake8 result line; {}. Line is skipped: '{}'", (Object)messageDetails, (Object)rawLine);
        }
    }

    static @NonNull String shortenAndFilterFindingMessage(@NonNull String message) {
        String cleanedMessage = message.replace("``", "`");
        if (cleanedMessage.length() <= 200) {
            return cleanedMessage;
        }
        String filteredMessage = SimpleNLPUtils.removeIgnoredSubstrings((Pattern)BACKTICK_PATTERN, (String)cleanedMessage);
        Matcher matcher = END_OF_SENTENCE_PATTERN.matcher(filteredMessage);
        String newMessage = cleanedMessage;
        if (matcher.find()) {
            newMessage = cleanedMessage.substring(0, matcher.start() + 1);
        }
        return StringUtils.truncateWithEllipsis((String)newMessage, (int)300);
    }

    public record FindingInfo(String checkId, int row, int column, String message, String path) {
    }
}

