/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.sonarlint;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.findings.IndexFindingUtils;
import com.teamscale.index.configuration.tools.message.SonarLintMessageManager;
import com.teamscale.index.findings.FindingsSynchronizingAnalyzingStepBase;
import com.teamscale.index.findings.sonarlint.SonarLintFinding;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class SonarLintFindingsSynchronizerBase
extends FindingsSynchronizingAnalyzingStepBase {
    private static final UnmodifiableList<String> FINDING_MESSAGE_ARTIFACTS_TO_REMOVE = CollectionUtils.asUnmodifiable(Arrays.asList(Pattern.quote(" to \"org.sonar.java.resolve.Symbols$UnknownType") + ".*", "\\(sonar\\.java\\.source not set\\. Assuming \\d+ or greater\\.\\)"));
    @VisibleForTesting
    public static final String FINDING_PARTITION = "sonarlint";
    private static final Pattern LITERAL_TERM_PATTERN = Pattern.compile("`[^\\s]+`");
    private static final UnmodifiableList<Pattern> IDENTIFIER_PATTERNS = CollectionUtils.asUnmodifiable(Stream.of(new Pair((Object)"\"", (Object)"\""), new Pair((Object)"\u201c", (Object)"\u201d"), new Pair((Object)"\u201d", (Object)"\u201d")).map(affix -> Pattern.compile((String)affix.getFirst() + "([\\w+.\\\\_]+)" + (String)affix.getSecond())).toList());
    private final Map<String, LineOffsetConverter> convertersByPath = new HashMap<String, LineOffsetConverter>();

    protected void synchronizeFindings(CodeScopeAware<ListMap<String, IndexFinding>> findingsByPathPerCodeScope) throws StorageException {
        this.synchronizeFindings(findingsByPathPerCodeScope, FINDING_PARTITION);
    }

    protected ListMap<String, IndexFinding> toIndexFindings(ListMap<String, SonarLintFinding> findingsByPath, Map<String, BasicTokenElementInfo> elementsByPath) {
        ListMap result = new ListMap();
        for (Map.Entry entry : findingsByPath.entrySet()) {
            String path = (String)entry.getKey();
            result.addAll((Object)path, (Collection)CollectionUtils.map((Collection)((Collection)entry.getValue()), finding -> this.createIndexFinding((SonarLintFinding)finding, path, elementsByPath)));
        }
        return result;
    }

    private IndexFinding createIndexFinding(SonarLintFinding sonarLintFinding, String path, Map<String, BasicTokenElementInfo> elementsByPath) {
        ElementLocation location;
        if (sonarLintFinding.getStartLine() == null) {
            location = new ElementLocation(path);
        } else {
            if (!elementsByPath.containsKey(path) || elementsByPath.get(path) == null) {
                throw new IllegalArgumentException("Elements for path '" + path + "' not found.");
            }
            LineOffsetConverter converter = this.convertersByPath.computeIfAbsent(path, p -> new LineOffsetConverter(((BasicTokenElementInfo)elementsByPath.get(p)).getText()));
            int rawStartOffset = converter.getOffset(sonarLintFinding.getStartLine().intValue());
            if (sonarLintFinding.getStartLineOffset() != null) {
                rawStartOffset += sonarLintFinding.getStartLineOffset().intValue();
            }
            int rawEndOffset = converter.getOffset(sonarLintFinding.getEndLine().intValue());
            if (sonarLintFinding.getEndLineOffset() != null) {
                rawEndOffset += sonarLintFinding.getEndLineOffset().intValue();
            }
            location = new TextRegionLocation(path, rawStartOffset, rawEndOffset, sonarLintFinding.getStartLine().intValue(), sonarLintFinding.getEndLine().intValue());
        }
        String checkId = SonarLintMessageManager.getInstance().getCheckMappingBySonarRuleKey((String)sonarLintFinding.getRuleKey()).checkId;
        IndexFinding finding = new IndexFinding(checkId, FINDING_PARTITION, SonarLintFindingsSynchronizerBase.adaptMessageAndEscapeMarkdown(sonarLintFinding.getMessage()), location);
        ELanguage language = elementsByPath.get(path).getLanguage();
        IndexFindingUtils.setGuidelineMapping((IndexFinding)finding, (String)checkId, (ELanguage)language);
        return finding;
    }

    @VisibleForTesting
    public static String adaptMessageAndEscapeMarkdown(String message) {
        for (String findingMessageArtifact : FINDING_MESSAGE_ARTIFACTS_TO_REMOVE) {
            message = message.replaceAll(findingMessageArtifact, "");
        }
        message = StringUtils.escapeMarkdownChars((String)message);
        for (Pattern identifierPattern : IDENTIFIER_PATTERNS) {
            message = StringUtils.replaceAll((String)message, (Pattern)identifierPattern, (String)"`$1`");
        }
        message = message.trim();
        message = SonarLintFindingsSynchronizerBase.unescapeLiteralExpressions(message);
        return StringUtils.stripSuffix((String)message, (String)".");
    }

    private static String unescapeLiteralExpressions(String message) {
        return LITERAL_TERM_PATTERN.matcher(message).replaceAll(result -> StringUtils.unescapeMarkdownChars((String)result.group()));
    }
}

