/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.sonarlint;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.index.configuration.tools.message.SonarLintMessageManager;
import com.teamscale.index.findings.sonarlint.SonarLintEnginePool;
import com.teamscale.index.findings.sonarlint.SonarLintFinding;
import com.teamscale.index.findings.sonarlint.SonarLintInputFile;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.core.registry.CheckMapping;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.filesystem.ClassPathUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.sonarsource.sonarlint.core.analysis.api.ClientInputFile;
import org.sonarsource.sonarlint.core.client.api.common.RuleDetails;
import org.sonarsource.sonarlint.core.client.api.common.analysis.Issue;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneAnalysisConfiguration;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneRuleDetails;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneSonarLintEngine;
import org.sonarsource.sonarlint.core.commons.RuleKey;

public class SonarLintProcess {
    private final List<String> selectedOptions;
    private final List<String> checkOptionValues;
    private final @Nullable String javaSourceLevel;
    private static final Logger LOGGER = LogManager.getLogger();
    public static final UnmodifiableSet<ELanguage> ANALYZED_LANGUAGES;

    public SonarLintProcess(List<String> selectedOptions, List<String> checkOptionValues, @Nullable String javaSourceLevel) {
        this.selectedOptions = selectedOptions;
        this.checkOptionValues = checkOptionValues;
        this.javaSourceLevel = javaSourceLevel;
    }

    public ListMap<String, SonarLintFinding> execute(StandaloneSonarLintEngine engine, File tempDirectory, List<RuleKey> includedRules, Map<String, TokenElementInfo> elementsByPath) throws ProjectConfigurationException {
        SonarLintFindingsCollector findingsCollector = new SonarLintFindingsCollector(elementsByPath);
        this.execute(engine, tempDirectory, includedRules, elementsByPath, findingsCollector);
        return findingsCollector.getFindings();
    }

    private void execute(StandaloneSonarLintEngine engine, File tempDirectory, List<RuleKey> includedRules, Map<String, TokenElementInfo> elementsByPath, SonarLintFindingsCollector sonarLintFindingsCollector) {
        block4: {
            ArrayList<RuleKey> excludedRules = new ArrayList<RuleKey>();
            Set includedRuleIds = includedRules.stream().map(RuleKey::toString).collect(Collectors.toSet());
            for (RuleDetails rule : engine.getAllRuleDetails()) {
                if (includedRuleIds.contains(rule.getKey())) continue;
                RuleKey ruleKey = RuleKey.parse((String)rule.getKey());
                excludedRules.add(ruleKey);
            }
            StandaloneAnalysisConfiguration configuration = this.createSonarLintConfiguration(tempDirectory, includedRules, elementsByPath.values(), excludedRules, this.buildParameterMap(engine));
            try {
                SonarLintProcess.ensureDirectoryIsNotEmpty(tempDirectory);
                engine.analyze(configuration, sonarLintFindingsCollector::handleIssue, SonarLintEnginePool.createSonarMessageLogger(LOGGER), null);
            }
            catch (Throwable t) {
                LOGGER.error("Error while executing sonarlint", t);
                if (elementsByPath.size() <= 1) break block4;
                LOGGER.warn("SonarLint had errors. Re-running on files in isolation.");
                for (Map.Entry<String, TokenElementInfo> entry : elementsByPath.entrySet()) {
                    this.execute(engine, tempDirectory, includedRules, Collections.singletonMap(entry.getKey(), entry.getValue()), sonarLintFindingsCollector);
                }
            }
        }
    }

    private static void ensureDirectoryIsNotEmpty(File tempDirectory) {
        try {
            new File(tempDirectory, "teamscale-dummy-file.js").createNewFile();
        }
        catch (IOException e) {
            LOGGER.error("Could not create empty dummy file in SonarLint temp directory {}", (Object)tempDirectory.getAbsolutePath(), (Object)e);
        }
    }

    private Map<RuleKey, Map<String, String>> buildParameterMap(StandaloneSonarLintEngine engine) {
        HashMap<RuleKey, Map<String, String>> parameters = new HashMap<RuleKey, Map<String, String>>();
        for (int i = 0; i < this.selectedOptions.size(); ++i) {
            String checkId = StringUtils.getFirstPart((String)this.selectedOptions.get(i), (String)"#");
            String optionsId = StringUtils.getLastPart((String)this.selectedOptions.get(i), (String)"#");
            String optionsValue = this.checkOptionValues.get(i);
            Optional rule = engine.getRuleDetails(checkId);
            if (rule.isPresent()) {
                RuleKey ruleKey = RuleKey.parse((String)((StandaloneRuleDetails)rule.get()).getKey());
                Map<String, String> values = new HashMap<String, String>();
                if (parameters.containsKey(ruleKey)) {
                    values = (Map)parameters.get(ruleKey);
                }
                values.put(optionsId, optionsValue);
                parameters.put(ruleKey, values);
                continue;
            }
            LOGGER.warn("SonarLint option '{}' belongs to unknown check '{}'.", (Object)optionsId, (Object)checkId);
        }
        return parameters;
    }

    private StandaloneAnalysisConfiguration createSonarLintConfiguration(File tempDirectory, List<RuleKey> includedRules, Collection<TokenElementInfo> elements, List<RuleKey> excludedRules, Map<RuleKey, Map<String, String>> parameters) {
        StandaloneAnalysisConfiguration.Builder configurationBuilder = ((StandaloneAnalysisConfiguration.Builder)((StandaloneAnalysisConfiguration.Builder)StandaloneAnalysisConfiguration.builder().addInputFiles((Collection)CollectionUtils.map(elements, SonarLintInputFile::new))).addIncludedRules(includedRules).addExcludedRules(excludedRules).setBaseDir(tempDirectory.toPath())).addRuleParameters(parameters);
        SonarLintProcess.preventWarnings(configurationBuilder, tempDirectory);
        if (!StringUtils.isEmpty((String)this.javaSourceLevel)) {
            configurationBuilder.putExtraProperty("sonar.java.source", this.javaSourceLevel);
        }
        return configurationBuilder.build();
    }

    private static void preventWarnings(StandaloneAnalysisConfiguration.Builder configurationBuilder, File tempDirectory) {
        configurationBuilder.putExtraProperty("sonar.sourceEncoding", "UTF-8");
        configurationBuilder.putExtraProperty("sonar.java.binaries", tempDirectory.getAbsolutePath());
        File log4jJarFile = FileSystemUtils.extractJarFileFromJarURL((URL)ClassPathUtils.obtainClassFileURL(Logger.class));
        configurationBuilder.putExtraProperty("sonar.java.libraries", log4jJarFile.getAbsolutePath());
        configurationBuilder.putExtraProperty("sonar.java.test.libraries", log4jJarFile.getAbsolutePath());
    }

    static {
        EnumSet<ELanguage> analyzedLanguages = EnumSet.noneOf(ELanguage.class);
        try {
            SonarLintMessageManager messageManager = SonarLintMessageManager.getInstance();
            for (CheckMapping rule : messageManager.getRules()) {
                analyzedLanguages.add(SonarLintMessageManager.getRuleLanguage(rule.checkId));
            }
            ANALYZED_LANGUAGES = CollectionUtils.asUnmodifiable(analyzedLanguages);
        }
        catch (ProjectConfigurationException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static class SonarLintFindingsCollector {
        private final ListMap<String, SonarLintFinding> findings = new ListMap();
        private final Map<String, TokenElementInfo> elementsByPath;

        private SonarLintFindingsCollector(Map<String, TokenElementInfo> elementsByPath) {
            this.elementsByPath = elementsByPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ListMap<String, SonarLintFinding> getFindings() {
            ListMap<String, SonarLintFinding> listMap = this.findings;
            synchronized (listMap) {
                return new ListMap(this.findings);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleIssue(Issue issue) {
            ClientInputFile inputFile = issue.getInputFile();
            if (inputFile == null) {
                LOGGER.error("Encountered SonarLint issue without affected file: {} ({})", (Object)issue.getMessage(), (Object)issue);
                return;
            }
            String uniformPath = inputFile.relativePath();
            TokenElementInfo element = this.elementsByPath.get(uniformPath);
            if (element == null) {
                LOGGER.warn("SonarLint rule {} returned finding for file {} that was not part of the input!", (Object)issue.getRuleKey(), (Object)uniformPath);
                return;
            }
            if (element.isFilteredCompletely()) {
                return;
            }
            SonarLintFinding finding = SonarLintFinding.of(issue);
            ListMap<String, SonarLintFinding> listMap = this.findings;
            synchronized (listMap) {
                this.findings.add((Object)uniformPath, (Object)finding);
            }
        }
    }
}

