/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.cleanup;

import com.teamscale.index.issues.IIssueHistoryIndex;
import com.teamscale.index.issues.IssueIndexBase;
import com.teamscale.index.issues.cleanup.IWorkItemCleanupStrategy;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.function.SupplierWithException;

public class WorkItemCleaner<T extends TeamscaleIssue> {
    private final IssueIndexBase<T> issueIndex;
    private final @Nullable IIssueHistoryIndex<T> historyIndex;
    private final String connectorId;
    private final IWorkItemCleanupStrategy cleanupStrategy;

    public WorkItemCleaner(IssueIndexBase<T> issueIndex, @Nullable IIssueHistoryIndex<T> historyIndex, String connectorId, IWorkItemCleanupStrategy cleanupStrategy) {
        this.issueIndex = issueIndex;
        this.historyIndex = historyIndex;
        this.connectorId = connectorId;
        this.cleanupStrategy = cleanupStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Exception> Map<TeamscaleIssueId, Long> performCleanupIfNecessary(Instant removalTimestamp, SupplierWithException<Set<String>, E> allIdsFromExternalSystemSupplier) throws E, StorageException {
        if (this.cleanupStrategy.shouldPerformCleanup(removalTimestamp)) {
            try {
                Map<TeamscaleIssueId, Long> map = this.cleanupNoLongerPresentItems((Set)allIdsFromExternalSystemSupplier.get(), removalTimestamp);
                return map;
            }
            finally {
                this.cleanupStrategy.cleanupPerformed(removalTimestamp);
            }
        }
        return Collections.emptyMap();
    }

    private Map<TeamscaleIssueId, Long> cleanupNoLongerPresentItems(Set<String> allIdsFromExternalSystem, Instant removalTimestamp) throws StorageException {
        List<TeamscaleIssueId> allIdsStoredInTeamscale = this.issueIndex.getAllKeysForConnector(this.connectorId);
        List<TeamscaleIssueId> toDelete = allIdsStoredInTeamscale.stream().filter(issueId -> !allIdsFromExternalSystem.contains(issueId.getExternalId())).collect(Collectors.toList());
        if (toDelete.isEmpty()) {
            return Collections.emptyMap();
        }
        long timestamp = removalTimestamp.toEpochMilli();
        if (this.historyIndex != null) {
            this.historyIndex.remove(toDelete, timestamp);
        }
        return toDelete.stream().collect(Collectors.toMap(Function.identity(), ignored -> timestamp));
    }
}

