/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.metrics.threshold;

import com.teamscale.core.analysis.configuration.index.model.MetricThreshold;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfiguration;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdGroup;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdIdentifier;
import com.teamscale.index.metrics.threshold.PathMatchResult;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jetbrains.annotations.VisibleForTesting;

public final class MetricThresholdSelectionUtils {
    public static Optional<MetricThresholdIdentifier> findBestMatchingThresholdInConfiguration(MetricThresholdConfiguration thresholdConfiguration, String metricName, String metricPath) throws MetricThresholdConfigurationException {
        CCSMAssert.isNotNull((Object)thresholdConfiguration);
        MetricThresholdIdentifier bestCandidate = null;
        PathMatchResult candidateMatchResult = PathMatchResult.NO_MATCH;
        for (MetricThresholdGroup thresholdGroup : thresholdConfiguration.computeTransitiveMetricThresholdGroups()) {
            for (MetricThreshold threshold : thresholdGroup.getMetricThresholdList()) {
                PathMatchResult pathMatchResult;
                if (!MetricThresholdSelectionUtils.doesMetricNameMatch(threshold, metricName) || !(pathMatchResult = MetricThresholdSelectionUtils.computePathMatchResult(threshold, metricPath)).isBetterThan(candidateMatchResult)) continue;
                bestCandidate = new MetricThresholdIdentifier(thresholdGroup, threshold);
                candidateMatchResult = pathMatchResult;
                if (pathMatchResult != PathMatchResult.PERFECT_MATCH) continue;
                return Optional.of(bestCandidate);
            }
        }
        if (candidateMatchResult == PathMatchResult.NO_MATCH) {
            return Optional.empty();
        }
        return Optional.of(bestCandidate);
    }

    public static Optional<MetricThresholdIdentifier> findThresholdInConfigurationByDisplayName(MetricThresholdConfiguration thresholdConfiguration, String metricThresholdGroupName, String displayName) throws MetricThresholdConfigurationException {
        List matchingThresholdGroups = CollectionUtils.filter((Collection)thresholdConfiguration.computeTransitiveMetricThresholdGroups(), thresholdGroup -> MetricThresholdSelectionUtils.doesThresholdGroupNameMatch(thresholdGroup, metricThresholdGroupName));
        for (MetricThresholdGroup matchingThresholdGroup : matchingThresholdGroups) {
            for (MetricThreshold threshold : matchingThresholdGroup.getMetricThresholdList()) {
                if (!threshold.getDisplayName().equals(displayName)) continue;
                return Optional.of(new MetricThresholdIdentifier(matchingThresholdGroup, threshold));
            }
        }
        return Optional.empty();
    }

    private static boolean doesThresholdGroupNameMatch(MetricThresholdGroup thresholdGroup, String metricThresholdGroupName) {
        return thresholdGroup.getName().equals(metricThresholdGroupName);
    }

    private static boolean doesMetricNameMatch(MetricThreshold threshold, String metricName) {
        return threshold.getMetricName().equals(metricName);
    }

    @VisibleForTesting
    static PathMatchResult computePathMatchResult(MetricThreshold threshold, String metricPath) {
        String thresholdPath = StringUtils.emptyIfNull((String)threshold.getSubPath());
        return MetricThresholdSelectionUtils.computePathMatchResult(metricPath, thresholdPath);
    }

    @VisibleForTesting
    static PathMatchResult computePathMatchResult(String metricPath, String thresholdPath) {
        String normalizedThresholdPath;
        String normalizedMetricPath = MetricThresholdSelectionUtils.normalizePath(metricPath);
        if (normalizedMetricPath.equals(normalizedThresholdPath = MetricThresholdSelectionUtils.normalizePath(thresholdPath))) {
            return PathMatchResult.PERFECT_MATCH;
        }
        if (normalizedMetricPath.startsWith(normalizedThresholdPath)) {
            String unmatchedPathSuffix = StringUtils.stripPrefix((String)normalizedMetricPath.substring(normalizedThresholdPath.length()), (String)UniformPathUtils.SEPARATOR);
            return PathMatchResult.partialMatch(unmatchedPathSuffix.split(UniformPathUtils.SEPARATOR).length);
        }
        return PathMatchResult.NO_MATCH;
    }

    private static String normalizePath(String path) {
        String normalizedPath = UniformPathUtils.normalizeAllSeparators((String)path);
        normalizedPath = StringUtils.stripPrefix((String)normalizedPath, (String)UniformPathUtils.SEPARATOR);
        normalizedPath = StringUtils.stripSuffix((String)normalizedPath, (String)UniformPathUtils.SEPARATOR);
        return normalizedPath;
    }

    private MetricThresholdSelectionUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

