/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.precommit;

import com.teamscale.core.analysis.BranchingLayerAccess;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.analysis.trigger.ChangeRetrieverAnalysisStep;
import com.teamscale.core.analysis.trigger.RollbackRequestedCommitDescriptor;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.core.precommit.PreCommitUtils;
import com.teamscale.index.precommit.PreCommitLimitsOption;
import com.teamscale.index.precommit.PreCommitUploadStagingIndex;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchCommitInfo;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.lang.SilentAutoClosable;

public class DeleteStalePreCommitBranchesTrigger
extends ChangeRetrieverAnalysisStep {
    public static final Duration SCHEDULING_INTERVAL = Duration.ofDays(1L);
    @GlobalIndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ServerOptionIndex serverOptionIndex;
    @BranchingLayerAccess(value=PreCommitUploadStagingIndex.class)
    private IBranchingLayer preCommitUploadStagingIndexBranchingLayer;

    protected CommitDescriptor executeAndReturnCommitResult() throws Exception {
        try (SilentAutoClosable ignoredUnlockAction = PreCommitUploadStagingIndex.obtainLock(this.getLockProvider(), this.getProjectId());){
            List<String> branchesToDelete = this.getBranchesToDelete();
            if (branchesToDelete.isEmpty()) {
                CommitDescriptor commitDescriptor = null;
                return commitDescriptor;
            }
            List<CommitDescriptor> rollbackCommits = branchesToDelete.stream().map(branch -> new CommitDescriptor(branch, 1L)).toList();
            this.preCommitUploadStagingIndexBranchingLayer.performRollback(rollbackCommits.stream().collect(Collectors.toMap(CommitDescriptor::getBranchName, CommitDescriptor::getTimestamp)));
            RollbackRequestedCommitDescriptor rollbackRequestedCommitDescriptor = new RollbackRequestedCommitDescriptor(rollbackCommits, "Scheduled due to pre-commit cleanup.");
            return rollbackRequestedCommitDescriptor;
        }
    }

    private List<String> getBranchesToDelete() throws StorageException {
        ListMap<String, IBranchCommitInfo> preCommitBranchesHeadCommitsPerUsers = this.getBranchesHeadCommitsPerUser();
        PreCommitLimitsOption preCommitLimits = (PreCommitLimitsOption)ServerOptionRegistry.getInstance().getServerOption("precommit.limit.options", PreCommitLimitsOption.class, this.serverOptionIndex);
        return DeleteStalePreCommitBranchesTrigger.getBranchesToDelete(preCommitBranchesHeadCommitsPerUsers, preCommitLimits);
    }

    private ListMap<String, IBranchCommitInfo> getBranchesHeadCommitsPerUser() throws StorageException {
        Set preCommitBranches = CollectionUtils.mapToSet((Collection)this.preCommitUploadStagingIndexBranchingLayer.getCommitInfos(), IBranchCommitInfo::getBranchName);
        ListMap preCommitBranchesHeadCommitsPerUsers = new ListMap();
        for (String preCommitBranch : preCommitBranches) {
            String username = PreCommitUtils.extractPrecommitUserName((String)preCommitBranch);
            IBranchCommitInfo headCommitForBranch = this.preCommitUploadStagingIndexBranchingLayer.getNewestCommitBeforeOrAt(preCommitBranch, Long.MAX_VALUE);
            if (headCommitForBranch == null) continue;
            preCommitBranchesHeadCommitsPerUsers.add((Object)username, (Object)headCommitForBranch);
        }
        return preCommitBranchesHeadCommitsPerUsers;
    }

    private static List<String> getBranchesToDelete(ListMap<String, IBranchCommitInfo> preCommitBranchesHeadCommitsPerUsers, PreCommitLimitsOption preCommitLimits) {
        Instant deadline = Instant.now().minus(Duration.ofDays(preCommitLimits.getMaxCommitAge()));
        ArrayList<String> result = new ArrayList<String>();
        ListMap activePreCommitBranchesHeadCommitsPerUser = new ListMap();
        for (String username : preCommitBranchesHeadCommitsPerUsers.getKeys()) {
            List preCommitBranchesHeadCommitsForUser = (List)preCommitBranchesHeadCommitsPerUsers.getCollection((Object)username);
            for (IBranchCommitInfo branchCommitInfo : preCommitBranchesHeadCommitsForUser) {
                String preCommitBranch = branchCommitInfo.getBranchName();
                if (!PreCommitUtils.isPrecommitBranchName((String)preCommitBranch)) continue;
                if (Instant.ofEpochMilli(branchCommitInfo.getTimestamp()).isBefore(deadline)) {
                    result.add(preCommitBranch);
                    continue;
                }
                activePreCommitBranchesHeadCommitsPerUser.add((Object)username, (Object)branchCommitInfo);
            }
        }
        result.addAll(DeleteStalePreCommitBranchesTrigger.getLimitPerUserExceedingPreCommitBranches((ListMap<String, IBranchCommitInfo>)activePreCommitBranchesHeadCommitsPerUser, preCommitLimits));
        return result;
    }

    private static List<String> getLimitPerUserExceedingPreCommitBranches(ListMap<String, IBranchCommitInfo> activePreCommitBranchesHeadCommitsPerUser, PreCommitLimitsOption preCommitLimits) {
        int maxUserBranches = preCommitLimits.getMaxUserBranches();
        ArrayList<String> result = new ArrayList<String>();
        for (String username : activePreCommitBranchesHeadCommitsPerUser.getKeys()) {
            List activePreCommitBranchesForUser = (List)activePreCommitBranchesHeadCommitsPerUser.getCollection((Object)username);
            if (activePreCommitBranchesForUser.size() <= maxUserBranches) continue;
            List<String> limitPerUserExceedingPreCommitBranches = activePreCommitBranchesForUser.stream().sorted(Comparator.comparing(IBranchCommitInfo::getTimestamp)).map(IBranchCommitInfo::getBranchName).limit(activePreCommitBranchesForUser.size() - maxUserBranches).toList();
            result.addAll(limitPerUserExceedingPreCommitBranches);
        }
        return result;
    }
}

