/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.parser;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoCompilationCommand;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.index.report.parser.ReportParserBase;
import com.teamscale.index.resource.CompilationCommand;
import com.teamscale.index.resource.element_details.EIncludePathSearchType;
import com.teamscale.index.resource.element_details.IncludePathDetail;
import com.teamscale.index.resource.path_lookup.PathLookupOptions;
import com.teamscale.reportparser.parser.ReportParserException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class CompilationDatabaseReportParser
extends ReportParserBase {
    private static final Set<Pattern> RELEVANT_CLANG_OPTIONS_WITHOUT_ARG = Set.of(Pattern.compile("[-/]std"), Pattern.compile("[-/]ansi"), Pattern.compile("[-/]ObjC"), Pattern.compile("[-/]ObjC\\+\\+"), Pattern.compile("[-/]f"), Pattern.compile("[-/]march"), Pattern.compile("[-/]O[0-9A-Za-z]+"), Pattern.compile("[-/]W"), Pattern.compile("[-/]v"), Pattern.compile("[-/]U"), Pattern.compile("[-/]no[a-z]*"));
    private static final Set<String> RELEVANT_CLANG_OPTIONS_WITH_ARG = Set.of("-x", "/x", "-arch", "/arch", "-target", "/target", "-Xanalyzer", "-Xpreprocessor");
    private ExternalAnalysisImportInfos result;

    @Override
    protected void resetState() {
        super.resetState();
        this.result = null;
    }

    @Override
    protected void parseStringReportInternal(String report, @Nullable String reportPath) throws ReportParserException {
        try {
            CompileCommandJson[] compileCommands = (CompileCommandJson[])JsonUtils.deserializeFromJsonWithNullCheck((String)report, CompileCommandJson[].class);
            this.result = new ExternalAnalysisImportInfos();
            HashSet<String> seenCompilationTargets = new HashSet<String>();
            for (CompileCommandJson compileCommand : compileCommands) {
                LOGGER.debug("Parsing compile command: {}", (Object)compileCommand);
                if (seenCompilationTargets.add(compileCommand.file)) {
                    this.parseCommand(compileCommand).ifPresent(this.result::addInfo);
                    continue;
                }
                LOGGER.error("Multiple entries in compilation database {} found for file {}. Skipping the entry.", (Object)reportPath, (Object)compileCommand.file);
            }
        }
        catch (ConQATException e) {
            throw new ReportParserException((Throwable)e);
        }
    }

    private Optional<ExternalAnalysisImportInfoCompilationCommand> parseCommand(CompileCommandJson compileCommand) throws ReportParserException, StorageException {
        if (compileCommand.command == null && compileCommand.arguments == null) {
            throw new ReportParserException("Both command and arguments are null for entry for file " + compileCommand.file + ", which is not allowed!");
        }
        Optional<String> lookedUpPath = this.matchingPathsLookup.lookupBestPath(compileCommand.file, PathLookupOptions.defaults());
        if (lookedUpPath.isEmpty()) {
            LOGGER.warn("Obtained external results for a file that is not in the index: {}", (Object)compileCommand.file);
            return Optional.empty();
        }
        String codeDirectory = null;
        if (compileCommand.file.endsWith(lookedUpPath.get())) {
            codeDirectory = compileCommand.file.substring(0, compileCommand.file.length() - lookedUpPath.get().length());
        }
        if (compileCommand.arguments == null) {
            compileCommand.arguments = CompilationDatabaseReportParser.splitCommand(compileCommand.command);
        }
        IncludePathDetail includePath = new IncludePathDetail();
        ArrayList<String> definitions = new ArrayList<String>();
        ArrayList<String> otherOptions = new ArrayList<String>();
        Iterator<String> argumentIterator = Arrays.stream(compileCommand.arguments).iterator();
        CCSMAssert.isTrue((boolean)argumentIterator.hasNext(), (String)("Compilation command entry is invalid for file" + compileCommand.file));
        String compilerCommand = CompilationDatabaseReportParser.normalizeCompilerCommand((String)argumentIterator.next());
        CompilationDatabaseReportParser.parseArguments(compileCommand, argumentIterator, includePath, definitions, otherOptions, codeDirectory);
        CompilationCommand compilationCommand = new CompilationCommand(includePath, definitions, compilerCommand, otherOptions);
        return Optional.of(new ExternalAnalysisImportInfoCompilationCommand(lookedUpPath.get(), compilationCommand));
    }

    private static void parseArguments(CompileCommandJson compileCommand, Iterator<String> argumentIterator, IncludePathDetail includePath, List<String> definitions, List<String> otherOptions, @Nullable String codeDirectory) {
        while (argumentIterator.hasNext()) {
            String argument = argumentIterator.next();
            EIncludePathSearchType searchType = EIncludePathSearchType.typeOf(argument).orElse(null);
            if (searchType != null) {
                String searchPath;
                if (argument.length() == searchType.getOptionString().length()) {
                    CCSMAssert.isTrue((boolean)argumentIterator.hasNext(), (String)("Missing path for the compiler search path option " + argument));
                    searchPath = argumentIterator.next();
                } else {
                    searchPath = argument.substring(searchType.getOptionString().length());
                }
                includePath.addToPath(searchType, CompilationDatabaseReportParser.resolveIncludePath(StringUtils.stripPrefix((String)searchPath, (String)"="), compileCommand.directory, codeDirectory));
                continue;
            }
            if (argument.startsWith("-D") || argument.startsWith("/D")) {
                Object definition = argument;
                if (argument.length() == 2) {
                    CCSMAssert.isTrue((boolean)argumentIterator.hasNext(), (String)("Missing definition after " + argument));
                    definition = (String)definition + argumentIterator.next();
                }
                definitions.add((String)definition);
                continue;
            }
            if (RELEVANT_CLANG_OPTIONS_WITHOUT_ARG.stream().anyMatch(pattern -> pattern.matcher(argument).matches())) {
                otherOptions.add(argument);
                continue;
            }
            if (!RELEVANT_CLANG_OPTIONS_WITH_ARG.stream().anyMatch(argument::equals)) continue;
            CCSMAssert.isTrue((boolean)argumentIterator.hasNext(), (String)("Missing argument for the compiler option " + argument));
            otherOptions.add(argument);
            otherOptions.add(argumentIterator.next());
        }
    }

    @VisibleForTesting
    static @NonNull String normalizeCompilerCommand(@NonNull String compilerExecutable) {
        int lastPathSeparatorIndex = compilerExecutable.lastIndexOf(47);
        if (lastPathSeparatorIndex > 0) {
            return compilerExecutable.substring(lastPathSeparatorIndex + 1);
        }
        lastPathSeparatorIndex = compilerExecutable.lastIndexOf(92);
        if (lastPathSeparatorIndex > 0) {
            return compilerExecutable.substring(lastPathSeparatorIndex + 1);
        }
        return compilerExecutable;
    }

    private static String resolveIncludePath(String includePath, String commandDirectory, @Nullable String codeDirectory) {
        if (includePath.startsWith("/") || UniformPathUtils.DRIVE_LETTER_PATTERN.matcher(includePath).matches()) {
            return CompilationDatabaseReportParser.resolveAgainstCommandOrCodeDirectory(includePath, commandDirectory, codeDirectory);
        }
        return UniformPathUtils.cleanPath((String)includePath);
    }

    private static String resolveAgainstCommandOrCodeDirectory(String includePath, String commandDirectory, @Nullable String codeDirectory) {
        if (includePath.startsWith(commandDirectory)) {
            return UniformPathUtils.cleanPath((String)StringUtils.stripPrefix((String)includePath, (String)commandDirectory));
        }
        if (codeDirectory != null && includePath.startsWith(codeDirectory)) {
            return UniformPathUtils.cleanPath((String)StringUtils.stripPrefix((String)includePath, (String)codeDirectory));
        }
        return UniformPathUtils.normalizeAllSeparators((String)includePath);
    }

    @VisibleForTesting
    static String[] splitCommand(String command) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder currentPart = new StringBuilder();
        boolean inQuote = false;
        char quoteClosingCharacter = '.';
        for (int i = 0; i < command.length(); ++i) {
            char currentChar = command.charAt(i);
            if (currentChar == '\\' && i + 1 < command.length() && CompilationDatabaseReportParser.isEscapable(command.charAt(i + 1))) {
                currentPart.append(command.charAt(++i));
                continue;
            }
            if (inQuote && currentChar == quoteClosingCharacter) {
                inQuote = false;
                continue;
            }
            if (inQuote) {
                currentPart.append(currentChar);
                continue;
            }
            if (currentChar == '\"' || currentChar == '\'') {
                inQuote = true;
                quoteClosingCharacter = currentChar;
                continue;
            }
            if (Character.isWhitespace(currentChar)) {
                if (!currentPart.isEmpty()) {
                    result.add(currentPart.toString());
                }
                currentPart.setLength(0);
                continue;
            }
            currentPart.append(currentChar);
        }
        if (!currentPart.isEmpty()) {
            result.add(currentPart.toString());
        }
        return result.toArray(new String[result.size()]);
    }

    private static boolean isEscapable(char character) {
        return switch (character) {
            case ' ', '\"', '\'', '\\' -> true;
            default -> false;
        };
    }

    @Override
    protected ExternalAnalysisImportInfos convertToImportInfos() {
        return this.result;
    }

    private static class CompileCommandJson {
        @JsonProperty(value="directory")
        private String directory;
        @JsonProperty(value="file")
        private String file;
        @JsonProperty(value="command")
        private @Nullable String command;
        @JsonProperty(value="arguments")
        private String @Nullable [] arguments;
        @JsonProperty(value="output")
        private @Nullable String output;

        private CompileCommandJson() {
        }

        public String toString() {
            return "{directory='" + this.directory + "', file='" + this.file + "', command='" + this.command + "', arguments=" + Arrays.toString(this.arguments) + ", output='" + this.output + "'}";
        }
    }
}

