/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.parser.sap_code_inspector;

import com.teamscale.index.gitbridge.abap.code_inspector.CodeInspectorData;
import com.teamscale.index.gitbridge.abap.code_inspector.CodeInspectorGitUtils;
import com.teamscale.index.report.base.FindingCollectingReportParserBase;
import com.teamscale.index.report.parser.sap_code_inspector.CodePalFindings;
import com.teamscale.reportparser.parser.ReportParserException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class CodeInspectorJsonParser
extends FindingCollectingReportParserBase {
    @VisibleForTesting
    protected static final String EXTENDED_CHECK_0033_E_FINDING_TYPE_ID = "EXTENDED_CHECK[0033](E)";
    private static final String INACTIVE_OBJECTS_FINDING_PROPERTY = "Inactive Objects";
    private final PairList<String, List<CodeInspectorData>> entries = new PairList();
    private static final Pattern LONG_MESSAGE_PARSE_PATTERN = Pattern.compile("^(The following sequence .*?): ?(.+)?");
    @VisibleForTesting
    static final String CALL_SEQUENCE_PROPERTY = "call sequence";

    @Override
    protected void resetState() {
        super.resetState();
        this.entries.clear();
    }

    @Override
    protected void parseStringReportInternal(String report, @Nullable String reportPath) throws ReportParserException {
        try {
            CCSMAssert.isNotNull((Object)reportPath);
            this.entries.add((Object)reportPath, Arrays.asList((CodeInspectorData[])JsonUtils.deserializeFromJson((String)report, CodeInspectorData[].class)));
        }
        catch (ConQATException e) {
            throw new ReportParserException((Throwable)e);
        }
    }

    @Override
    protected void collectFindings() throws StorageException {
        for (Pair entry : this.entries) {
            String reportFileName = (String)entry.getFirst();
            List data = (List)entry.getSecond();
            String reportPath = CodeInspectorGitUtils.buildAbapFileName(reportFileName);
            Optional<String> uniformPath = this.resolvePath(reportPath);
            if (uniformPath.isEmpty()) continue;
            this.initializeFindingsListForPath(uniformPath.get());
            for (CodeInspectorData dataEntry : data) {
                DetachedFinding finding = CodePalFindings.canHandleCodeInspectorCheckId(dataEntry.getObjectTypeName()) ? CodePalFindings.createFindingForCodePalSciEntry(uniformPath.get(), dataEntry) : CodeInspectorJsonParser.createFinding(uniformPath.get(), dataEntry.getStartLine(), dataEntry.getFindingTypeId(), dataEntry.getMessage());
                if (finding == null) continue;
                this.addFindingForPath(uniformPath.get(), finding);
            }
        }
    }

    @VisibleForTesting
    static DetachedFinding createFinding(String uniformPath, int startLine, String findingTypeId, String message) {
        Matcher matcher = LONG_MESSAGE_PARSE_PATTERN.matcher(message);
        if (matcher.matches()) {
            return CodeInspectorJsonParser.createLongMessageFinding(matcher, startLine, uniformPath, findingTypeId);
        }
        if (EXTENDED_CHECK_0033_E_FINDING_TYPE_ID.equals(findingTypeId)) {
            return CodeInspectorJsonParser.createInactiveObjectsFinding(uniformPath, startLine, findingTypeId, message);
        }
        return CodeInspectorJsonParser.createCodeInspectorFinding(startLine, uniformPath, findingTypeId, message);
    }

    private static @NonNull DetachedFinding createInactiveObjectsFinding(String uniformPath, int startLine, String findingTypeId, String message) {
        int secondDotIndex = StringUtils.indexOfNthOccurrence((String)message, (char)'.', (int)2);
        String details = "";
        if (secondDotIndex != -1) {
            details = message.substring(secondDotIndex + 1).trim().replace('.', '\n');
            message = message.substring(0, secondDotIndex + 1);
        }
        DetachedFinding finding = CodeInspectorJsonParser.createCodeInspectorFinding(startLine, uniformPath, findingTypeId, message);
        finding.setProperty(INACTIVE_OBJECTS_FINDING_PROPERTY, (Object)details);
        return finding;
    }

    private static DetachedFinding createLongMessageFinding(Matcher matcher, int startLine, String uniformPath, String findingTypeId) {
        String message = matcher.group(1) + ". See properties for details.";
        String callSequence = matcher.group(2);
        DetachedFinding finding = CodeInspectorJsonParser.createCodeInspectorFinding(startLine, uniformPath, findingTypeId, message);
        finding.setProperty(CALL_SEQUENCE_PROPERTY, (Object)callSequence);
        return finding;
    }

    private static DetachedFinding createCodeInspectorFinding(int startLine, String uniformPath, String findingTypeId, String message) {
        return CodeInspectorJsonParser.createLineFinding(startLine, uniformPath, findingTypeId, "Code Inspector", message);
    }

    @Override
    protected boolean expectEmptyFindings() {
        return true;
    }
}

