/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store.revision_interpretation;

import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.core.committree.ICommitTree;
import com.teamscale.index.repository.artifact_store.revision_interpretation.BranchNameIndependentRevisionInterpretationBase;
import com.teamscale.index.repository.artifact_store.revision_interpretation.ConnectorRevisionInterpretation;
import com.teamscale.index.repository.artifact_store.revision_interpretation.ERevisionType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.function.SupplierWithException;

final class GitConnectorRevisionInterpretation
extends BranchNameIndependentRevisionInterpretationBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SupplierWithException<ICommitTree, RepositoryException> foreignCommitTreeSupplier;
    private Map<String, CommitDescriptor> commitsByRevision = null;

    public GitConnectorRevisionInterpretation(@NonNull SupplierWithException<ICommitTree, RepositoryException> foreignCommitTreeSupplier) {
        this.foreignCommitTreeSupplier = foreignCommitTreeSupplier;
    }

    private Map<String, CommitDescriptor> getCommitsByRevisionLazy() throws RepositoryException {
        if (this.commitsByRevision != null) {
            return this.commitsByRevision;
        }
        this.commitsByRevision = new HashMap<String, CommitDescriptor>();
        ((ICommitTree)this.foreignCommitTreeSupplier.get()).getAllNodes().forEach(node -> {
            CommitTreeRevision revision = node.getRevision();
            ConnectorRevisionInterpretation.getCommitForAdjustedTimestamp(revision.getBranchName(), node).ifPresent(commit -> this.commitsByRevision.put(revision.getRevision(), (CommitDescriptor)commit));
        });
        return this.commitsByRevision;
    }

    @Override
    protected Optional<CommitDescriptor> interpretRevisionBranchNameIndependent(String revision) throws RepositoryException {
        CommitDescriptor commit = this.getCommitsByRevisionLazy().get(revision);
        if (commit == null) {
            LOGGER.debug("Revision {} not contained in foreign commit tree. Can happen if the revision is outside the analysis scope of the connector.", (Object)revision);
            return Optional.empty();
        }
        return Optional.of(commit);
    }

    @Override
    public ERevisionType getRevisionType() {
        return ERevisionType.GIT;
    }
}

