/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store.s3;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.index.repository.artifact_store.ArtifactStoreUtils;
import com.teamscale.index.repository.artifact_store.s3.S3ArtifactStore;
import com.teamscale.index.repository.artifact_store.s3.S3RepositoryInfo;
import com.teamscale.index.repository.retrievers.IFilesRetriever;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.RepositoryException;

public final class S3FilesRetriever
implements IFilesRetriever {
    private final @NonNull ConnectorConfiguration connectorConfiguration;
    private final @Nullable ProjectConfiguration projectConfiguration;
    private final @NonNull ExternalCredentials credentials;
    private final @Nullable CommitTreeIndex foreignCommitTreeIndex;

    public S3FilesRetriever(@NonNull ConnectorConfiguration connectorConfiguration, @Nullable ProjectConfiguration projectConfiguration, @NonNull ExternalCredentials credentials, @Nullable CommitTreeIndex foreignCommitTreeIndex) {
        this.connectorConfiguration = connectorConfiguration;
        this.projectConfiguration = projectConfiguration;
        this.credentials = credentials;
        this.foreignCommitTreeIndex = foreignCommitTreeIndex;
    }

    @Override
    public @NonNull Collection<@NonNull String> fetchFiles() throws RepositoryException, ProjectConfigurationException {
        S3RepositoryInfo info = ArtifactStoreUtils.createS3RepositoryInfo(this.connectorConfiguration, this.foreignCommitTreeIndex);
        return ArtifactStoreUtils.fetchFilesFromArtifactStore(this.projectConfiguration, this.connectorConfiguration, info, S3ArtifactStore.createS3ArtifactStore(this.credentials, info.getCredentialsProcess()));
    }
}

