/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store.s3;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptor;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.analysis.trigger.ChangeRetrieverAnalysisStep;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.index.repository.artifact_store.ArtifactStoreRepositoryConnectorDescriptorBase;
import com.teamscale.index.repository.artifact_store.s3.S3ArchiveIndex;
import com.teamscale.index.repository.artifact_store.s3.S3ArtifactStore;
import com.teamscale.index.repository.artifact_store.s3.S3ChangeRetriever;
import com.teamscale.index.repository.artifact_store.s3.S3CommitResolutionCacheIndex;
import com.teamscale.index.repository.artifact_store.s3.S3ContentUpdater;
import com.teamscale.index.repository.artifact_store.s3.S3RepositoryInfo;
import com.teamscale.index.s3.CredentialsProcess;
import com.teamscale.index.s3.S3Exception;
import com.teamscale.index.s3.S3UriParser;
import java.util.ArrayList;
import java.util.List;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.TestOnly;

@ConnectorDescriptor
public class S3RepositoryConnectorDescriptor
extends ArtifactStoreRepositoryConnectorDescriptorBase<S3RepositoryInfo> {
    static final String EMPTY_BUCKET_ERROR_MESSAGE = "Bucket name must not be empty";
    public static final String BUCKET_OPTION = "Bucket";
    public static final String KEY_PREFIXES_OPTION = "Key Prefixes";
    public static final String INCLUDED_KEYS_PATTERN_OPTION = "Included Key Patterns";
    public static final String EXCLUDED_KEYS_PATTERN_OPTION = "Excluded Key Patterns";
    public static final String USE_CREDENTIALS_PROCESS_OPTION = "Use Credentials Process";
    @ConfigExposed(name="Bucket", description="The name of the bucket to read the data from. Replaces bucket name given in the URI in the account, if an s3-style URI was chosen.", required=true)
    protected String bucketName = "";
    @ConfigExposed(name="Key Prefixes", description="Strings indicating the prefixes to be used when fetching keys from the bucket. Separate multiple strings with a comma.")
    protected List<String> keyPrefixes = new ArrayList<String>();
    @ConfigExposed(name="Included Key Patterns", description="Ant patterns describing the keys to be used for finding archive files from the bucket. Supported wildcards are '*' and '?'. Separate multiple patterns with comma or newline.")
    protected List<String> includedKeyPatterns = new ArrayList<String>(List.of("*.zip"));
    @ConfigExposed(name="Excluded Key Patterns", description="Ant patterns describing the keys to be excluded from the bucket. Keys will be matched case-insensitively.")
    protected List<String> excludedKeyPatterns = new ArrayList<String>();
    @ConfigExposed(name="Use Credentials Process", description="If this option is enabled, the credentials process configured in global settings will be used for authentication, ignoring the username and password from the account.")
    protected boolean useCredentialsProcess = false;

    public S3RepositoryConnectorDescriptor() {
        super(ERepositoryConnector.S3);
    }

    protected S3RepositoryConnectorDescriptor(ERepositoryConnector connectorType) {
        super(connectorType);
    }

    @Override
    protected void setCommonParameters(TriggerBuilder triggerBuilder, ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        super.setCommonParameters(triggerBuilder, triggerCreator);
        triggerBuilder.setTriggerParameter("bucket-name", this.bucketName);
        triggerBuilder.setTriggerParameter("use-credentials-process", this.useCredentialsProcess);
        triggerBuilder.setTriggerParameter("key-include-pattern", ITriggerParameter.of(this.includedKeyPatterns));
        triggerBuilder.setTriggerParameter("key-exclude-pattern", ITriggerParameter.of(this.excludedKeyPatterns));
        triggerBuilder.setTriggerParameter("key-prefix", ITriggerParameter.of(this.keyPrefixes));
    }

    @Override
    protected void createArchiveIndex(ConnectorDescriptorBase.IIndexCreator indexCreator) {
        indexCreator.createProjectIndex(S3ArchiveIndex.class, S3ArchiveIndex.createIndexName(this.repositoryIdentifier));
        indexCreator.createProjectIndex(S3CommitResolutionCacheIndex.class, this.repositoryIdentifier + "-s3-commit-resolution-cache");
    }

    @Override
    protected void renameArchiveIndex(TriggerBuilder triggerBuilder) {
        triggerBuilder.renameIndex("s3-archive-content", S3ArchiveIndex.createIndexName(this.repositoryIdentifier));
        triggerBuilder.renameIndex("s3-commit-resolution-cache", this.repositoryIdentifier + "-s3-commit-resolution-cache");
    }

    @Override
    public void validate() throws ConnectorValidationException {
        if (StringUtils.isEmpty((String)this.bucketName)) {
            throw new ConnectorValidationException(EMPTY_BUCKET_ERROR_MESSAGE);
        }
        super.validate();
    }

    @Override
    protected void checkConnection() throws ConnectorValidationException {
        S3UriParser.ParsedUri parsedUri = S3UriParser.parseUri(this.getRepositoryUri());
        String bucket = parsedUri.getBucket();
        if (!StringUtils.isEmpty((String)bucket) && !bucket.equals(this.getRepositoryOrBucketName())) {
            throw new ConnectorValidationException("Mismatching bucket in repository URL. Expected bucket '%s' but found '%s'".formatted(bucket, parsedUri.getBucket()));
        }
        try {
            S3ArtifactStore artifactStore = this.getClient();
            artifactStore.validateCredentials();
            artifactStore.validateBucket(bucket, this.keyPrefixes);
        }
        catch (S3Exception exception) {
            throw new ConnectorValidationException((Throwable)exception);
        }
    }

    @Override
    protected String getRepositoryOrBucketName() {
        return this.bucketName;
    }

    @Override
    protected List<String> getExcludePatterns() {
        return this.excludedKeyPatterns;
    }

    @Override
    protected Class<? extends ChangeRetrieverAnalysisStep> getChangeRetrieverBlockName() {
        return S3ChangeRetriever.class;
    }

    @Override
    protected Class<? extends ChangeProcessorAnalysisStep> getContentUpdaterBlockName() {
        return S3ContentUpdater.class;
    }

    @TestOnly
    void setBucketNameForTesting(String bucketName) {
        this.bucketName = bucketName;
    }

    @TestOnly
    void useCredentialsProcessForTesting() {
        this.useCredentialsProcess = true;
    }

    @Override
    protected S3RepositoryInfo getRepositoryInfo() {
        return new S3RepositoryInfo();
    }

    protected S3ArtifactStore getClient() throws ConnectorValidationException {
        try {
            ExternalCredentials credentials = this.resolveExternalCredentials();
            CredentialsProcess credentialsProcess = null;
            if (this.useCredentialsProcess) {
                credentialsProcess = CredentialsProcess.readFromServerOptions((ServerOptionIndex)this.getContext().getGlobalStorageSystem().openGlobalIndex(ServerOptionIndex.class));
            }
            return S3ArtifactStore.createS3ArtifactStore(credentials, credentialsProcess);
        }
        catch (ProjectConfigurationException | StorageException e) {
            throw new ConnectorValidationException(e);
        }
    }

    @Override
    public void storeConfigurationDataInternal(ProjectStorageSystem projectStorageSystem) throws StorageException, ConnectorValidationException {
        super.storeConfigurationDataInternal(projectStorageSystem);
        this.storeUrlToTriggerMapping(projectStorageSystem, S3UriParser.parseUri(this.getRepositoryUri()).toLookupKey());
    }
}

