/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git;

import com.teamscale.index.repository.git.GitPrivateKeyOption;
import com.teamscale.index.repository.git.GitUtils;
import java.net.URI;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.string.StringUtils;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public final class TeamscaleGitCredentialsProvider
extends UsernamePasswordCredentialsProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private final @Nullable GitPrivateKeyOption privateKeyOption;

    public TeamscaleGitCredentialsProvider(String username, String password, @Nullable GitPrivateKeyOption privateKeyOption) {
        super(username, password);
        this.privateKeyOption = privateKeyOption;
    }

    public boolean supports(CredentialItem ... items) {
        for (CredentialItem item : items) {
            if (item instanceof CredentialItem.YesNoType) continue;
            if (super.supports(new CredentialItem[]{item})) continue;
            return false;
        }
        return true;
    }

    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
        LOGGER.traceEntry("Getting credentials for URI '{}'. Credential items: [{}]", new Object[]{uri, Arrays.stream(items).map(Object::toString).map(StringUtils::surroundWithSingleQuotes).collect(Collectors.joining(", "))});
        for (CredentialItem item : items) {
            if (item instanceof CredentialItem.YesNoType) {
                CredentialItem.YesNoType yesNoQuestion = (CredentialItem.YesNoType)item;
                yesNoQuestion.setValue(true);
                continue;
            }
            LOGGER.traceExit((Object)super.get(uri, new CredentialItem[]{item}));
        }
        return (Boolean)LOGGER.traceExit((Object)true);
    }

    public String getUsername(URI location) {
        CredentialItem.Username userCredentials = new CredentialItem.Username();
        this.get(GitUtils.toURIish(location), new CredentialItem[]{userCredentials});
        return Optional.ofNullable(userCredentials.getValue()).map(String::valueOf).orElse(null);
    }

    public String getPassword(URI location) {
        CredentialItem.Password passwordCredentials = new CredentialItem.Password();
        this.get(GitUtils.toURIish(location), new CredentialItem[]{passwordCredentials});
        return Optional.ofNullable(passwordCredentials.getValue()).map(String::valueOf).orElse(null);
    }

    public @Nullable String getSshPrivateKey() {
        if (this.privateKeyOption == null) {
            return null;
        }
        return this.privateKeyOption.privateKey;
    }

    public @Nullable String getSshPrivateKeyPassword(URI location) {
        if (this.privateKeyOption == null || StringUtils.isEmpty((String)this.privateKeyOption.privateKeyPassphrase)) {
            return this.getPassword(location);
        }
        return this.privateKeyOption.privateKeyPassphrase;
    }
}

