/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.bitbucket.cloud;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.test.IndexValueClass;

@Index(name="bitbucket-installations", options={EStorageOption.BACKUP}, valueClasses={BitbucketInstallation.class})
public class BitbucketCloudInstallationIndex
extends IndexBase
implements IGlobalIndex {
    public static final String NAME = "bitbucket-installations";
    private static final String USERNAME_KEY_PREFIX = "app-installation-username:";
    private static final String CLIENT_KEY_PREFIX = "app-installation-client-key:";

    public BitbucketCloudInstallationIndex(IStore store) {
        super(store);
    }

    public List<BitbucketInstallation> getAllInstallations() throws StorageException {
        ArrayList<BitbucketInstallation> result = new ArrayList<BitbucketInstallation>();
        PairList pairs = this.store.getEntriesStartingWith(USERNAME_KEY_PREFIX);
        for (Pair pair : pairs) {
            result.add((BitbucketInstallation)StorageUtils.deserialize((byte[])((byte[])pair.getSecond())));
        }
        return result;
    }

    public void addInstallation(BitbucketInstallation installation) throws StorageException {
        this.addInstallations((PairList<String, BitbucketInstallation>)PairList.from((Object)BitbucketCloudInstallationIndex.generateUsernameIndexKey(installation.getInstallationUsername()), (Object)installation));
        this.addInstallations((PairList<String, BitbucketInstallation>)PairList.from((Object)BitbucketCloudInstallationIndex.generateClientKeyIndexKey(installation.getClientKey()), (Object)installation));
    }

    private void addInstallations(PairList<String, BitbucketInstallation> keyToInstallation) throws StorageException {
        this.store.putWithStrings(keyToInstallation.mapSecond(StorageUtils::serialize));
    }

    public void removeInstallation(BitbucketInstallation installation) throws StorageException {
        this.store.removeWithString(BitbucketCloudInstallationIndex.generateUsernameIndexKey(installation.getInstallationUsername()));
        this.store.removeWithString(BitbucketCloudInstallationIndex.generateClientKeyIndexKey(installation.getClientKey()));
    }

    public Optional<BitbucketInstallation> getBitbucketInstallationForTeamOrUsername(String installationTeamOrUsername) throws StorageException {
        return this.getBitbucketInstallationForKey(BitbucketCloudInstallationIndex.generateUsernameIndexKey(installationTeamOrUsername));
    }

    public Optional<BitbucketInstallation> getBitbucketInstallationForClientKey(String clientKey) throws StorageException {
        return this.getBitbucketInstallationForKey(BitbucketCloudInstallationIndex.generateClientKeyIndexKey(clientKey));
    }

    private Optional<BitbucketInstallation> getBitbucketInstallationForKey(String key) throws StorageException {
        byte[] value = this.store.getWithString(key);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of((BitbucketInstallation)StorageUtils.deserialize((byte[])value));
    }

    private static String generateUsernameIndexKey(String username) {
        return USERNAME_KEY_PREFIX + username;
    }

    private static String generateClientKeyIndexKey(String installationClientKey) {
        return CLIENT_KEY_PREFIX + installationClientKey;
    }

    @IndexValueClass(containedInBackup=true)
    public static class BitbucketInstallation
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="clientKey")
        private String clientKey;
        @JsonProperty(value="sharedSecret")
        private @Nullable String sharedSecret;
        @JsonProperty(value="principal")
        private Principal principal;

        public String getClientKey() {
            return this.clientKey;
        }

        public @Nullable String getSharedSecret() {
            return this.sharedSecret;
        }

        public String getInstallationUsername() {
            return this.principal.getUsername();
        }

        public BitbucketInstallation() {
        }

        BitbucketInstallation(String username, String clientKey, String sharedSecret) {
            this.principal = new Principal();
            this.principal.uuid = username;
            this.clientKey = clientKey;
            this.sharedSecret = sharedSecret;
        }
    }

    @IndexValueClass(containedInBackup=true)
    private static class Principal
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="uuid")
        private String uuid;

        private Principal() {
        }

        public String getUsername() {
            return this.uuid;
        }
    }
}

