/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.bitbucket.cloud.client;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudInstallationIndex;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudUtils;
import com.teamscale.index.repository.git.bitbucket.cloud.client.IBitbucketCloudApi;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.BitbucketCloudRepository;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.BitbucketCloudWorkspace;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.pagination.BitbucketCloudPaginationReader;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.pullrequest.BitbucketCloudPullRequest;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.pullrequest.BitbucketCloudPullRequestComment;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.report.BitbucketCloudCommitReport;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.report.BitbucketCloudCommitReportAnnotation;
import com.teamscale.index.repository.git.bitbucket.server.model.commit_status.CommitStatus;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

public class BitbucketCloudClient {
    public static final String GIT_USERNAME = "x-token-auth";
    public static final String API_URL = "https://api.bitbucket.org";
    private final String apiUrl;
    private final BitbucketCloudInstallationIndex.BitbucketInstallation installation;
    private final AccessTokenIndex accessTokenIndex;
    private final IBitbucketCloudApi bitbucketCloud;

    public BitbucketCloudClient(BitbucketCloudInstallationIndex.BitbucketInstallation installation, AccessTokenIndex accessTokenIndex, Logger interactionLogger) throws ServiceCallException, StorageException {
        this(API_URL, installation, accessTokenIndex, interactionLogger);
    }

    public BitbucketCloudClient(String apiUrl, BitbucketCloudInstallationIndex.BitbucketInstallation installation, AccessTokenIndex accessTokenIndex, Logger interactionLogger) throws ServiceCallException, StorageException {
        this.apiUrl = StringUtils.ensureEndsWith((String)apiUrl, (String)"/");
        this.installation = installation;
        this.accessTokenIndex = accessTokenIndex;
        this.bitbucketCloud = (IBitbucketCloudApi)Retrofit.builder((String)apiUrl).withBearerAuthentication(this.getInstallationToken()).withInteractionLogger(interactionLogger).create(IBitbucketCloudApi.class);
    }

    public String getInstallationToken() throws ServiceCallException, StorageException {
        return BitbucketCloudUtils.getInstallationToken(this.accessTokenIndex, this.installation);
    }

    public BitbucketCloudRepository getInstallationRepository(PlatformRepositoryIdentifier repositoryIdentifier) throws ServiceCallException {
        return this.bitbucketCloud.getInstallationRepository(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo());
    }

    public List<BitbucketCloudPullRequest> getAllOpenPullRequests(PlatformRepositoryIdentifier repositoryIdentifier) throws ServiceCallException, JsonSerializationException {
        String firstPageUrl = this.apiUrl + StringUtils.replaceFromMap((String)"2.0/repositories/{workspace}/{reposlug}/pullrequests/", Map.of("{workspace}", repositoryIdentifier.getOwner(), "{reposlug}", repositoryIdentifier.getRepo()));
        return BitbucketCloudPaginationReader.getAllObjects(firstPageUrl, this.bitbucketCloud::getPullRequestPaginationPage).stream().filter(pr -> pr.getState() == BitbucketCloudPullRequest.BitbucketCloudPullRequestStates.OPEN).toList();
    }

    public BitbucketCloudPullRequest getPullRequest(PlatformRepositoryIdentifier repositoryIdentifier, long id) throws ServiceCallException {
        return this.bitbucketCloud.getPullRequest(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), id);
    }

    public BitbucketCloudWorkspace getWorkspace(String workspace) throws ServiceCallException {
        return this.bitbucketCloud.getWorkspace(BitbucketCloudUtils.getUrlSafeFullRepositoryName(workspace));
    }

    public static String getPullRequestUrl(String repositoryFullName, long id) {
        return "https://bitbucket.org/" + BitbucketCloudUtils.getUrlSafeFullRepositoryName(repositoryFullName) + "/pull-requests/" + id;
    }

    public String getFullCommitHash(PlatformRepositoryIdentifier repositoryIdentifier, String shortCommitHash) throws ServiceCallException {
        return this.bitbucketCloud.getCommit(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), shortCommitHash).getHash();
    }

    public void postCommitStatus(PlatformRepositoryIdentifier repositoryIdentifier, String commit, CommitStatus status) throws ServiceCallException {
        this.bitbucketCloud.postCommitStatus(status, repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), commit);
    }

    public List<BitbucketCloudRepository> getRepositoriesInWorkspace(String workspaceUuid) throws ServiceCallException, JsonSerializationException {
        String firstPageUrl = this.apiUrl + StringUtils.replaceFromMap((String)"2.0/repositories/{workspace}", Map.of("{workspace}", BitbucketCloudUtils.getUrlSafeFullRepositoryName(workspaceUuid)));
        return BitbucketCloudPaginationReader.getAllObjects(firstPageUrl, this.bitbucketCloud::getRepositoryPaginationPage);
    }

    public void postReportAnnotations(PlatformRepositoryIdentifier repositoryIdentifier, String commit, String reportId, List<BitbucketCloudCommitReportAnnotation> annotations) throws ServiceCallException {
        this.bitbucketCloud.postReportAnnotations(reportId, repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), commit, annotations);
    }

    public BitbucketCloudCommitReport putCommitReport(PlatformRepositoryIdentifier repositoryIdentifier, String commit, String reportId, BitbucketCloudCommitReport report) throws ServiceCallException {
        return this.bitbucketCloud.postCommitReport(reportId, repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), commit, report);
    }

    public BitbucketCloudPullRequest putUpdatePullRequest(PlatformRepositoryIdentifier repositoryIdentifier, BitbucketCloudPullRequest pullRequest) throws ServiceCallException {
        return this.bitbucketCloud.putUpdatePullRequest(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), pullRequest.getId(), pullRequest);
    }

    public void deleteReport(PlatformRepositoryIdentifier repositoryIdentifier, String commit, String reportId) throws ServiceCallException {
        this.bitbucketCloud.deleteReport(reportId, repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), commit);
    }

    public List<BitbucketCloudPullRequestComment> getAllPullRequestComments(PlatformRepositoryIdentifier repositoryIdentifier, String pullRequestId) throws ServiceCallException, JsonSerializationException {
        String firstPageUrl = this.apiUrl + StringUtils.replaceFromMap((String)"2.0/repositories/{workspace}/{reposlug}/pullrequests/{pullRequestId}/comments", Map.of("{workspace}", repositoryIdentifier.getOwner(), "{reposlug}", repositoryIdentifier.getRepo(), "{pullRequestId}", pullRequestId)) + "?q=deleted=false";
        return BitbucketCloudPaginationReader.getAllObjects(firstPageUrl, this.bitbucketCloud::getPullRequestCommentPaginationPage).stream().toList();
    }

    public void postPullRequestComment(PlatformRepositoryIdentifier repositoryIdentifier, long pullRequestId, BitbucketCloudPullRequestComment comment) throws ServiceCallException {
        this.bitbucketCloud.postPullRequestComment(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), pullRequestId, comment);
    }

    public void deletePullRequestComment(PlatformRepositoryIdentifier repositoryIdentifier, long pullRequestId, long commentId) throws ServiceCallException {
        this.bitbucketCloud.deletePullRequestComment(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), pullRequestId, commentId);
    }
}

