/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.debug_dump.replay;

import com.teamscale.index.repository.git.debug_dump.dump.RefDump;
import java.util.Optional;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;

public class RefMock
implements Ref {
    private final String name;
    private final ObjectId objectId;
    private final ObjectId peeledObjectId;
    private final RefMock target;

    public RefMock(RefDump refDump) {
        this.name = refDump.name;
        this.objectId = ObjectId.fromString((String)refDump.objectId);
        this.peeledObjectId = Optional.ofNullable(refDump.peeledObjectId).map(ObjectId::fromString).orElse(null);
        this.target = Optional.ofNullable(refDump.target).map(RefMock::new).orElse(null);
    }

    public String getName() {
        return this.name;
    }

    public boolean isSymbolic() {
        return false;
    }

    public Ref getLeaf() {
        return this;
    }

    public Ref getTarget() {
        return Optional.ofNullable(this.target).orElse(this);
    }

    public ObjectId getObjectId() {
        return this.objectId;
    }

    public ObjectId getPeeledObjectId() {
        return this.peeledObjectId;
    }

    public boolean isPeeled() {
        return this.target == null;
    }

    public Ref.Storage getStorage() {
        return null;
    }
}

