/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gitlab;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.index.merge_request.comments.comments.IReviewComment;
import com.teamscale.index.repository.git.common.CcpCommentUtils;
import com.teamscale.index.repository.git.gitlab.GitLabChangeReviewComments;
import com.teamscale.index.repository.git.gitlab.GitLabCrossRepositoryMergeRequestHandler;
import com.teamscale.index.repository.git.gitlab.data.GitLabChange;
import com.teamscale.index.repository.git.gitlab.data.GitLabMergeRequest;
import com.teamscale.index.repository.git.gitlab.data.GitLabNote;
import com.teamscale.index.repository.git.gitlab.data.GitLabPosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.error.FormatException;
import org.conqat.lib.commons.function.SupplierWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.version.Version;

public class GitLabNoteBuilder {
    private static final Logger LOGGER = LogManager.getLogger(GitLabNoteBuilder.class);
    private static final Version MIN_VERSION_FOR_FILE_COMMENTS = new Version(16, 4);
    private final GitLabMergeRequest mergeRequest;
    private final SupplierWithException<String, ServiceCallException> gitlabVersionSupplier;

    public GitLabNoteBuilder(GitLabMergeRequest mergeRequest, SupplierWithException<String, ServiceCallException> gitlabVersionSupplier) {
        this.mergeRequest = mergeRequest;
        this.gitlabVersionSupplier = gitlabVersionSupplier;
    }

    public List<GitLabNote> buildNotes(List<IReviewComment> reviewComments) {
        Map<String, List<IReviewComment>> pathToComments = reviewComments.stream().collect(Collectors.groupingBy(comment -> comment.getLocation().getUniformPath()));
        Map<Boolean, List<GitLabChangeReviewComments>> changesWithCommentsByAnnotationType = this.mergeRequest.changes().stream().filter(change -> !change.isDiffEmpty() && pathToComments.containsKey(change.getNewPath())).map(change -> new GitLabChangeReviewComments((GitLabChange)change, (List)pathToComments.get(change.getNewPath()))).collect(Collectors.groupingBy(GitLabChangeReviewComments::isBinaryFile));
        ArrayList<GitLabNote> notesToBeAdded = new ArrayList<GitLabNote>();
        if (changesWithCommentsByAnnotationType.containsKey(false)) {
            for (GitLabChangeReviewComments changeReviewCommentsForLines : changesWithCommentsByAnnotationType.get(false)) {
                notesToBeAdded.addAll(this.buildTextNotes(changeReviewCommentsForLines));
            }
        }
        if (changesWithCommentsByAnnotationType.containsKey(true)) {
            notesToBeAdded.addAll(this.buildFileNotes(changesWithCommentsByAnnotationType.get(true)));
        }
        return notesToBeAdded;
    }

    private List<GitLabNote> buildFileNotes(List<GitLabChangeReviewComments> changesWithReviewComments) {
        LOGGER.traceEntry();
        ArrayList<GitLabNote> notes = new ArrayList<GitLabNote>();
        if (!this.areFileCommentsSupported()) {
            LOGGER.atInfo().log("Skipping comments for binary files because this is not supported by the GitLab instance (requires at least version {}).", (Object)MIN_VERSION_FOR_FILE_COMMENTS);
            return (List)LOGGER.traceExit(notes);
        }
        for (GitLabChangeReviewComments changeReviewComments : changesWithReviewComments) {
            notes.add(new GitLabNote(CcpCommentUtils.createInlineCommentMarkdownContent(changeReviewComments.comments(), 1), this.buildFilePosition(changeReviewComments.change())));
        }
        return (List)LOGGER.traceExit(notes);
    }

    private boolean areFileCommentsSupported() {
        String gitlabVersion;
        try {
            gitlabVersion = (String)this.gitlabVersionSupplier.get();
        }
        catch (ServiceCallException e) {
            GitLabNoteBuilder.logVersionCheckError("fetching the GitLab version failed", (Exception)((Object)e));
            return false;
        }
        try {
            Version version = Version.parseVersion((String)StringUtils.stripSuffix((String)gitlabVersion, (String)"-pre"));
            return version.isGreaterOrEqual(MIN_VERSION_FOR_FILE_COMMENTS);
        }
        catch (FormatException e) {
            GitLabNoteBuilder.logVersionCheckError("parsing the GitLab version '" + gitlabVersion + "' failed", (Exception)((Object)e));
            return false;
        }
    }

    private static void logVersionCheckError(String message, Exception cause) {
        LOGGER.atError().withThrowable((Throwable)cause).log("Cannot check if file comments are supported because {}. Will skip any comments for binary files.", (Object)message);
    }

    private List<GitLabNote> buildTextNotes(GitLabChangeReviewComments changeReviewComments) {
        LOGGER.traceEntry();
        Map<Integer, List<IReviewComment>> lineToCommentsMap = changeReviewComments.comments().stream().collect(Collectors.groupingBy(IReviewComment::getStartLine));
        ArrayList notes = new ArrayList();
        lineToCommentsMap.forEach((line, commentsByLine) -> notes.add(new GitLabNote(CcpCommentUtils.createInlineCommentMarkdownContent(commentsByLine, line), this.buildTextPosition(changeReviewComments.change(), (int)line))));
        return (List)LOGGER.traceExit(notes);
    }

    private GitLabPosition buildTextPosition(GitLabChange change, int newLine) {
        return new GitLabPosition(this.mergeRequest.diffRefs(), this.getOldLine(change, newLine), newLine, this.getOldPath(change), change.getNewPath());
    }

    private GitLabPosition buildFilePosition(GitLabChange change) {
        return new GitLabPosition(this.mergeRequest.diffRefs(), this.getOldPath(change), change.getNewPath());
    }

    private @Nullable String getOldPath(GitLabChange change) {
        if (GitLabCrossRepositoryMergeRequestHandler.isCrossRepoMergeRequest(this.mergeRequest)) {
            return null;
        }
        return change.getOldPath();
    }

    private @Nullable Integer getOldLine(GitLabChange change, int newLine) {
        if (GitLabCrossRepositoryMergeRequestHandler.isCrossRepoMergeRequest(this.mergeRequest)) {
            return null;
        }
        return change.getOldLine(newLine);
    }
}

