/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.scm_manager.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.repository.git.bitbucket.server.client.IParsedDiffHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;

public class ScmManagerDiff {

    private static class DiffHunkChange {
        @JsonProperty(value="lineNumber")
        private @Nullable Integer lineNumber;
        @JsonProperty(value="oldLineNumber")
        private @Nullable Integer oldLineNumber;
        @JsonProperty(value="newLineNumber")
        private @Nullable Integer newLineNumber;

        private DiffHunkChange() {
        }

        private @Nullable Integer getOldLineNumber() {
            return this.oldLineNumber;
        }

        private @Nullable Integer getNewLineNumber() {
            if (this.newLineNumber != null) {
                return this.newLineNumber;
            }
            return this.lineNumber;
        }
    }

    private static class DiffHunk {
        @JsonProperty(value="content")
        private String content;
        @JsonProperty(value="newStart")
        private int newStart;
        @JsonProperty(value="newLines")
        private int newLines;
        @JsonProperty(value="changes")
        private DiffHunkChange[] diffHunkChanges;

        private DiffHunk() {
        }

        public List<DiffHunkChange> getDiffHunkChanges() {
            return Arrays.asList(this.diffHunkChanges);
        }
    }

    private static class FileDiff {
        @JsonProperty(value="oldPath")
        private String oldFilePath;
        @JsonProperty(value="newPath")
        private String newFilePath;
        @JsonProperty(value="type")
        private String changeType;
        @JsonProperty(value="hunks")
        private DiffHunk @Nullable [] diffHunks;

        private FileDiff() {
        }

        private PairList<Integer, Integer> getRightSideRangesFromHunks() {
            PairList ranges = new PairList();
            this.getDiffHunks().forEach(hunk -> ranges.add((Object)hunk.newStart, (Object)(hunk.newStart + hunk.newLines - 1)));
            return ranges;
        }

        private Map<Integer, String> getLineToHunkContentMap() {
            HashMap<Integer, String> lineToHunkMap = new HashMap<Integer, String>();
            this.getDiffHunks().forEach(hunk -> {
                String hunkContent = hunk.content;
                for (int i = hunk.newStart; i < hunk.newStart + hunk.newLines; ++i) {
                    lineToHunkMap.put(i, hunkContent);
                }
            });
            return lineToHunkMap;
        }

        private List<DiffHunkChange> getDiffChanges() {
            ArrayList<DiffHunkChange> diffChanges = new ArrayList<DiffHunkChange>();
            this.getDiffHunks().forEach(hunk -> diffChanges.addAll(hunk.getDiffHunkChanges()));
            return diffChanges;
        }

        private List<DiffHunk> getDiffHunks() {
            if (this.diffHunks == null) {
                return CollectionUtils.emptyList();
            }
            return Arrays.asList(this.diffHunks);
        }
    }

    public static class Diff
    implements IParsedDiffHandler<FileDiff> {
        @JsonProperty(value="files")
        private FileDiff[] fileDiffs;

        @Override
        public Map<String, Map<Integer, Integer>> getPathToDiffLinesMap() {
            return this.getRightSideDiffs().stream().collect(Collectors.toMap(diff -> diff.newFilePath, diff -> diff.getDiffChanges().stream().filter(change -> change.getOldLineNumber() != null).collect(Collectors.toMap(DiffHunkChange::getNewLineNumber, DiffHunkChange::getOldLineNumber))));
        }

        @Override
        public Map<String, PairList<Integer, Integer>> getPathToDiffRightSideRangesMap() {
            return this.getRightSideDiffs().stream().collect(Collectors.toMap(diff -> diff.newFilePath, FileDiff::getRightSideRangesFromHunks));
        }

        public Map<String, Map<Integer, String>> getPathToLineHunkMap() {
            return this.getRightSideDiffs().stream().collect(Collectors.toMap(diff -> diff.newFilePath, FileDiff::getLineToHunkContentMap));
        }

        @Override
        public List<FileDiff> getRightSideDiffs() {
            return CollectionUtils.filter(Arrays.asList(this.fileDiffs), diff -> !diff.changeType.equals("delete"));
        }
    }
}

