/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.history;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.teamscale.core.index.CommitAssociatedObjectBase;
import com.teamscale.index.repository.history.EChangeEntryOrigin;
import com.teamscale.index.repository.history.EElementHistoryChangeType;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class ElementHistoryEntry
extends CommitAssociatedObjectBase {
    private static final long serialVersionUID = 1L;
    protected static final String CHANGE_TYPE_PROPERTY = "changeType";
    protected static final String ORIGIN_PATH_PROPERTY = "originPath";
    protected static final String ORIGIN_COMMIT_PROPERTY = "originCommit";
    protected static final String CHANGE_ENTRY_ORIGIN_PROPERTY = "changeEntryOrigin";
    @JsonProperty(value="changeType")
    private final EElementHistoryChangeType changeType;
    @JsonProperty(value="originPath")
    private final @Nullable String originPath;
    @JsonProperty(value="originCommit")
    private final @Nullable CommitDescriptor originCommit;
    @JsonProperty(value="changeEntryOrigin")
    private final @Nullable EChangeEntryOrigin changeEntryOrigin;

    public ElementHistoryEntry(EElementHistoryChangeType changeType, CommitDescriptor commit, @Nullable EChangeEntryOrigin changeEntryOrigin) {
        super(commit);
        Preconditions.checkState((changeType == EElementHistoryChangeType.ADD || changeType == EElementHistoryChangeType.EDIT || changeType == EElementHistoryChangeType.DELETE || changeType == EElementHistoryChangeType.EXTERNAL_ANALYSIS_UPLOAD ? 1 : 0) != 0, (Object)"You cannot instantiate an ElementHistoryEntry for a changed origin when no origin path and origin version are given.");
        this.changeType = changeType;
        this.originPath = null;
        this.originCommit = null;
        this.changeEntryOrigin = changeEntryOrigin;
    }

    public ElementHistoryEntry(@NonNull String originPath, @NonNull CommitDescriptor originCommit, CommitDescriptor commit, EElementHistoryChangeType changeType, @Nullable EChangeEntryOrigin changeEntryOrigin) {
        super(commit);
        CCSMAssert.isNotNull((Object)originPath, (String)"Should not instantiate an element history for a change in origin with an origin path of null");
        Preconditions.checkState((boolean)EElementHistoryChangeType.ORIGIN_CHANGE.contains((Object)changeType), (String)"You cannot instantiate an ElementHistoryEntry for a changed origin without specifying an origin change type. Currently using: {}", (Object)((Object)changeType));
        this.changeType = changeType;
        this.originPath = originPath;
        this.originCommit = originCommit;
        this.changeEntryOrigin = changeEntryOrigin;
    }

    protected ElementHistoryEntry(ElementHistoryEntry other) {
        super(other.getCommit());
        this.changeType = other.changeType;
        this.originPath = other.originPath;
        this.originCommit = other.originCommit;
        this.changeEntryOrigin = other.changeEntryOrigin;
    }

    @JsonCreator
    protected ElementHistoryEntry(@JsonProperty(value="changeType") EElementHistoryChangeType changeType, @JsonProperty(value="originPath") @Nullable String originPath, @JsonProperty(value="originCommit") @Nullable CommitDescriptor originCommit, @JsonProperty(value="commit") CommitDescriptor commit, @JsonProperty(value="changeEntryOrigin") @Nullable EChangeEntryOrigin changeEntryOrigin) {
        super(commit);
        this.changeType = changeType;
        this.originPath = originPath;
        this.originCommit = originCommit;
        this.changeEntryOrigin = changeEntryOrigin;
    }

    public EElementHistoryChangeType getChangeType() {
        return this.changeType;
    }

    public @Nullable String getOriginPath() {
        return this.originPath;
    }

    public @Nullable CommitDescriptor getOriginCommit() {
        return this.originCommit;
    }

    public @Nullable EChangeEntryOrigin getChangeEntryOrigin() {
        return this.changeEntryOrigin;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append((Object)this.changeType);
        result.append(" @ ");
        result.append(this.getCommit());
        if (this.originPath != null) {
            result.append(" origin: ");
            result.append(this.originPath);
            result.append(" @ ");
            result.append(this.originCommit);
        }
        return result.toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.changeType, this.originPath, this.originCommit, this.changeEntryOrigin});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ElementHistoryEntry that = (ElementHistoryEntry)((Object)o);
        return this.changeType == that.changeType && Objects.equals(this.originPath, that.originPath) && Objects.equals(this.originCommit, that.originCommit) && Objects.equals((Object)this.changeEntryOrigin, (Object)that.changeEntryOrigin);
    }
}

