/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.status;

import com.teamscale.index.repository.status.ProjectConnectorStatus;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;

@Index(name="connector-status", options={EStorageOption.COMPRESSED, EStorageOption.NO_ROLLBACK, EStorageOption.COMMIT_ISOLATED})
public class ProjectConnectorStatusIndex
implements IProjectIndex {
    private static final Map<ProjectConnectorStatus.EConnectorStatus, Set<ProjectConnectorStatus.EConnectorStatus>> PROHIBITED_OVERRIDES = Map.of(ProjectConnectorStatus.EConnectorStatus.WARNING, Set.of(ProjectConnectorStatus.EConnectorStatus.HEALTHY, ProjectConnectorStatus.EConnectorStatus.UNKNOWN), ProjectConnectorStatus.EConnectorStatus.ERROR, Set.of(ProjectConnectorStatus.EConnectorStatus.HEALTHY, ProjectConnectorStatus.EConnectorStatus.UNKNOWN, ProjectConnectorStatus.EConnectorStatus.WARNING));
    public static final String BASE_NAME = "connector-status";
    private final ValueIndex<ProjectConnectorStatus> delegate;
    private final IStore store;

    public ProjectConnectorStatusIndex(IStore store) {
        this.store = store;
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public void setStatus(ProjectConnectorStatus status) throws StorageException {
        this.delegate.setValue(status.getConnectorIdentifier(), (Object)status);
    }

    public ProjectConnectorStatus getStatus(String connectorId) throws StorageException {
        return (ProjectConnectorStatus)this.delegate.getValue(connectorId);
    }

    public List<ProjectConnectorStatus> getAllStatuses() throws StorageException {
        return this.delegate.getAllEntries().extractSecondList();
    }

    public void storeConnectorStatus(String connectionIdentifier, ProjectConnectorStatus.EConnectorStatus newStatus, String message) throws StorageException {
        this.store.performWithLock(() -> {
            ProjectConnectorStatus.EConnectorStatus oldStatus;
            Set<ProjectConnectorStatus.EConnectorStatus> nonOverridableStatuses;
            ProjectConnectorStatus oldProjectConnectorStatus = this.getStatus(connectionIdentifier);
            if (newStatus != ProjectConnectorStatus.EConnectorStatus.INIT && oldProjectConnectorStatus != null && (nonOverridableStatuses = PROHIBITED_OVERRIDES.get((Object)(oldStatus = oldProjectConnectorStatus.getStatus()))) != null && nonOverridableStatuses.contains((Object)newStatus)) {
                return;
            }
            long now = Instant.now().toEpochMilli();
            Long lastSuccess = now;
            if (newStatus != ProjectConnectorStatus.EConnectorStatus.HEALTHY && oldProjectConnectorStatus != null) {
                lastSuccess = oldProjectConnectorStatus.getLastSuccess();
            }
            ProjectConnectorStatus connectorStatus = new ProjectConnectorStatus(connectionIdentifier, newStatus, lastSuccess, now, message);
            this.setStatus(connectorStatus);
        });
    }
}

