/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.index;

import java.util.List;
import java.util.Map;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

@Index(name="spec-item-revision-cache", options={EStorageOption.COMPRESSED, EStorageOption.NO_ROLLBACK})
public class SpecItemLatestRevisionCacheIndex
implements IProjectIndex {
    public static final String INDEX_NAME = "spec-item-revision-cache";
    private final ValueIndex<String> delegate;

    public SpecItemLatestRevisionCacheIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public void storeLatestRevisions(Map<String, String> latestRevisionById) throws StorageException {
        PairList keysAndValues = new PairList(latestRevisionById);
        this.delegate.setValues(keysAndValues);
    }

    void clear() throws StorageException {
        this.delegate.removeAllEntries();
    }

    public List<String> getLastRevisions(List<String> specItemIds) throws StorageException {
        return this.delegate.getValues(specItemIds);
    }
}

