/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import com.teamscale.index.resource.ContainerInfo;
import com.teamscale.index.resource.utils.EResourceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.IProjectIndexWithDynamicName;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;

@Index(name="(dynamic)", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED})
public class ContainerIndex
implements IProjectIndexWithDynamicName {
    public static final String INDEX_NAME = "dir";
    private String indexInstanceName;
    private final ValueIndex<ContainerInfo> delegate;

    public ContainerIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public boolean isFile(String uniformPath) throws StorageException {
        return this.getResourceType(uniformPath) == EResourceType.FILE;
    }

    public EResourceType getResourceType(String uniformPath) throws StorageException {
        return (EResourceType)((Object)this.getResourceTypes(List.of(uniformPath)).getSecond(0));
    }

    public PairList<String, EResourceType> getResourceTypes(List<String> uniformPaths) throws StorageException {
        PairList result = new PairList();
        ArrayList<String> pathsToQueryFromIndex = new ArrayList<String>();
        HashMap<String, Integer> originalPositionsOfPaths = new HashMap<String, Integer>();
        for (int i = 0; i < uniformPaths.size(); ++i) {
            String uniformPath = uniformPaths.get(i);
            originalPositionsOfPaths.put(uniformPath, i);
            String cleanPath = UniformPathUtils.cleanPath((String)uniformPath);
            if (cleanPath.equals(UniformPathUtils.SEPARATOR) || cleanPath.isEmpty()) {
                result.add((Object)uniformPath, (Object)EResourceType.CONTAINER);
                continue;
            }
            pathsToQueryFromIndex.add(uniformPath);
        }
        this.queryContainerIndexForPaths(pathsToQueryFromIndex, (PairList<String, EResourceType>)result);
        result.sort(Comparator.comparing(pathAndType -> (Integer)originalPositionsOfPaths.get(pathAndType.getFirst())));
        return result;
    }

    private void queryContainerIndexForPaths(List<String> pathsToQueryFromIndex, PairList<String, EResourceType> result) throws StorageException {
        if (pathsToQueryFromIndex.isEmpty()) {
            return;
        }
        List parentPaths = CollectionUtils.map(pathsToQueryFromIndex, UniformPathUtils::getParentPath);
        List infos = this.delegate.getValues(parentPaths);
        for (int i = 0; i < infos.size(); ++i) {
            ContainerInfo info = (ContainerInfo)infos.get(i);
            String uniformPath = pathsToQueryFromIndex.get(i);
            if (info == null || info.getHash(uniformPath) == null) {
                result.add((Object)uniformPath, (Object)EResourceType.UNKNOWN);
                continue;
            }
            if (info.childIsAContainer(uniformPath)) {
                result.add((Object)uniformPath, (Object)EResourceType.CONTAINER);
                continue;
            }
            result.add((Object)uniformPath, (Object)EResourceType.FILE);
        }
    }

    public void setName(String indexInstanceName) {
        this.indexInstanceName = indexInstanceName;
    }

    public String getName() {
        return this.indexInstanceName;
    }

    public List<@Nullable ContainerInfo> getContainers(List<String> uniformPaths) throws StorageException {
        return this.delegate.getValues(uniformPaths);
    }

    public ContainerInfo getContainer(String uniformPath) throws StorageException {
        return (ContainerInfo)this.delegate.getValue(uniformPath);
    }

    public void removeValues(Collection<String> uniformPaths) throws StorageException {
        this.delegate.removeValues(uniformPaths);
    }

    public void setContainers(PairList<String, ContainerInfo> uniformPathsAndContainers) throws StorageException {
        this.delegate.setValues(uniformPathsAndContainers);
    }

    public PairList<String, ContainerInfo> getContainersByPathPrefix(String prefix) throws StorageException {
        return this.delegate.getEntriesStartingWith(prefix);
    }

    public PairList<String, ContainerInfo> getAllContainers() throws StorageException {
        return this.delegate.getAllEntries();
    }
}

