/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import com.teamscale.core.utils.StoreWriteBuffer;
import com.teamscale.index.resource.ExternalAnalysisReportArchiveInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.engine.persistence.store.util.ValueSizeCollectingCallback;
import org.conqat.lib.commons.collections.ByteArrayWrapper;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@Index(name="external-analysis-report-archive", options={EStorageOption.COMPRESSED, EStorageOption.COMMIT_ISOLATED, EStorageOption.NO_ROLLBACK}, valueClasses={String.class})
public class ExternalAnalysisReportArchiveIndex
extends IndexBase
implements IProjectIndex {
    private static final int MAX_PREVIEW_LENGTH = 100 + "...".length();
    public static final String INDEX_NAME = "external-analysis-report-archive";
    private static final byte[] INFO_KEY_PREFIX = new byte[]{2};
    private static final byte[] REPORT_KEY_PREFIX = new byte[]{3};

    public ExternalAnalysisReportArchiveIndex(IStore store) {
        super(store);
    }

    public List<ExternalAnalysisReportArchiveInfo> getReportArchiveInfos(CommitDescriptor commit) throws StorageException {
        return (List)((Object)StorageUtils.deserialize((byte[])this.store.get(ExternalAnalysisReportArchiveIndex.makeInfoKey(commit))));
    }

    public String getReport(CommitDescriptor commitDescriptor, int reportIndex) throws StorageException {
        return (String)((Object)StorageUtils.deserialize((byte[])this.store.get(ExternalAnalysisReportArchiveIndex.makeReportKey(commitDescriptor, reportIndex))));
    }

    private static byte[] makeInfoKey(CommitDescriptor commit) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{INFO_KEY_PREFIX, commit.toBranchTimestampKeyWithSeparator()});
    }

    private static byte[] makeReportKey(CommitDescriptor commit, int counter) throws StorageException {
        return ByteArrayUtils.concat((byte[][])new byte[][]{REPORT_KEY_PREFIX, commit.toBranchTimestampKeyWithSeparator(), CommitDescriptor.SEPARATOR, StorageUtils.serialize((Serializable)Integer.valueOf(counter))});
    }

    private static @NonNull String createPreview(String report) {
        if (StringUtils.isEmpty((String)report)) {
            return "";
        }
        return StringUtils.truncateWithThreeDots((String)report, (int)MAX_PREVIEW_LENGTH);
    }

    private Map<ByteArrayWrapper, Integer> computeValueSizesInBytes() throws StorageException {
        ValueSizeCollectingCallback callback = new ValueSizeCollectingCallback();
        this.store.performWithLock(() -> this.store.scan(new byte[0], (IKeyValueCallback)callback));
        return callback.getValueSizes();
    }

    public long computeStoreSizeBytes() throws StorageException {
        return ExternalAnalysisReportArchiveIndex.sumKeySizesAndValues(this.computeValueSizesInBytes());
    }

    private static long sumKeySizesAndValues(Map<ByteArrayWrapper, Integer> reportSizes) {
        return reportSizes.entrySet().stream().mapToLong(entry -> Long.sum(((ByteArrayWrapper)entry.getKey()).getLength(), ((Integer)entry.getValue()).intValue())).sum();
    }

    public void removeEntriesForCommits(Set<CommitDescriptor> commits) throws StorageException {
        this.store.performWithLock(() -> {
            List keysToDelete = CollectionUtils.map((Collection)commits, ExternalAnalysisReportArchiveIndex::makeInfoKey);
            List reportKeysToDelete = CollectionUtils.mapWithException((Collection)keysToDelete, this::getAssociatedReportKeys).stream().flatMap(Collection::stream).toList();
            keysToDelete.addAll(reportKeysToDelete);
            this.store.remove(keysToDelete);
        });
    }

    public void storeReport(CommitDescriptor commit, String reportFilename, String reportContent) throws StorageException {
        this.storeReports(commit, PairList.from((Object)reportFilename, () -> reportContent));
    }

    public <ReportContent extends IStringRepresentationProvider> void storeReports(CommitDescriptor commit, PairList<String, ReportContent> reportFilenameAndContents) throws StorageException {
        this.store.performWithLock(() -> {
            List<ExternalAnalysisReportArchiveInfo> reportArchiveInfos = this.getReportArchiveInfos(commit);
            if (reportArchiveInfos == null) {
                reportArchiveInfos = new ArrayList<ExternalAnalysisReportArchiveInfo>();
            }
            HashMap<String, ExternalAnalysisReportArchiveInfo> reportArchiveInfosByPath = new HashMap<String, ExternalAnalysisReportArchiveInfo>();
            for (ExternalAnalysisReportArchiveInfo info : reportArchiveInfos) {
                reportArchiveInfosByPath.put(info.getFilename(), info);
            }
            int reportIndex = reportArchiveInfos.size();
            StoreWriteBuffer storeWriteBuffer = new StoreWriteBuffer((IStore)this.store);
            reportFilenameAndContents.sort(Comparator.comparing(ImmutablePair::getFirst));
            for (Pair reportFilenameAndContent : reportFilenameAndContents) {
                int indexOfNextReport;
                String filename = (String)reportFilenameAndContent.getFirst();
                String report = ((IStringRepresentationProvider)reportFilenameAndContent.getSecond()).convertToString();
                if (reportArchiveInfosByPath.containsKey(filename)) {
                    indexOfNextReport = ((ExternalAnalysisReportArchiveInfo)reportArchiveInfosByPath.get(filename)).getReportIndex();
                    reportArchiveInfos.remove(reportArchiveInfosByPath.get(filename));
                } else {
                    indexOfNextReport = reportIndex++;
                }
                reportArchiveInfosByPath.put(filename, new ExternalAnalysisReportArchiveInfo(filename, ExternalAnalysisReportArchiveIndex.createPreview(report), indexOfNextReport));
                byte[] reportKey = ExternalAnalysisReportArchiveIndex.makeReportKey(commit, indexOfNextReport);
                storeWriteBuffer.add(reportKey, StorageUtils.serialize((Serializable)((Object)report)));
            }
            storeWriteBuffer.add(ExternalAnalysisReportArchiveIndex.makeInfoKey(commit), StorageUtils.serialize(new ArrayList<ExternalAnalysisReportArchiveInfo>(reportArchiveInfosByPath.values().stream().sorted(Comparator.comparing(ExternalAnalysisReportArchiveInfo::getFilename)).toList())));
            storeWriteBuffer.flush();
        });
    }

    public void reduceToSize(long maxReportArchiveIndexSizeBytes) throws StorageException {
        this.store.performWithLock(() -> {
            Map<ByteArrayWrapper, Integer> valueSizesBytes = this.computeValueSizesInBytes();
            long storeSizeBytes = ExternalAnalysisReportArchiveIndex.sumKeySizesAndValues(valueSizesBytes);
            if (storeSizeBytes < maxReportArchiveIndexSizeBytes) {
                return;
            }
            List infoKeys = StorageUtils.listKeysStartingWith((byte[])INFO_KEY_PREFIX, (IStore)this.store);
            infoKeys.sort(Comparator.comparing(infoKey -> ExternalAnalysisReportArchiveIndex.getCommitDescriptorFromInfoKey(infoKey).getTimestamp()));
            long totalRemovalSizeBytes = 0L;
            ArrayList<byte[]> allKeysToRemove = new ArrayList<byte[]>();
            for (byte[] infoKey2 : infoKeys) {
                if (storeSizeBytes - totalRemovalSizeBytes <= maxReportArchiveIndexSizeBytes) break;
                List<byte[]> keysToRemove = this.getAssociatedReportKeys(infoKey2);
                keysToRemove.add(infoKey2);
                allKeysToRemove.addAll(keysToRemove);
                totalRemovalSizeBytes += ExternalAnalysisReportArchiveIndex.calculateSizeBytes(keysToRemove) + keysToRemove.stream().map(ByteArrayWrapper::new).mapToLong(valueSizesBytes::get).sum();
            }
            this.store.remove(allKeysToRemove);
        });
    }

    private static long calculateSizeBytes(List<byte[]> entries) {
        return entries.stream().mapToLong(key -> ((byte[])key).length).sum();
    }

    private List<byte[]> getAssociatedReportKeys(byte[] infoKey) throws StorageException {
        ArrayList reportArchiveInfos = (ArrayList)StorageUtils.deserialize((byte[])this.store.get(infoKey));
        CommitDescriptor commitDescriptor = ExternalAnalysisReportArchiveIndex.getCommitDescriptorFromInfoKey(infoKey);
        return CollectionUtils.mapWithException((Collection)CollectionUtils.emptyIfNull((List)reportArchiveInfos), reportArchiveInfo -> ExternalAnalysisReportArchiveIndex.makeReportKey(commitDescriptor, reportArchiveInfo.getReportIndex()));
    }

    private static @NonNull CommitDescriptor getCommitDescriptorFromInfoKey(byte[] infoKey) {
        return CommitDescriptor.fromBranchTimestampKeyWithSeparator((byte[])ByteArrayUtils.removePrefix((byte[])INFO_KEY_PREFIX, (byte[])infoKey));
    }

    public void removeAllEntries() throws StorageException {
        StorageUtils.clearStore((IStore)this.store);
    }

    @FunctionalInterface
    @IndexValueClass
    public static interface IStringRepresentationProvider {
        public String convertToString();
    }
}

