/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.signal_type;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.SimulinkPortBase;
import org.conqat.lib.simulink.types.SimulinkDataTypeUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;

public final class SimulinkNavigationUtils {
    public static List<SimulinkBlock> getNonSubsystemSuccessorBlocks(SimulinkBlock block) {
        ArrayList<SimulinkBlock> successorBlocks = new ArrayList<SimulinkBlock>();
        for (SimulinkOutPort port : block.getOutPorts()) {
            successorBlocks.addAll(SimulinkNavigationUtils.getNonSubsystemSuccessorBlock(block, port.getIndex()));
        }
        return successorBlocks;
    }

    private static List<SimulinkBlock> getNonSubsystemSuccessorBlock(SimulinkBlock block, String index) {
        SimulinkOutPort outPort = block.getOutPort(index);
        if (outPort == null) {
            return new ArrayList<SimulinkBlock>();
        }
        ArrayList<SimulinkBlock> successorBlocks = new ArrayList<SimulinkBlock>();
        List<SimulinkInPort> ports = outPort.getLines().stream().map(SimulinkLine::getDstPort).filter(Objects::nonNull).toList();
        for (SimulinkInPort port : ports) {
            if (port.getBlock().isOfType("SubSystem")) {
                List subBlock = SimulinkUtils.findInPortBlocks((SimulinkBlock)port.getBlock(), (String)port.getIndex());
                successorBlocks.addAll(subBlock);
                continue;
            }
            successorBlocks.add(port.getBlock());
        }
        return successorBlocks;
    }

    public static Optional<SimulinkBlock> getPredecessorBlockFromInputPort(SimulinkBlock block, String portIndex) {
        SimulinkOutPort connectedPort = SimulinkUtils.getConnectedOutPort((SimulinkInPort)block.getInPort(portIndex));
        if (connectedPort == null) {
            return Optional.empty();
        }
        SimulinkBlock connectedBlock = connectedPort.getBlock();
        if (connectedBlock.isOfType("SubSystem")) {
            return SimulinkUtils.findOutPortBlock((SimulinkBlock)connectedBlock, (String)connectedPort.getIndex());
        }
        return Optional.of(connectedBlock);
    }

    public static List<SimulinkBlock> getPredecessorAndSiblingsBlocks(SimulinkBlock block) {
        List<SimulinkOutPort> ports = block.getInLines().stream().map(SimulinkLine::getSrcPort).filter(Objects::nonNull).toList();
        ArrayList<SimulinkBlock> results = new ArrayList<SimulinkBlock>();
        for (SimulinkOutPort port : ports) {
            results.add(port.getBlock());
            for (SimulinkLine line : port.getLines()) {
                SimulinkBlock after;
                if (line.hasUnconnectedEndpoint() || (after = line.getDstPort().getBlock()).equals(block)) continue;
                results.add(after);
            }
        }
        return results;
    }

    public static List<SimulinkOutPort> getPredecessorPorts(SimulinkBlock block) {
        ArrayList<SimulinkOutPort> predecessorPorts = new ArrayList<SimulinkOutPort>();
        for (SimulinkLine inLine : block.getInLines()) {
            SimulinkOutPort predecessorPort = inLine.getSrcPort();
            if (predecessorPort == null) continue;
            predecessorPorts.add(predecessorPort);
        }
        return predecessorPorts;
    }

    public static List<SimulinkBlock> getPredecessors(SimulinkBlock block) {
        return block.getInLines().stream().map(SimulinkLine::getSrcPort).filter(Objects::nonNull).map(SimulinkPortBase::getBlock).collect(Collectors.toList());
    }

    public static @NonNull Set<SimulinkBlock> getResolvablePredecessors(@NonNull SimulinkBlock block) {
        return block.getInLines().stream().filter(line -> SimulinkDataTypeUtils.isPortWithBackPropagation((SimulinkInPort)line.getDstPort())).map(SimulinkLine::getSrcPort).filter(Objects::nonNull).map(SimulinkPortBase::getBlock).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static @NonNull Set<SimulinkBlock> getSuccessorsWithBackPropagation(@NonNull SimulinkBlock block) {
        HashSet<SimulinkBlock> successorsWithBackPropagation = new HashSet<SimulinkBlock>();
        for (SimulinkOutPort outPort : block.getOutPorts()) {
            successorsWithBackPropagation.addAll(SimulinkNavigationUtils.getSuccessorsWithBackPropagation(outPort));
        }
        return successorsWithBackPropagation;
    }

    public static @NonNull Set<SimulinkBlock> getSuccessorsWithBackPropagation(@NonNull SimulinkOutPort outPort) {
        HashSet<SimulinkBlock> successorsWithBackPropagation = new HashSet<SimulinkBlock>();
        for (SimulinkLine line : outPort.getLines()) {
            SimulinkBlock successor;
            SimulinkInPort dstPort = line.getDstPort();
            if (dstPort == null || (successor = dstPort.getBlock()) == null) continue;
            if (successor.isOfType("SubSystem")) {
                successorsWithBackPropagation.addAll(SimulinkUtils.findInPortBlocks((SimulinkBlock)successor, (String)dstPort.getIndex()));
                continue;
            }
            if (!SimulinkDataTypeUtils.isPortWithBackPropagation((SimulinkInPort)dstPort)) continue;
            successorsWithBackPropagation.add(successor);
        }
        return successorsWithBackPropagation;
    }

    private SimulinkNavigationUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

