/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.index;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.index.resource.CodeScopesMappingIndex;
import com.teamscale.index.resource.ExtendedResourceTypeIndex;
import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.index.testgap.AssociatedMethodTestInfo;
import com.teamscale.index.testgap.MethodInfoIndex;
import com.teamscale.index.testgap.MethodLastTestedIndex;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testgap.TestGapEnablementChecker;
import com.teamscale.index.testgap.TgaDataRetrieverIndexes;
import com.teamscale.index.testgap.index.CrossAnnotator;
import com.teamscale.index.testgap.index.TestInfoFilter;
import com.teamscale.index.testgap.index.UnassessedTestGapData;
import com.teamscale.index.testgap.query.MethodInfoFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class DataRetrieverUtils {
    public static UnassessedTestGapData createUnassessedTestGapData(Collection<AssociatedMethodInfo> allMethodsInfos, List<String> partitions, CrossAnnotator crossAnnotator, TgaDataRetrieverIndexes dataRetrieverIndexes, MethodInfoFilter methodInfoFilter, TestInfoFilter testInfoFilter, CodeScopeAware<Boolean> tgaEnablementPerCodeScope) throws StorageException {
        List<AssociatedMethodInfo> filteredMethodInfos = DataRetrieverUtils.filterMethods(allMethodsInfos, methodInfoFilter, dataRetrieverIndexes.getExtendedResourceTypeIndex(), dataRetrieverIndexes.getCodeScopesMappingIndex(), tgaEnablementPerCodeScope);
        ListMap<MethodLocation, AssociatedMethodTestInfo> testInfoByMethodLocation = DataRetrieverUtils.loadTestInfos(partitions, testInfoFilter, filteredMethodInfos, dataRetrieverIndexes.getMethodLastTestedIndex());
        UnassessedTestGapData result = new UnassessedTestGapData();
        for (AssociatedMethodInfo methodInfo : filteredMethodInfos) {
            MethodLocation methodLocation = methodInfo.getLocation();
            List correspondingTestInfos = (List)testInfoByMethodLocation.getCollection((Object)methodLocation);
            long lastTestedTimestamp = -1L;
            if (correspondingTestInfos != null) {
                lastTestedTimestamp = correspondingTestInfos.stream().mapToLong(AssociatedMethodTestInfo::getTimestamp).max().orElse(-1L);
            }
            UnassessedTestGapData.UnassessedMethodData methodData = new UnassessedTestGapData.UnassessedMethodData(methodLocation, methodInfo.getCreationTimestamp(), methodInfo.getLastChangedTimestamp(), lastTestedTimestamp, crossAnnotator.isExecutedByCrossAnnotation(methodInfo), methodInfo.getMethodName());
            result.addMethod(methodData);
        }
        return result;
    }

    private static ListMap<MethodLocation, AssociatedMethodTestInfo> loadTestInfos(List<String> partitions, TestInfoFilter testInfoFilter, List<AssociatedMethodInfo> methodInfos, MethodLastTestedIndex methodLastTestedIndex) throws StorageException {
        Set<MethodLocation> methodLocationsForTestData = methodInfos.stream().filter(testInfoFilter::assessmentRequiresTestInfo).map(AssociatedMethodInfo::getLocation).collect(Collectors.toSet());
        List<AssociatedMethodTestInfo> testInfos = methodLastTestedIndex.getTestInfosForMethodLocationsInPartitions(partitions, methodLocationsForTestData);
        ListMap testInfoByMethodLocation = new ListMap();
        for (AssociatedMethodTestInfo testInfo : testInfos) {
            testInfoByMethodLocation.add((Object)testInfo.getLocation(), (Object)testInfo);
        }
        return testInfoByMethodLocation;
    }

    private static List<AssociatedMethodInfo> filterMethods(Collection<AssociatedMethodInfo> allMethodsInfos, MethodInfoFilter methodInfoFilter, ExtendedResourceTypeIndex extendedResourceTypeIndex, CodeScopesMappingIndex codeScopesMappingIndex, CodeScopeAware<Boolean> tgaEnablementPerCodeScope) throws StorageException {
        ArrayList<UniformPath> uniformPaths = new ArrayList<UniformPath>(CollectionUtils.mapToSet(allMethodsInfos, AssociatedMethodInfo::getUniformPath));
        TestGapEnablementChecker tgaEnablementChecker = new TestGapEnablementChecker(uniformPaths, codeScopesMappingIndex, tgaEnablementPerCodeScope);
        Set<UniformPath> testUniformPaths = extendedResourceTypeIndex.getTestCodePaths((Collection<UniformPath>)uniformPaths);
        return allMethodsInfos.stream().filter(methodInfo -> {
            UniformPath uniformPath = methodInfo.getUniformPath();
            return methodInfoFilter.isRelevantMethod((AssociatedMethodInfo)methodInfo, testUniformPaths.contains(uniformPath), tgaEnablementChecker.isTgaEnabled(uniformPath));
        }).toList();
    }

    public static List<AssociatedMethodInfo> filterAssociatedMethodInfosToChangesFromCurrentBranch(@Nullable List<CommitDescriptor> codeCommitsOfSourceBranch, @Nullable MethodInfoIndex mergeBaseMethodInfoIndex, List<UniformPath> uniformPaths, List<AssociatedMethodInfo> methodInfos) throws StorageException {
        boolean hasMergeBase;
        boolean bl = hasMergeBase = codeCommitsOfSourceBranch != null && mergeBaseMethodInfoIndex != null;
        if (!hasMergeBase) {
            return methodInfos;
        }
        Set methodHashesFromMergeBase = CollectionUtils.mapToSet(mergeBaseMethodInfoIndex.getAssociatedMethodInfosForExactPathsWithCrossAnnotationInfo(uniformPaths), methodInfo -> new ImmutablePair((Object)methodInfo.getUniformPath(), (Object)(methodInfo.getHash() + methodInfo.getMethodName())));
        methodInfos.removeIf(methodInfo -> methodHashesFromMergeBase.contains(new ImmutablePair((Object)methodInfo.getUniformPath(), (Object)(methodInfo.getHash() + methodInfo.getMethodName()))));
        return methodInfos;
    }

    public static UnassessedTestGapData createUnassessedTestExecutionData(Collection<AssociatedMethodInfo> allMethods, List<MethodLocation> methodsExecutedByTest, long testTimestamp, CrossAnnotator crossAnnotator, ExtendedResourceTypeIndex extendedResourceTypeIndex, MethodInfoFilter methodInfoFilter, CodeScopesMappingIndex codeScopesMappingIndex, CodeScopeAware<Boolean> tgaEnablementPerCodeScope) throws StorageException {
        HashSet<MethodLocation> methodSetExecutedByTest = new HashSet<MethodLocation>(methodsExecutedByTest);
        List<AssociatedMethodInfo> filteredMethods = DataRetrieverUtils.filterMethods(allMethods, methodInfoFilter, extendedResourceTypeIndex, codeScopesMappingIndex, tgaEnablementPerCodeScope);
        UnassessedTestGapData result = new UnassessedTestGapData();
        for (AssociatedMethodInfo methodInfo : filteredMethods) {
            MethodLocation methodLocation = methodInfo.getLocation();
            long lastTestedTimestamp = -1L;
            if (methodSetExecutedByTest.contains(methodLocation)) {
                lastTestedTimestamp = testTimestamp;
            }
            UnassessedTestGapData.UnassessedMethodData methodData = new UnassessedTestGapData.UnassessedMethodData(methodLocation, methodInfo.getCreationTimestamp(), methodInfo.getLastChangedTimestamp(), lastTestedTimestamp, crossAnnotator.isExecutedByCrossAnnotation(methodInfo), methodInfo.getMethodName());
            result.addMethod(methodData);
        }
        return result;
    }

    private DataRetrieverUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

