/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testimpact;

import com.google.common.base.Preconditions;
import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.index.testgap.MethodInfoIndex;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testimpact.MethodId;
import com.teamscale.index.testimpact.MethodIdIndex;
import com.teamscale.index.testimpact.MethodIdMap;
import com.teamscale.index.testimpact.MethodLocationOffsetMapping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class MethodIdMapper {
    private static final Logger LOGGER = LogManager.getLogger();
    private final MethodIdIndex methodIdIndex;
    private final List<MethodIdIndex> parentMethodIdIndices;
    private final MethodInfoIndex methodInfoIndex;
    private final List<Map<MethodId, MethodId>> mapChangedMethodIds = new ArrayList<Map<MethodId, MethodId>>();
    private final List<Set<MethodId>> mapUnchangedMethodIds = new ArrayList<Set<MethodId>>();
    private final List<Set<MethodId>> deletedMethodIds = new ArrayList<Set<MethodId>>();
    private final List<Set<UniformPath>> preloadedUniformPaths = new ArrayList<Set<UniformPath>>();
    private final List<MethodIdMap> uniformPathToMethodIdMapping = new ArrayList<MethodIdMap>();
    private MethodIdMap mergedUniformPathToMethodIdMapping;
    private final SetMap<UniformPath, OffsetBasedRegion> existingMethodsInFiles = new SetMap();
    private final Set<MethodId> realChanges = new HashSet<MethodId>();

    public MethodIdMapper(MethodIdIndex methodIdIndex, List<MethodIdIndex> parentMethodIdIndices, MethodInfoIndex methodInfoIndex) {
        this.methodIdIndex = methodIdIndex;
        this.parentMethodIdIndices = parentMethodIdIndices;
        this.methodInfoIndex = methodInfoIndex;
        for (int parentIndex = 0; parentIndex < parentMethodIdIndices.size(); ++parentIndex) {
            this.preloadedUniformPaths.add(new HashSet());
            this.mapChangedMethodIds.add(new HashMap());
            this.mapUnchangedMethodIds.add(new HashSet());
            this.deletedMethodIds.add(new HashSet());
        }
    }

    public void preload(int parentIndex, List<UniformPath> uniformPaths) throws StorageException {
        this.preloadedUniformPaths.get(parentIndex).addAll(uniformPaths);
        MethodIdMap methodIdMap = this.parentMethodIdIndices.get(parentIndex).getAllMappingsFor(uniformPaths);
        Preconditions.checkState((this.uniformPathToMethodIdMapping.size() == parentIndex ? 1 : 0) != 0);
        this.uniformPathToMethodIdMapping.add(methodIdMap);
        if (parentIndex == 0) {
            this.mergedUniformPathToMethodIdMapping = new MethodIdMap(this.uniformPathToMethodIdMapping.getFirst());
            List<AssociatedMethodInfo> changedMethodInfos = this.methodInfoIndex.getAssociatedMethodInfosForExactPathsWithoutCrossAnnotationInfo(uniformPaths);
            for (AssociatedMethodInfo info : changedMethodInfos) {
                this.existingMethodsInFiles.add((Object)info.getUniformPath(), (Object)info.getAssociatedRegion());
            }
        }
    }

    public Optional<MethodId> translateToNewMethodId(int parentIndex, MethodId parentMethodId) throws StorageException {
        if (this.deletedMethodIds.get(parentIndex).contains(parentMethodId)) {
            return Optional.empty();
        }
        if (this.mapUnchangedMethodIds.get(parentIndex).contains(parentMethodId)) {
            return Optional.of(parentMethodId);
        }
        if (this.mapChangedMethodIds.get(parentIndex).containsKey(parentMethodId)) {
            return Optional.of(this.mapChangedMethodIds.get(parentIndex).get(parentMethodId));
        }
        this.ensureLoaded(parentIndex, parentMethodId.getUniformPath());
        MethodLocation location = this.uniformPathToMethodIdMapping.get(parentIndex).getMethodLocation(parentMethodId);
        if (location == null || !this.doesMethodLocationExist(location)) {
            this.deletedMethodIds.get(parentIndex).add(parentMethodId);
            return Optional.empty();
        }
        MethodId newMethodId = this.mergedUniformPathToMethodIdMapping.getOrInsertMethodLocation(location);
        if (newMethodId.equals((Object)parentMethodId)) {
            this.mapUnchangedMethodIds.get(parentIndex).add(newMethodId);
        } else {
            this.mapChangedMethodIds.get(parentIndex).put(parentMethodId, newMethodId);
        }
        return Optional.of(newMethodId);
    }

    private boolean doesMethodLocationExist(MethodLocation location) throws StorageException {
        this.ensureLoaded(0, location.getUniformPath());
        Set regionsInFile = (Set)this.existingMethodsInFiles.getCollection((Object)location.getUniformPath());
        return regionsInFile != null && regionsInFile.contains(location.getRegion());
    }

    private void ensureLoaded(int parentIndex, UniformPath uniformPath) throws StorageException {
        MethodLocationOffsetMapping methodLocationOffsetMapping;
        if (this.preloadedUniformPaths.get(parentIndex).contains(uniformPath)) {
            return;
        }
        this.preloadedUniformPaths.get(parentIndex).add(uniformPath);
        if (parentIndex == 0) {
            List<AssociatedMethodInfo> changedMethodInfos = this.methodInfoIndex.getAssociatedMethodInfosForExactPathsWithoutCrossAnnotationInfo(Collections.singletonList(uniformPath));
            for (AssociatedMethodInfo info : changedMethodInfos) {
                this.existingMethodsInFiles.add((Object)info.getUniformPath(), (Object)info.getAssociatedRegion());
            }
        }
        if ((methodLocationOffsetMapping = this.parentMethodIdIndices.get(parentIndex).getAllMappingsFor(uniformPath)) == null && parentIndex > 0) {
            LOGGER.error("No method IDs found for " + String.valueOf(uniformPath) + " during merge!");
        }
        if (parentIndex == 0 && methodLocationOffsetMapping != null) {
            this.mergedUniformPathToMethodIdMapping.insert(uniformPath, new MethodLocationOffsetMapping(methodLocationOffsetMapping));
        }
        this.uniformPathToMethodIdMapping.get(parentIndex).insert(uniformPath, methodLocationOffsetMapping);
    }

    public void registerDeletedMethod(int parentIndex, MethodLocation parentMethodLocation) {
        MethodId parentMethodId = this.uniformPathToMethodIdMapping.get(parentIndex).getMethodId(parentMethodLocation);
        if (parentMethodId == null) {
            return;
        }
        if (parentIndex == 0) {
            this.mergedUniformPathToMethodIdMapping.removeMethodId(parentMethodId);
        }
        this.deletedMethodIds.get(parentIndex).add(parentMethodId);
    }

    public void registerChange(int parentIndex, MethodLocation parentMethodLocation, MethodLocation methodLocation) {
        MethodId parentMethodId = this.uniformPathToMethodIdMapping.get(parentIndex).getMethodId(parentMethodLocation);
        if (parentMethodId == null) {
            return;
        }
        if (methodLocation.getUniformPath().equals((Object)parentMethodLocation.getUniformPath())) {
            if (parentIndex == 0) {
                this.mergedUniformPathToMethodIdMapping.changeRegion(parentMethodId, parentMethodLocation, methodLocation);
                this.mapUnchangedMethodIds.get(parentIndex).add(parentMethodId);
            } else {
                MethodId newMethodId = this.mergedUniformPathToMethodIdMapping.getOrInsertMethodLocation(methodLocation);
                if (!parentMethodId.equals((Object)newMethodId)) {
                    this.mapChangedMethodIds.get(parentIndex).put(parentMethodId, newMethodId);
                } else {
                    this.mapUnchangedMethodIds.get(parentIndex).add(parentMethodId);
                }
            }
        } else {
            if (parentIndex == 0) {
                this.mergedUniformPathToMethodIdMapping.removeMethodId(parentMethodId);
            }
            MethodId newMethodId = this.mergedUniformPathToMethodIdMapping.getOrInsertMethodLocation(methodLocation);
            this.mapChangedMethodIds.get(parentIndex).put(parentMethodId, newMethodId);
        }
    }

    public Set<MethodId> getDeletedMethodIds(int parentIndex) {
        return this.deletedMethodIds.get(parentIndex);
    }

    public List<MethodId> getUpdatedAndDeletedParentMethodIds(int parentIndex) {
        ArrayList<MethodId> methodIds = new ArrayList<MethodId>((Collection)this.deletedMethodIds.get(parentIndex));
        methodIds.addAll(this.mapChangedMethodIds.get(parentIndex).keySet());
        return methodIds;
    }

    public void persist() throws StorageException {
        this.methodIdIndex.storeUpdatedMappings(this.mergedUniformPathToMethodIdMapping);
    }

    public void registerRealChange(MethodLocation methodLocation) {
        MethodId methodId = this.mergedUniformPathToMethodIdMapping.getMethodId(methodLocation);
        if (methodId != null) {
            this.realChanges.add(methodId);
        }
    }

    public boolean hasKnownMapping(int parentIndex, MethodLocation parentMethodLocation) {
        MethodId parentMethodId = this.uniformPathToMethodIdMapping.get(parentIndex).getMethodId(parentMethodLocation);
        if (parentMethodId == null) {
            return false;
        }
        return this.mapUnchangedMethodIds.get(parentIndex).contains(parentMethodId) || this.mapChangedMethodIds.get(parentIndex).containsKey(parentMethodId);
    }

    public Set<MethodId> getMethodIdsInChildRevisionWithChangedMethodBody() {
        return this.realChanges;
    }
}

