/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import org.sonar.api.batch.fs.InputDir;
import org.sonar.api.utils.PathUtils;

public class SonarLintInputDir
implements InputDir {
    private final Path path;

    public SonarLintInputDir(Path path) {
        this.path = path;
    }

    @Override
    public String relativePath() {
        return this.absolutePath();
    }

    @Override
    public String absolutePath() {
        return PathUtils.sanitize(this.path().toString());
    }

    @Override
    public File file() {
        return this.path().toFile();
    }

    @Override
    public Path path() {
        return this.path;
    }

    @Override
    public String key() {
        return this.absolutePath();
    }

    @Override
    public URI uri() {
        return this.path.toUri();
    }

    @Override
    public boolean isFile() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SonarLintInputDir)) {
            return false;
        }
        SonarLintInputDir that = (SonarLintInputDir)o;
        return this.path().equals(that.path());
    }

    public int hashCode() {
        return this.path().hashCode();
    }

    public String toString() {
        return "[path=" + this.path() + "]";
    }
}

