/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.sonarapi;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import org.sonar.api.Startable;
import org.sonar.api.utils.TempFolder;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.shaded.org.apache.commons.io.FileUtils;

public class DefaultTempFolder
implements TempFolder,
Startable {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final File tempDir;
    private final boolean deleteOnExit;

    public DefaultTempFolder(File tempDir) {
        this(tempDir, false);
    }

    public DefaultTempFolder(File tempDir, boolean deleteOnExit) {
        this.tempDir = tempDir;
        this.deleteOnExit = deleteOnExit;
    }

    @Override
    public File newDir() {
        return DefaultTempFolder.createTempDir(this.tempDir.toPath()).toFile();
    }

    private static Path createTempDir(Path baseDir) {
        try {
            return Files.createTempDirectory(baseDir, null, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create temp directory", e);
        }
    }

    @Override
    public File newDir(String name) {
        File dir = new File(this.tempDir, name);
        try {
            FileUtils.forceMkdir(dir);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create temp directory - " + dir, e);
        }
        return dir;
    }

    @Override
    public File newFile() {
        return this.newFile(null, null);
    }

    @Override
    public File newFile(@Nullable String prefix, @Nullable String suffix) {
        return DefaultTempFolder.createTempFile(this.tempDir.toPath(), prefix, suffix).toFile();
    }

    private static Path createTempFile(Path baseDir, @Nullable String prefix, @Nullable String suffix) {
        try {
            return Files.createTempFile(baseDir, prefix, suffix, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create temp file", e);
        }
    }

    public void clean() {
        try {
            if (this.tempDir.exists()) {
                Files.walkFileTree(this.tempDir.toPath(), DeleteRecursivelyFileVisitor.INSTANCE);
            }
        }
        catch (IOException e) {
            LOG.error("Failed to delete temp folder", e);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        if (this.deleteOnExit) {
            this.clean();
        }
    }

    private static final class DeleteRecursivelyFileVisitor
    extends SimpleFileVisitor<Path> {
        public static final DeleteRecursivelyFileVisitor INSTANCE = new DeleteRecursivelyFileVisitor();

        private DeleteRecursivelyFileVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.deleteIfExists(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            Files.deleteIfExists(dir);
            return FileVisitResult.CONTINUE;
        }
    }
}

