/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.client.api.common;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.analysis.api.ClientModulesProvider;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.commons.SonarLintUserHome;
import org.sonarsource.sonarlint.core.commons.Version;
import org.sonarsource.sonarlint.core.commons.log.ClientLogOutput;

public abstract class AbstractGlobalConfiguration {
    public static final String DEFAULT_WORK_DIR = "work";
    private final ClientLogOutput logOutput;
    private final Path sonarLintUserHome;
    private final Path workDir;
    private final EnumSet<Language> enabledLanguages;
    private final Map<String, String> extraProperties;
    private final Path nodeJsPath;
    private final Version nodeJsVersion;
    private final ClientModulesProvider modulesProvider;
    private final long clientPid;

    protected AbstractGlobalConfiguration(AbstractBuilder<?> builder) {
        this.sonarLintUserHome = builder.sonarlintUserHome != null ? builder.sonarlintUserHome : SonarLintUserHome.get();
        this.workDir = builder.workDir != null ? builder.workDir : this.sonarLintUserHome.resolve(DEFAULT_WORK_DIR);
        this.enabledLanguages = builder.enabledLanguages;
        this.logOutput = builder.logOutput;
        this.extraProperties = new LinkedHashMap<String, String>(builder.extraProperties);
        this.nodeJsPath = builder.nodeJsPath;
        this.nodeJsVersion = builder.nodeJsVersion;
        this.modulesProvider = builder.modulesProvider;
        this.clientPid = builder.clientPid;
    }

    public Map<String, String> extraProperties() {
        return Collections.unmodifiableMap(this.extraProperties);
    }

    public ClientModulesProvider getModulesProvider() {
        return this.modulesProvider;
    }

    public Path getSonarLintUserHome() {
        return this.sonarLintUserHome;
    }

    public Path getWorkDir() {
        return this.workDir;
    }

    public Set<Language> getEnabledLanguages() {
        return this.enabledLanguages;
    }

    @CheckForNull
    public ClientLogOutput getLogOutput() {
        return this.logOutput;
    }

    @CheckForNull
    public Path getNodeJsPath() {
        return this.nodeJsPath;
    }

    @CheckForNull
    public Version getNodeJsVersion() {
        return this.nodeJsVersion;
    }

    public long getClientPid() {
        return this.clientPid;
    }

    public static abstract class AbstractBuilder<G extends AbstractBuilder<G>> {
        private ClientLogOutput logOutput;
        private Path sonarlintUserHome;
        private Path workDir;
        private final EnumSet<Language> enabledLanguages = EnumSet.noneOf(Language.class);
        private Map<String, String> extraProperties = Collections.emptyMap();
        private Path nodeJsPath;
        private Version nodeJsVersion;
        private ClientModulesProvider modulesProvider;
        private long clientPid;

        public G setLogOutput(@Nullable ClientLogOutput logOutput) {
            this.logOutput = logOutput;
            return (G)this;
        }

        public G setSonarLintUserHome(Path sonarlintUserHome) {
            this.sonarlintUserHome = sonarlintUserHome;
            return (G)this;
        }

        public G setWorkDir(Path workDir) {
            this.workDir = workDir;
            return (G)this;
        }

        public G setExtraProperties(Map<String, String> extraProperties) {
            this.extraProperties = extraProperties;
            return (G)this;
        }

        public G addEnabledLanguage(Language language) {
            this.enabledLanguages.add(language);
            return (G)this;
        }

        public G addEnabledLanguages(Language ... languages) {
            this.enabledLanguages.addAll(Arrays.asList(languages));
            return (G)this;
        }

        public G setNodeJs(Path nodeJsPath, Version nodeJsVersion) {
            this.nodeJsPath = nodeJsPath;
            this.nodeJsVersion = nodeJsVersion;
            return (G)this;
        }

        public G setModulesProvider(ClientModulesProvider modulesProvider) {
            this.modulesProvider = modulesProvider;
            return (G)this;
        }

        public G setClientPid(long clientPid) {
            this.clientPid = clientPid;
            return (G)this;
        }
    }
}

