/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.clientapi.backend.initialize;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.clientapi.backend.connection.config.SonarCloudConnectionConfigurationDto;
import org.sonarsource.sonarlint.core.clientapi.backend.connection.config.SonarQubeConnectionConfigurationDto;
import org.sonarsource.sonarlint.core.clientapi.backend.initialize.ClientInfoDto;
import org.sonarsource.sonarlint.core.clientapi.backend.initialize.FeatureFlagsDto;
import org.sonarsource.sonarlint.core.clientapi.backend.rules.StandaloneRuleConfigDto;
import org.sonarsource.sonarlint.core.commons.Language;

public class InitializeParams {
    private final ClientInfoDto clientInfo;
    private final FeatureFlagsDto featureFlags;
    private final Path storageRoot;
    @Nullable
    private final Path workDir;
    private final Set<Path> embeddedPluginPaths;
    private final Map<String, Path> connectedModeEmbeddedPluginPathsByKey;
    private final Set<Language> enabledLanguagesInStandaloneMode;
    private final Set<Language> extraEnabledLanguagesInConnectedMode;
    private final List<SonarQubeConnectionConfigurationDto> sonarQubeConnections;
    private final List<SonarCloudConnectionConfigurationDto> sonarCloudConnections;
    private final String sonarlintUserHome;
    private final Map<String, StandaloneRuleConfigDto> standaloneRuleConfigByKey;
    private final boolean isFocusOnNewCode;

    public InitializeParams(ClientInfoDto clientInfo, FeatureFlagsDto featureFlags, Path storageRoot, @Nullable Path workDir, Set<Path> embeddedPluginPaths, Map<String, Path> connectedModeEmbeddedPluginPathsByKey, Set<Language> enabledLanguagesInStandaloneMode, Set<Language> extraEnabledLanguagesInConnectedMode, List<SonarQubeConnectionConfigurationDto> sonarQubeConnections, List<SonarCloudConnectionConfigurationDto> sonarCloudConnections, @Nullable String sonarlintUserHome, Map<String, StandaloneRuleConfigDto> standaloneRuleConfigByKey, boolean isFocusOnNewCode) {
        this.clientInfo = clientInfo;
        this.featureFlags = featureFlags;
        this.storageRoot = storageRoot;
        this.workDir = workDir;
        this.embeddedPluginPaths = embeddedPluginPaths;
        this.connectedModeEmbeddedPluginPathsByKey = connectedModeEmbeddedPluginPathsByKey;
        this.enabledLanguagesInStandaloneMode = enabledLanguagesInStandaloneMode;
        this.extraEnabledLanguagesInConnectedMode = extraEnabledLanguagesInConnectedMode;
        this.sonarQubeConnections = sonarQubeConnections;
        this.sonarCloudConnections = sonarCloudConnections;
        this.sonarlintUserHome = sonarlintUserHome;
        this.standaloneRuleConfigByKey = standaloneRuleConfigByKey;
        this.isFocusOnNewCode = isFocusOnNewCode;
    }

    public ClientInfoDto getClientInfo() {
        return this.clientInfo;
    }

    public FeatureFlagsDto getFeatureFlags() {
        return this.featureFlags;
    }

    public Path getStorageRoot() {
        return this.storageRoot;
    }

    @CheckForNull
    public Path getWorkDir() {
        return this.workDir;
    }

    public Set<Path> getEmbeddedPluginPaths() {
        return this.embeddedPluginPaths;
    }

    public Map<String, Path> getConnectedModeEmbeddedPluginPathsByKey() {
        return this.connectedModeEmbeddedPluginPathsByKey;
    }

    public Set<Language> getEnabledLanguagesInStandaloneMode() {
        return this.enabledLanguagesInStandaloneMode;
    }

    public Set<Language> getExtraEnabledLanguagesInConnectedMode() {
        return this.extraEnabledLanguagesInConnectedMode;
    }

    public List<SonarQubeConnectionConfigurationDto> getSonarQubeConnections() {
        return this.sonarQubeConnections;
    }

    public List<SonarCloudConnectionConfigurationDto> getSonarCloudConnections() {
        return this.sonarCloudConnections;
    }

    @CheckForNull
    public String getSonarlintUserHome() {
        return this.sonarlintUserHome;
    }

    public Map<String, StandaloneRuleConfigDto> getStandaloneRuleConfigByKey() {
        return this.standaloneRuleConfigByKey;
    }

    public boolean isFocusOnNewCode() {
        return this.isFocusOnNewCode;
    }
}

