/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.clientapi.backend.rules;

import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.commons.CleanCodeAttribute;
import org.sonarsource.sonarlint.core.commons.ImpactSeverity;
import org.sonarsource.sonarlint.core.commons.IssueSeverity;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.commons.RuleType;
import org.sonarsource.sonarlint.core.commons.SoftwareQuality;

public abstract class AbstractRuleDto {
    private final String key;
    private final String name;
    private final IssueSeverity severity;
    private final RuleType type;
    private final CleanCodeAttribute cleanCodeAttribute;
    private final Map<SoftwareQuality, ImpactSeverity> defaultImpacts;
    private final Language language;

    AbstractRuleDto(String key, String name, IssueSeverity severity, RuleType type, @Nullable CleanCodeAttribute cleanCodeAttribute, Map<SoftwareQuality, ImpactSeverity> defaultImpacts, Language language) {
        this.key = key;
        this.name = name;
        this.severity = severity;
        this.type = type;
        this.cleanCodeAttribute = cleanCodeAttribute;
        this.defaultImpacts = defaultImpacts;
        this.language = language;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public IssueSeverity getSeverity() {
        return this.severity;
    }

    public RuleType getType() {
        return this.type;
    }

    public Optional<CleanCodeAttribute> getCleanCodeAttribute() {
        return Optional.ofNullable(this.cleanCodeAttribute);
    }

    public Map<SoftwareQuality, ImpactSeverity> getDefaultImpacts() {
        return this.defaultImpacts;
    }

    public Language getLanguage() {
        return this.language;
    }
}

