/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection;

import java.time.Instant;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.commons.Version;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.commons.progress.ProgressMonitor;
import org.sonarsource.sonarlint.core.serverapi.hotspot.HotspotApi;
import org.sonarsource.sonarlint.core.serverapi.hotspot.ServerHotspot;
import org.sonarsource.sonarlint.core.serverconnection.ConnectionStorage;
import org.sonarsource.sonarlint.core.serverconnection.HotspotDownloader;
import org.sonarsource.sonarlint.core.serverconnection.IssueStorePaths;
import org.sonarsource.sonarlint.core.serverconnection.ProjectBinding;
import org.sonarsource.sonarlint.core.serverconnection.ServerUpdaterUtils;

public class ServerHotspotUpdater {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final ConnectionStorage storage;
    private final HotspotDownloader hotspotDownloader;

    public ServerHotspotUpdater(ConnectionStorage storage, HotspotDownloader hotspotDownloader) {
        this.storage = storage;
        this.hotspotDownloader = hotspotDownloader;
    }

    public void updateAll(HotspotApi hotspotApi, String projectKey, String branchName, Supplier<Version> serverVersionSupplier, ProgressMonitor progress) {
        if (hotspotApi.permitsTracking(serverVersionSupplier)) {
            Collection<ServerHotspot> projectHotspots = hotspotApi.getAll(projectKey, branchName, progress);
            this.storage.project(projectKey).findings().replaceAllHotspotsOfBranch(branchName, projectHotspots);
        } else {
            LOG.info("Skip downloading hotspots from server, not supported");
        }
    }

    public void updateForFile(HotspotApi hotspotApi, ProjectBinding projectBinding, String ideFilePath, String branchName, Supplier<Version> serverVersionSupplier) {
        String serverFilePath = IssueStorePaths.idePathToServerPath(projectBinding, ideFilePath);
        if (serverFilePath == null) {
            return;
        }
        this.updateForFile(hotspotApi, projectBinding.projectKey(), serverFilePath, branchName, serverVersionSupplier);
    }

    public void updateForFile(HotspotApi hotspotApi, String projectKey, String serverFilePath, String branchName, Supplier<Version> serverVersionSupplier) {
        if (hotspotApi.supportHotspotsPull(serverVersionSupplier)) {
            LOG.debug("Skip downloading file hotspots on SonarQube 10.1+");
            return;
        }
        if (hotspotApi.permitsTracking(serverVersionSupplier)) {
            Collection<ServerHotspot> fileHotspots = hotspotApi.getFromFile(projectKey, serverFilePath, branchName);
            this.storage.project(projectKey).findings().replaceAllHotspotsOfFile(branchName, serverFilePath, fileHotspots);
        } else {
            LOG.info("Skip downloading hotspots for file, not supported");
        }
    }

    public void sync(HotspotApi hotspotApi, String projectKey, String branchName, Set<Language> enabledLanguages) {
        Optional<Instant> lastSync = this.storage.project(projectKey).findings().getLastHotspotSyncTimestamp(branchName);
        lastSync = ServerUpdaterUtils.computeLastSync(enabledLanguages, lastSync, this.storage.project(projectKey).findings().getLastHotspotEnabledLanguages(branchName));
        HotspotDownloader.PullResult result = this.hotspotDownloader.downloadFromPull(hotspotApi, projectKey, branchName, lastSync);
        this.storage.project(projectKey).findings().mergeHotspots(branchName, result.getChangedHotspots(), result.getClosedHotspotKeys(), result.getQueryTimestamp(), enabledLanguages);
    }
}

