/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection.events.ruleset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.sonarsource.sonarlint.core.serverapi.push.RuleSetChangedEvent;
import org.sonarsource.sonarlint.core.serverapi.rules.ServerActiveRule;
import org.sonarsource.sonarlint.core.serverconnection.AnalyzerConfiguration;
import org.sonarsource.sonarlint.core.serverconnection.ConnectionStorage;
import org.sonarsource.sonarlint.core.serverconnection.RuleSet;
import org.sonarsource.sonarlint.core.serverconnection.events.ServerEventHandler;

public class UpdateStorageOnRuleSetChanged
implements ServerEventHandler<RuleSetChangedEvent> {
    private final ConnectionStorage storage;

    public UpdateStorageOnRuleSetChanged(ConnectionStorage storage) {
        this.storage = storage;
    }

    @Override
    public void handle(RuleSetChangedEvent event) {
        event.getProjectKeys().forEach(projectKey -> this.storage.project((String)projectKey).analyzerConfiguration().update(currentConfiguration -> {
            Map<String, RuleSet> newRuleSetByLanguageKey = UpdateStorageOnRuleSetChanged.incorporate(event, currentConfiguration.getRuleSetByLanguageKey());
            return new AnalyzerConfiguration(currentConfiguration.getSettings(), newRuleSetByLanguageKey, currentConfiguration.getSchemaVersion());
        }));
    }

    private static Map<String, RuleSet> incorporate(RuleSetChangedEvent event, Map<String, RuleSet> ruleSetByLanguageKey) {
        HashMap<String, RuleSet> resultingRuleSetsByLanguageKey = new HashMap<String, RuleSet>(ruleSetByLanguageKey);
        event.getDeactivatedRules().forEach(deactivatedRule -> UpdateStorageOnRuleSetChanged.deactivate(deactivatedRule, resultingRuleSetsByLanguageKey));
        event.getActivatedRules().forEach(activatedRule -> UpdateStorageOnRuleSetChanged.activate(activatedRule, resultingRuleSetsByLanguageKey));
        return resultingRuleSetsByLanguageKey;
    }

    private static void activate(RuleSetChangedEvent.ActiveRule activatedRule, Map<String, RuleSet> ruleSetsByLanguageKey) {
        String ruleLanguageKey = activatedRule.getLanguageKey();
        RuleSet currentRuleSet = ruleSetsByLanguageKey.computeIfAbsent(ruleLanguageKey, k -> new RuleSet(Collections.emptyList(), ""));
        HashMap<String, ServerActiveRule> languageRulesByKey = new HashMap<String, ServerActiveRule>(currentRuleSet.getRulesByKey());
        String ruleTemplateKey = activatedRule.getTemplateKey();
        languageRulesByKey.put(activatedRule.getKey(), new ServerActiveRule(activatedRule.getKey(), activatedRule.getSeverity(), activatedRule.getParameters(), ruleTemplateKey == null ? "" : ruleTemplateKey));
        ruleSetsByLanguageKey.put(ruleLanguageKey, new RuleSet(new ArrayList<ServerActiveRule>(languageRulesByKey.values()), currentRuleSet.getLastModified()));
    }

    private static void deactivate(String deactivatedRuleKey, Map<String, RuleSet> ruleSetsByLanguageKey) {
        Iterator<Map.Entry<String, RuleSet>> ruleSetsIterator = ruleSetsByLanguageKey.entrySet().iterator();
        while (ruleSetsIterator.hasNext()) {
            Map.Entry<String, RuleSet> ruleSetEntry = ruleSetsIterator.next();
            RuleSet ruleSet = ruleSetEntry.getValue();
            HashMap<String, ServerActiveRule> newRules = new HashMap<String, ServerActiveRule>(ruleSet.getRulesByKey());
            newRules.remove(deactivatedRuleKey);
            if (newRules.isEmpty()) {
                ruleSetsIterator.remove();
                continue;
            }
            ruleSetsByLanguageKey.put(ruleSetEntry.getKey(), new RuleSet(List.copyOf(newRules.values()), ruleSet.getLastModified()));
        }
    }
}

