/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectDescriber;
import org.conqat.engine.persistence.index.keyed.KeyedObjectIndexBase;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ExceptionHandlingKeyValueCallbackBase;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;

public abstract class BranchedKeyedObjectIndexBase<T>
extends KeyedObjectIndexBase<T> {
    protected BranchedKeyedObjectIndexBase(IStore store, IKeyedObjectDescriber<T> describer) {
        super(store, describer);
    }

    private byte[] createObjectKey(String id) throws StorageException {
        return ByteArrayUtils.concat((byte[][])new byte[][]{OBJECT_PREFIX, this.convertIdToBytes(id)});
    }

    @Override
    public Set<String> getAllIds() throws StorageException {
        final HashSet<String> keys = new HashSet<String>();
        ExceptionHandlingKeyValueCallbackBase callback = new ExceptionHandlingKeyValueCallbackBase(){

            @Override
            protected void callbackWithException(byte[] key, byte[] value) throws StorageException {
                if (KeyedObjectIndexBase.isEmptyValue(value)) {
                    return;
                }
                key = ByteArrayUtils.removePrefix((byte[])KeyedObjectIndexBase.OBJECT_PREFIX, (byte[])key);
                keys.add(BranchedKeyedObjectIndexBase.this.convertBytesToId(key));
            }
        };
        this.store.scan(OBJECT_PREFIX, (IKeyValueCallback)callback);
        callback.throwCaughtException();
        return keys;
    }

    public void store(long timestamp, List<T> testEntries) throws StorageException {
        BranchedObjectUpdateHelper objectUpdateHelper = new BranchedObjectUpdateHelper(timestamp);
        List ids = CollectionUtils.map(testEntries, t -> this.getDescriber().getId(t));
        objectUpdateHelper.preloadOldObjects(ids);
        for (T testEntry : testEntries) {
            this.storeObject(testEntry, timestamp, objectUpdateHelper);
        }
        this.store.put((PairList<byte[], byte[]>)objectUpdateHelper.keysValues);
        this.storeMetaInformation(objectUpdateHelper.getAllKeys(), objectUpdateHelper.getAllValues());
    }

    public void removeIds(long timestamp, List<String> ids) throws StorageException {
        BranchedObjectUpdateHelper objectUpdateHelper = new BranchedObjectUpdateHelper(timestamp);
        objectUpdateHelper.preloadOldObjects(ids);
        super.removeIds(timestamp, ids, objectUpdateHelper);
    }

    @Override
    public T getById(String id) throws StorageException {
        byte[] value = this.store.get(this.createObjectKey(id));
        return this.deserialize(value);
    }

    public List<T> getByIds(List<String> ids) throws StorageException {
        List keys = CollectionUtils.mapWithException(ids, this::createObjectKey);
        List<byte[]> values = this.store.get(keys);
        return CollectionUtils.mapWithException(values, this::deserialize);
    }

    public List<T> getAllObjects() throws StorageException {
        final ArrayList results = new ArrayList();
        ExceptionHandlingKeyValueCallbackBase callback = new ExceptionHandlingKeyValueCallbackBase(){

            @Override
            protected void callbackWithException(byte[] key, byte[] value) throws StorageException {
                if (!Arrays.equals(value, KeyedObjectIndexBase.REMOVED_VALUE)) {
                    results.add(BranchedKeyedObjectIndexBase.this.deserialize(value));
                }
            }
        };
        this.store.scan(OBJECT_PREFIX, (IKeyValueCallback)callback);
        callback.throwCaughtException();
        return results;
    }

    public <R> List<R> mapAllObjects(final Function<Pair<String, T>, R> mapper) throws StorageException {
        final List results = Collections.synchronizedList(new ArrayList());
        ExceptionHandlingKeyValueCallbackBase callback = new ExceptionHandlingKeyValueCallbackBase(){

            @Override
            protected void callbackWithException(byte[] key, byte[] value) throws StorageException {
                if (KeyedObjectIndexBase.isEmptyValue(value)) {
                    return;
                }
                key = ByteArrayUtils.removePrefix((byte[])KeyedObjectIndexBase.OBJECT_PREFIX, (byte[])key);
                if (!Arrays.equals(value, KeyedObjectIndexBase.REMOVED_VALUE)) {
                    String expandedKey = BranchedKeyedObjectIndexBase.this.convertBytesToId(key);
                    Object valueObject = BranchedKeyedObjectIndexBase.this.deserialize(value);
                    results.add(mapper.apply(Pair.createPair((Object)expandedKey, valueObject)));
                }
            }
        };
        this.store.scan(OBJECT_PREFIX, (IKeyValueCallback)callback);
        callback.throwCaughtException();
        return results;
    }

    public class BranchedObjectUpdateHelper
    extends KeyedObjectIndexBase.ObjectUpdateHelper {
        private final long timestamp;

        private BranchedObjectUpdateHelper(long timestamp) {
            super(BranchedKeyedObjectIndexBase.this, BranchedKeyedObjectIndexBase.this.getDescriber());
            this.timestamp = timestamp;
        }

        @Override
        protected T getOldObject(T object, long timestamp, String id) {
            CCSMAssert.isTrue((timestamp == this.timestamp ? 1 : 0) != 0, (String)"Timestamps did not match");
            CCSMAssert.isTrue((boolean)this.oldObjectCache.containsKey(id), (String)("Element with ID " + id + " was not preloaded"));
            return this.oldObjectCache.put(id, object);
        }

        @Override
        public void storeObject(String id, long timestamp, byte[] value) throws StorageException {
            this.keysValues.add((Object)BranchedKeyedObjectIndexBase.this.createObjectKey(id), (Object)value);
        }

        private void preloadOldObjects(List<String> ids) throws StorageException {
            List keys = CollectionUtils.mapWithException(ids, BranchedKeyedObjectIndexBase.this::createObjectKey);
            List<byte[]> values = BranchedKeyedObjectIndexBase.this.store.get(keys);
            List list = CollectionUtils.mapWithException(values, BranchedKeyedObjectIndexBase.this::deserialize);
            CollectionUtils.forEach(ids, (Iterable)list, this.oldObjectCache::put);
        }
    }
}

