/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiConsumer;

public class TimedShallowObjectState {
    private final String id;
    private final SortedMap<Long, String>[] valuesOverTime;
    private final String[] frozenValues;

    public TimedShallowObjectState(String id, int size) {
        this.id = id;
        this.valuesOverTime = new SortedMap[size];
        this.frozenValues = new String[size];
    }

    public String getId() {
        return this.id;
    }

    public void insert(int index, long timestamp, String value) {
        if (this.valuesOverTime[index] == null) {
            this.valuesOverTime[index] = new TreeMap<Long, String>();
        }
        this.valuesOverTime[index].put(timestamp, value);
    }

    public void insertValues(int index, Map<Long, String> values) {
        if (values == null) {
            return;
        }
        if (this.valuesOverTime[index] == null) {
            this.valuesOverTime[index] = new TreeMap<Long, String>();
        }
        this.valuesOverTime[index].putAll(values);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.id);
        for (int i = 0; i < this.valuesOverTime.length; ++i) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append(" " + i + "(");
            builder.append(this.valuesOverTime[i]);
            builder.append(")");
        }
        return builder.toString();
    }

    public String getLatestValue(int index) {
        SortedMap<Long, String> values = this.valuesOverTime[index];
        if (values.isEmpty()) {
            return null;
        }
        return (String)values.get(values.lastKey());
    }

    public void freezeAt(long timestamp) {
        for (int i = 0; i < this.valuesOverTime.length; ++i) {
            this.freezeAt(timestamp, i);
        }
    }

    private void freezeAt(long timestamp, int index) {
        if (this.valuesOverTime[index] == null) {
            this.frozenValues[index] = null;
            return;
        }
        SortedMap<Long, String> headMap = this.valuesOverTime[index].headMap(timestamp + 1L);
        this.frozenValues[index] = headMap.isEmpty() ? null : (String)headMap.get(headMap.lastKey());
    }

    public SortedMap<Long, String>[] getValuesOverTime() {
        return this.valuesOverTime;
    }

    public String getFrozenValue(int index) {
        return this.frozenValues[index];
    }

    public Set<Long> getTimestamps() {
        HashSet<Long> result = new HashSet<Long>();
        for (SortedMap<Long, String> map : this.valuesOverTime) {
            if (map == null) continue;
            result.addAll(map.keySet());
        }
        return result;
    }

    public boolean hasNonNullFrozenValue() {
        for (int i = 0; i < this.frozenValues.length; ++i) {
            if (this.frozenValues[i] == null) continue;
            return true;
        }
        return false;
    }

    public void iterateValues(int columnIndex, BiConsumer<Long, String> callback) {
        SortedMap<Long, String> column = this.valuesOverTime[columnIndex];
        for (Long timestamp : column.keySet()) {
            String valueAtTimestamp = (String)column.get(timestamp);
            if (valueAtTimestamp == null) continue;
            callback.accept(timestamp, valueAtTimestamp);
        }
    }

    public int columnCount() {
        return this.valuesOverTime.length;
    }
}

