/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.schema;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.conqat.engine.persistence.index.IStorageIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class SchemaEntry
implements Serializable {
    private static final boolean DISABLE_BRANCHING_STORES = Boolean.getBoolean("com.teamscale.disable-branching-store");
    private static final long serialVersionUID = 1L;
    private final String indexClass;
    private final Set<EStorageOption> storageOptions = EnumSet.noneOf(EStorageOption.class);

    private SchemaEntry(String indexClass, Collection<EStorageOption> storageOptions) {
        HashSet nonAllowedStorageOptions;
        this.indexClass = indexClass;
        this.storageOptions.addAll(storageOptions);
        if (this.storageOptions.contains((Object)EStorageOption.HISTORIZED) && this.storageOptions.contains((Object)EStorageOption.BRANCHED)) {
            throw new IllegalArgumentException("Can not create a store that is both historized and branched!");
        }
        if (this.storageOptions.contains((Object)EStorageOption.VIRTUAL) && !(nonAllowedStorageOptions = CollectionUtils.differenceSet(storageOptions, (Collection[])new Collection[]{EnumSet.of(EStorageOption.ABBREVIATE_STRINGS, EStorageOption.COMPRESSED, EStorageOption.VIRTUAL)})).isEmpty()) {
            throw new IllegalArgumentException("Can not create a store that is virtual and contains the following additional options: " + String.valueOf(nonAllowedStorageOptions));
        }
        if (DISABLE_BRANCHING_STORES && this.storageOptions.contains((Object)EStorageOption.BRANCHED)) {
            this.storageOptions.remove((Object)EStorageOption.BRANCHED);
            this.storageOptions.add(EStorageOption.HISTORIZED);
        }
    }

    public SchemaEntry(Class<? extends IStorageIndex> indexClass) {
        this(indexClass, IStorageIndex.getIndexAnnotation(indexClass));
    }

    public SchemaEntry(Class<? extends IStorageIndex> indexClass, Index indexAnnotation) {
        this(indexClass.getName(), Arrays.asList(indexAnnotation.options()));
    }

    public SchemaEntry(Class<? extends IStorageIndex> indexClass, EStorageOption[] storageOptions) {
        this(indexClass.getName(), Arrays.asList(storageOptions));
    }

    public String getIndexClass() {
        return this.indexClass;
    }

    public Class<? extends IStorageIndex> createIndexClass() throws AssertionError {
        try {
            return Class.forName(this.indexClass, true, Thread.currentThread().getContextClassLoader()).asSubclass(IStorageIndex.class);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError("Index class not found: " + this.indexClass, e);
        }
        catch (ClassCastException e) {
            throw new AssertionError("Index class %s does not extend %s".formatted(this.indexClass, IStorageIndex.class), e);
        }
    }

    public UnmodifiableSet<EStorageOption> getStorageOptions() {
        return CollectionUtils.asUnmodifiable(this.storageOptions);
    }

    public boolean usesOption(EStorageOption option) {
        return this.storageOptions.contains((Object)option);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.indexClass == null ? 0 : this.indexClass.hashCode());
        result = 31 * result + this.storageOptions.hashCode();
        return result;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SchemaEntry)) {
            return false;
        }
        SchemaEntry otherEntry = (SchemaEntry)other;
        return this.indexClass.equals(otherEntry.indexClass) && this.storageOptions.equals(otherEntry.storageOptions);
    }

    public String toString() {
        return this.indexClass + " (" + String.valueOf(this.storageOptions) + ")";
    }

    public boolean isHistorized() {
        return this.usesOption(EStorageOption.HISTORIZED) || this.usesOption(EStorageOption.BRANCHED);
    }
}

