/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.cache;

import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.SonarProduct;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.utils.Version;
import org.sonar.php.cache.PhpReadCacheImpl;
import org.sonar.php.cache.PhpWriteCacheImpl;
import org.sonar.php.symbols.ProjectSymbolData;
import org.sonar.plugins.php.api.cache.CacheContext;
import org.sonar.plugins.php.api.cache.PhpReadCache;
import org.sonar.plugins.php.api.cache.PhpWriteCache;

public class CacheContextImpl
implements CacheContext {
    private static final Logger LOG = LoggerFactory.getLogger(CacheContextImpl.class);
    public static final Version MINIMUM_RUNTIME_VERSION = Version.create(9, 7);
    private final boolean isCacheEnabled;
    private final PhpWriteCache writeCache;
    private final PhpReadCache readCache;
    private final String pluginVersion;

    public CacheContextImpl(boolean isCacheEnabled, @Nullable PhpWriteCache writeCache, @Nullable PhpReadCache readCache, String pluginVersion) {
        this.isCacheEnabled = isCacheEnabled;
        this.writeCache = writeCache;
        this.readCache = readCache;
        this.pluginVersion = pluginVersion;
    }

    public static CacheContextImpl of(SensorContext context) {
        String pluginVersion = CacheContextImpl.getImplementationVersion(ProjectSymbolData.class);
        String sonarModules = context.config().get("sonar.modules").orElse("");
        if (StringUtils.isNotBlank(sonarModules) && context.isCacheEnabled()) {
            LOG.warn("The sonar.modules is a deprecated property and should not be used anymore, it inhibits an optimized analysis");
        }
        if (!context.runtime().getProduct().equals((Object)SonarProduct.SONARLINT) && context.runtime().getApiVersion().isGreaterThanOrEqual(MINIMUM_RUNTIME_VERSION) && StringUtils.isBlank(sonarModules)) {
            return new CacheContextImpl(context.isCacheEnabled(), new PhpWriteCacheImpl(context.nextCache()), new PhpReadCacheImpl(context.previousCache()), pluginVersion);
        }
        return new CacheContextImpl(false, null, null, pluginVersion);
    }

    @Override
    public boolean isCacheEnabled() {
        return this.isCacheEnabled;
    }

    @Override
    public PhpReadCache getReadCache() {
        return this.readCache;
    }

    @Override
    public PhpWriteCache getWriteCache() {
        return this.writeCache;
    }

    @Override
    public String pluginVersion() {
        return this.pluginVersion;
    }

    public static String getImplementationVersion(Class<?> cls) {
        String implementationVersion = cls.getPackage().getImplementationVersion();
        return implementationVersion != null ? implementationVersion : "unknown";
    }
}

