/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.formatting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.php.api.PHPPunctuator;
import org.sonar.php.checks.FormattingStandardCheck;
import org.sonar.php.checks.formatting.FormattingCheck;
import org.sonar.php.checks.formatting.TokenUtils;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.utils.collections.ListUtils;
import org.sonar.plugins.php.api.tree.ScriptTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

public class IndentationCheck
extends PHPVisitorCheck
implements FormattingCheck {
    private static final String ARGUMENT_LINE_SPLIT_MESSAGE = "Either split this list into multiple lines, aligned at column \"%s\" or put all arguments on line \"%s\".";
    private static final String ARGUMENT_INDENTATION_MESSAGE = "Align all arguments in this list at column \"%s\".";
    private static final int PSR2_INDENTATION = 4;
    private static final String FUNCTION_CALL_PARENTHESIS_MESSAGE = "Move the closing parenthesis on the next line.";
    private static final String FUNCTION_DEC_PARENTHESIS_MESSAGE = "Move the closing parenthesis with the opening brace on the next line.";
    private static final String INTERFACE_SPLIT_MESSAGE = "Either split this list into multiple lines or move it on the same line \"%s\".";
    private static final String INTERFACE_INDENTATION = "Align all interfaces in this list at column \"%s\".";
    private FormattingStandardCheck check;
    private Map<Integer, Integer> startColumnByLine = new HashMap<Integer, Integer>();

    @Override
    public void checkFormat(FormattingStandardCheck formattingCheck, ScriptTree scriptTree) {
        this.check = formattingCheck;
        this.startColumnByLine.clear();
        super.visitScript(scriptTree);
    }

    @Override
    public void visitToken(SyntaxToken token) {
        if (this.startColumnByLine.get(token.line()) == null) {
            this.startColumnByLine.put(token.line(), token.column());
        }
        super.visitToken(token);
    }

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        super.visitFunctionCall(tree);
        if (this.check.isFunctionCallsArgumentsIndentation && !this.check.isInternalFunction(tree.callee())) {
            SyntaxToken calleeLastToken = ((PHPTree)((Object)tree.callee())).getLastToken();
            this.checkArgumentsIndentation(tree.callArguments().stream().map(CallArgumentTree::value).toList(), calleeLastToken, this.startColumnForLine(calleeLastToken.line()), tree.closeParenthesisToken(), true);
        }
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        super.visitFunctionDeclaration(tree);
        if (this.check.isMethodArgumentsIndentation) {
            this.checkArgumentsIndentation(tree.parameters().parameters(), tree.name().token(), this.startColumnForLine(tree.functionToken().line()), tree.parameters().closeParenthesisToken(), false);
        }
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        super.visitMethodDeclaration(tree);
        if (this.check.isMethodArgumentsIndentation) {
            this.checkArgumentsIndentation(tree.parameters().parameters(), tree.name().token(), this.startColumnForLine(tree.functionToken().line()), tree.parameters().closeParenthesisToken(), false);
        }
    }

    @Override
    public void visitFunctionExpression(FunctionExpressionTree tree) {
        super.visitFunctionExpression(tree);
        if (this.check.isMethodArgumentsIndentation) {
            this.checkArgumentsIndentation(tree.parameters().parameters(), tree.functionToken(), this.startColumnForLine(tree.functionToken().line()), tree.parameters().closeParenthesisToken(), false);
        }
    }

    @Override
    public void visitClassDeclaration(ClassDeclarationTree tree) {
        super.visitClassDeclaration(tree);
        this.checkImplementListIndentation(tree);
    }

    private void checkImplementListIndentation(ClassDeclarationTree classTree) {
        if (this.check.isInterfacesIndentation && classTree.is(Tree.Kind.CLASS_DECLARATION) && !classTree.superInterfaces().isEmpty()) {
            ArrayList<NamespaceNameTree> interfaceList = new ArrayList<NamespaceNameTree>(classTree.superInterfaces());
            SyntaxToken classToken = classTree.classToken();
            SyntaxToken lastInterfaceToken = ((PHPTree)((Object)ListUtils.getLast(classTree.superInterfaces()))).getFirstToken();
            int expectedColumn = classToken.column() + 4;
            if (!TokenUtils.isOnSameLine(classToken, lastInterfaceToken)) {
                if (IndentationCheck.areIncorrectlySplitOnLines(classToken.line(), interfaceList)) {
                    this.check.reportIssue(String.format(INTERFACE_SPLIT_MESSAGE, classToken.line()), (Tree)classTree.superInterfaces().get(0));
                } else if (IndentationCheck.areIncorrectlyIndented(expectedColumn, interfaceList)) {
                    this.check.reportIssue(String.format(INTERFACE_INDENTATION, expectedColumn), (Tree)classTree.superInterfaces().get(0));
                }
            }
        }
    }

    private void checkArgumentsIndentation(List<? extends Tree> arguments, SyntaxToken functionName, int baseColumn, @Nullable SyntaxToken closeParenthesis, boolean isFunctionCall) {
        if (arguments.size() > 1 && !IndentationCheck.allArgumentsOnSameLine(functionName, arguments)) {
            int expectedIndentationColumn = baseColumn + 4;
            int callingLine = functionName.line();
            Tree firstArg = arguments.get(0);
            if (IndentationCheck.areIncorrectlySplitOnLines(callingLine, arguments)) {
                this.check.reportIssue(String.format(ARGUMENT_LINE_SPLIT_MESSAGE, expectedIndentationColumn, callingLine), firstArg);
            } else if (IndentationCheck.areIncorrectlyIndented(expectedIndentationColumn, arguments)) {
                this.check.reportIssue(String.format(ARGUMENT_INDENTATION_MESSAGE, expectedIndentationColumn), firstArg);
            }
            if (closeParenthesis != null) {
                this.checkClosingParenthesisLocation(ListUtils.getLast(arguments), closeParenthesis, isFunctionCall);
            }
        }
    }

    private static boolean allArgumentsOnSameLine(SyntaxToken functionName, List<? extends Tree> arguments) {
        int expectedLine = IndentationCheck.getLastLine(functionName);
        for (Tree tree : arguments) {
            if (IndentationCheck.getStartLine(tree) != expectedLine) {
                return false;
            }
            if (!tree.is(Tree.Kind.ARRAY_INITIALIZER_BRACKET, Tree.Kind.ARRAY_INITIALIZER_FUNCTION, Tree.Kind.FUNCTION_EXPRESSION)) continue;
            expectedLine = IndentationCheck.getLastLine(tree);
        }
        return IndentationCheck.getLastLine(arguments.get(arguments.size() - 1)) == expectedLine;
    }

    private void checkClosingParenthesisLocation(Tree lastArgument, SyntaxToken closeParenthesis, boolean isFunctionCall) {
        if (!((PHPTree)lastArgument).getLastToken().text().equals(PHPPunctuator.RPARENTHESIS.getValue()) && TokenUtils.isOnSameLine(((PHPTree)lastArgument).getLastToken(), closeParenthesis)) {
            this.check.reportIssue(isFunctionCall ? FUNCTION_CALL_PARENTHESIS_MESSAGE : FUNCTION_DEC_PARENTHESIS_MESSAGE, closeParenthesis);
        }
    }

    private static boolean areIncorrectlyIndented(int expectedColumn, List<? extends Tree> items) {
        for (Tree tree : items) {
            if (!IndentationCheck.isIncorrectlyIndented(expectedColumn, (PHPTree)tree)) continue;
            return true;
        }
        return false;
    }

    private static boolean isIncorrectlyIndented(int expectedColumn, PHPTree item) {
        PHPTree parent = (PHPTree)item.getParent();
        if (IndentationCheck.isNamedArgument(parent)) {
            SyntaxToken firstToken = parent.getFirstToken();
            return firstToken.column() != expectedColumn;
        }
        return item.getFirstToken().column() != expectedColumn;
    }

    private static boolean isNamedArgument(PHPTree tree) {
        return tree.is(Tree.Kind.CALL_ARGUMENT) && ((CallArgumentTree)((Object)tree)).name() != null;
    }

    private static boolean areIncorrectlySplitOnLines(int referenceLine, List<? extends Tree> items) {
        int expectedLine = referenceLine + 1;
        for (Tree tree : items) {
            if (IndentationCheck.getStartLine(tree) < expectedLine) {
                return true;
            }
            if (tree.is(Tree.Kind.ARRAY_INITIALIZER_BRACKET, Tree.Kind.FUNCTION_EXPRESSION)) {
                expectedLine = IndentationCheck.getLastLine(tree) + 1;
                continue;
            }
            ++expectedLine;
        }
        return false;
    }

    private static int getStartLine(Tree tree) {
        return ((PHPTree)tree).getLine();
    }

    private static int getLastLine(Tree tree) {
        return ((PHPTree)tree).getLastToken().line();
    }

    private int startColumnForLine(int line) {
        return this.startColumnByLine.get(line);
    }
}

