/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.phpunit;

import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.PhpUnitCheck;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.MemberAccessTree;
import org.sonar.plugins.php.api.tree.statement.TryStatementTree;
import org.sonar.plugins.php.api.visitors.PreciseIssue;

@Rule(key="S5783")
public class OneExpectedCheckExceptionCheck
extends PhpUnitCheck {
    private static final String MESSAGE = "Refactor the body of this try/catch to have only one invocation throwing an exception.";
    private final Set<FunctionCallTree> functionCallCount = new HashSet<FunctionCallTree>();
    private final TryBlockVisitor tryBlockVisitor = new TryBlockVisitor();

    @Override
    public void visitTryStatement(TryStatementTree tree) {
        if (!this.isPhpUnitTestMethod()) {
            return;
        }
        tree.block().accept(this.tryBlockVisitor);
        this.checkFunctionCallCount(tree);
        super.visitTryStatement(tree);
    }

    private void checkFunctionCallCount(TryStatementTree tree) {
        if (this.functionCallCount.size() > 1) {
            PreciseIssue issue = this.newIssue(tree.tryToken(), MESSAGE);
            this.functionCallCount.forEach(call -> OneExpectedCheckExceptionCheck.addSecondaryLocations(call.callee(), issue));
        }
        this.functionCallCount.clear();
    }

    private static void addSecondaryLocations(ExpressionTree callee, PreciseIssue issue) {
        Tree tree = callee;
        if (callee.is(Tree.Kind.OBJECT_MEMBER_ACCESS) || callee.is(Tree.Kind.CLASS_MEMBER_ACCESS)) {
            tree = ((MemberAccessTree)callee).member();
        }
        issue.secondary(tree, null);
    }

    private class TryBlockVisitor
    extends PhpUnitCheck {
        private TryBlockVisitor() {
        }

        @Override
        public void visitFunctionCall(FunctionCallTree tree) {
            if (!TryBlockVisitor.isFail(tree)) {
                if (!TryBlockVisitor.isAssertion(tree)) {
                    OneExpectedCheckExceptionCheck.this.functionCallCount.add(tree);
                }
                super.visitFunctionCall(tree);
            }
        }
    }
}

