/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php;

import java.security.MessageDigest;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.DurationStatistics;
import org.sonar.api.SonarProduct;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.php.cache.Cache;
import org.sonar.plugins.php.CancellationException;
import org.sonar.plugins.php.FileHashingUtils;
import org.sonarsource.analyzer.commons.ProgressReport;

abstract class Scanner {
    private static final Logger LOG = LoggerFactory.getLogger(Scanner.class);
    public static final String SONAR_CAN_SKIP_UNCHANGED_FILES_KEY = "sonar.php.skipUnchanged";
    private static final String FAIL_FAST_PROPERTY_NAME = "sonar.internal.analysis.failFast";
    protected final SensorContext context;
    protected final DurationStatistics statistics;
    protected final Cache cache;
    protected boolean optimizedAnalysis;

    Scanner(SensorContext context, DurationStatistics statistics, Cache cache) {
        this.context = context;
        this.statistics = statistics;
        this.cache = cache;
        this.optimizedAnalysis = this.shouldOptimizeAnalysis();
    }

    void execute(List<InputFile> files) {
        ProgressReport progressReport = new ProgressReport("PHP analyzer progress", TimeUnit.SECONDS.toMillis(10L));
        this.execute(progressReport, files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(ProgressReport progressReport, List<InputFile> files) {
        String name = this.name();
        LOG.info("Starting {}", (Object)name);
        List<String> filenames = files.stream().map(InputFile::toString).toList();
        progressReport.start(filenames);
        boolean success = false;
        try {
            for (InputFile file : files) {
                if (this.context.isCancelled()) {
                    throw new CancellationException();
                }
                this.processFile(file);
                progressReport.nextFile();
            }
            this.onEnd();
            success = true;
        }
        finally {
            Scanner.stopProgressReport(progressReport, success);
        }
    }

    protected static boolean inSonarLint(SensorContext context) {
        return context.runtime().getProduct() == SonarProduct.SONARLINT;
    }

    private boolean shouldOptimizeAnalysis() {
        return !Scanner.inSonarLint(this.context) && (this.context.canSkipUnchangedFiles() || this.context.config().getBoolean(SONAR_CAN_SKIP_UNCHANGED_FILES_KEY).orElse(false) != false);
    }

    protected boolean fileCanBeSkipped(InputFile file) {
        return this.optimizedAnalysis && this.fileIsUnchanged(file);
    }

    private boolean fileIsUnchanged(InputFile inputFile) {
        if (inputFile.status() != null && !inputFile.status().equals((Object)InputFile.Status.SAME)) {
            return false;
        }
        byte[] fileHash = this.cache.readFileContentHash(inputFile);
        try {
            byte[] bytes = FileHashingUtils.inputFileContentHash(inputFile);
            return MessageDigest.isEqual(fileHash, bytes);
        }
        catch (IllegalStateException ise) {
            LOG.debug("Failed to compute content hash for file {}", (Object)inputFile.key());
            return false;
        }
    }

    private void processFile(InputFile file) {
        block2: {
            try {
                this.scanFile(file);
            }
            catch (Exception e) {
                this.logException(e, file);
                if (!this.context.config().getBoolean(FAIL_FAST_PROPERTY_NAME).orElse(false).booleanValue()) break block2;
                throw new IllegalStateException("Exception when analyzing " + file, e);
            }
        }
    }

    private static void stopProgressReport(ProgressReport progressReport, boolean success) {
        if (success) {
            progressReport.stop();
        } else {
            progressReport.cancel();
        }
    }

    abstract String name();

    abstract void scanFile(InputFile var1);

    abstract void logException(Exception var1, InputFile var2);

    void onEnd() {
    }
}

