/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.test.SimulinkTestExclude;
import org.conqat.lib.simulink.model.ParameterizedElement;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.datahandler.LabelLayoutData;
import org.conqat.lib.simulink.model.datahandler.LineLayoutData;
import org.conqat.lib.simulink.model.datahandler.simulink.SimulinkLayoutHandler;

public class SimulinkLine
extends ParameterizedElement {
    private @Nullable SimulinkOutPort sourcePort;
    private @Nullable SimulinkInPort destPort;
    private SimulinkBlock container;

    public SimulinkLine(SimulinkOutPort sourcePort, SimulinkInPort destPort, SimulinkBlock container) {
        CCSMAssert.isNotNull((Object)container, (String)"Container must not be null!");
        this.sourcePort = sourcePort;
        this.destPort = destPort;
        this.container = container;
        if (sourcePort != null) {
            sourcePort.addLine(this);
        }
        if (destPort != null) {
            destPort.setLine(this);
        }
        container.addLine(this);
    }

    public @Nullable SimulinkInPort getDstPort() {
        return this.destPort;
    }

    public SimulinkBlock getContainer() {
        return this.container;
    }

    public SimulinkModel getModel() {
        return this.container.getModel();
    }

    public @Nullable SimulinkOutPort getSrcPort() {
        return this.sourcePort;
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.getParameter("Name"));
    }

    public void remove() {
        CCSMAssert.isNotNull((Object)this.container, (String)"May not remove lines twice!");
        if (this.sourcePort != null) {
            this.sourcePort.removeLine(this);
            this.sourcePort = null;
        }
        if (this.destPort != null) {
            this.destPort.removeLine(this);
            this.destPort = null;
        }
        this.container.removeLine(this);
        this.container = null;
    }

    public String toString() {
        return this.toLineString();
    }

    public String toLineString() {
        return String.valueOf(this.sourcePort) + " -> " + String.valueOf(this.destPort);
    }

    @Override
    String getDefaultParameter(String name) {
        return this.getModel().getLineDefaultParameter(name);
    }

    @Override
    Set<String> getDefaultParameterNames() {
        return this.getModel().getLineDefaultParameterNames();
    }

    @SimulinkTestExclude
    public LineLayoutData obtainLayoutData() {
        return SimulinkLayoutHandler.obtainLineLayoutData(this);
    }

    @SimulinkTestExclude
    public LabelLayoutData obtainLabelData() {
        return SimulinkLayoutHandler.obtainLineLabelData(this);
    }

    @SimulinkTestExclude
    public List<LabelLayoutData> obtainAllLabelData() {
        return SimulinkLayoutHandler.obtainAllLineLabelData(this);
    }

    public boolean hasUnconnectedEndpoint() {
        return this.getSrcPort() == null || this.getDstPort() == null;
    }
}

