/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.InvalidSettingException;
import jetbrains.exodus.core.dataStructures.LongArrayList;
import jetbrains.exodus.core.dataStructures.hash.LongIterator;
import jetbrains.exodus.crypto.EnvKryptKt;
import jetbrains.exodus.crypto.StreamCipherProvider;
import jetbrains.exodus.io.Block;
import jetbrains.exodus.io.DataReader;
import jetbrains.exodus.io.DataReaderWriterProvider;
import jetbrains.exodus.io.DataWriter;
import jetbrains.exodus.io.FileDataReader;
import jetbrains.exodus.io.RemoveBlockType;
import jetbrains.exodus.kotlin.KodusKt;
import jetbrains.exodus.log.BlockListener;
import jetbrains.exodus.log.BlockNotFoundException;
import jetbrains.exodus.log.BlockSet;
import jetbrains.exodus.log.BufferedDataWriter;
import jetbrains.exodus.log.ByteIteratorWithAddress;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.log.DataIterator;
import jetbrains.exodus.log.LogCache;
import jetbrains.exodus.log.LogConfig;
import jetbrains.exodus.log.LogTestConfig;
import jetbrains.exodus.log.LogTip;
import jetbrains.exodus.log.LogUtil;
import jetbrains.exodus.log.LogWarmupKt;
import jetbrains.exodus.log.Loggable;
import jetbrains.exodus.log.LoggableIterator;
import jetbrains.exodus.log.NullLoggable;
import jetbrains.exodus.log.RandomAccessByteIterable;
import jetbrains.exodus.log.RandomAccessLoggable;
import jetbrains.exodus.log.RandomAccessLoggableAndArrayByteIterable;
import jetbrains.exodus.log.RandomAccessLoggableImpl;
import jetbrains.exodus.log.ReadBytesListener;
import jetbrains.exodus.log.SeparateLogCache;
import jetbrains.exodus.log.SharedLogCache;
import jetbrains.exodus.log.TooBigLoggableException;
import jetbrains.exodus.util.DeferredIO;
import jetbrains.exodus.util.IdGenerator;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00ea\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00ac\u00012\u00020\u0001:\u0002\u00ac\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010H\u001a\u00020IJ\u000e\u0010J\u001a\u00020I2\u0006\u0010K\u001a\u00020\u000bJ\u000e\u0010L\u001a\u00020I2\u0006\u0010K\u001a\u00020:J\u0010\u0010M\u001a\u00020\u001c2\u0006\u0010D\u001a\u00020\u000eH\u0002J\u0006\u0010N\u001a\u00020,J\u0010\u0010O\u001a\u00020I2\u0006\u0010P\u001a\u00020QH\u0002J\u0006\u0010R\u001a\u00020,J\u0018\u0010S\u001a\u00020I2\u0006\u0010T\u001a\u00020\u001c2\b\b\u0002\u0010U\u001a\u00020\u001cJ\b\u0010V\u001a\u00020IH\u0016J\u0010\u0010W\u001a\u00020I2\u0006\u0010D\u001a\u00020\u000eH\u0002J\b\u0010X\u001a\u00020IH\u0002J\u0016\u0010Y\u001a\u00020,2\u0006\u0010Z\u001a\u00020,2\u0006\u0010[\u001a\u00020,J\u0006\u0010\\\u001a\u00020IJ\u0006\u0010]\u001a\u00020,J\u0006\u0010^\u001a\u00020\u000eJ\u0012\u0010_\u001a\u00020I2\b\b\u0002\u0010`\u001a\u00020-H\u0007J\u0010\u0010a\u001a\u00020I2\u0006\u0010T\u001a\u00020\u001cH\u0007J\u000e\u0010b\u001a\u00020I2\u0006\u0010c\u001a\u00020\u0006J\u000e\u0010d\u001a\u00020e2\u0006\u0010f\u001a\u00020\u001cJ\u000e\u0010g\u001a\u00020\u001c2\u0006\u0010T\u001a\u00020\u001cJ\u001a\u0010h\u001a\u00020\u001c2\u0006\u0010i\u001a\u00020\u001c2\b\b\u0002\u0010Z\u001a\u00020,H\u0007J\u0010\u0010j\u001a\u0004\u0018\u00010k2\u0006\u0010l\u001a\u00020\u0016J\u0010\u0010m\u001a\u0004\u0018\u00010e2\u0006\u0010n\u001a\u00020\u001cJ\u000e\u0010o\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u001cJ\u0018\u0010p\u001a\u00020\u001c2\u0006\u0010i\u001a\u00020\u001c2\u0006\u0010Z\u001a\u00020,H\u0002J\u0010\u0010q\u001a\u0004\u0018\u00010k2\u0006\u0010l\u001a\u00020\u0016J \u0010r\u001a\u0004\u0018\u00010k2\u0006\u0010l\u001a\u00020\u00162\u0006\u0010s\u001a\u00020\u001c2\u0006\u0010Z\u001a\u00020,J\u000e\u0010t\u001a\u00020u2\u0006\u0010v\u001a\u00020\u001cJ\u000e\u0010w\u001a\u00020\u001c2\u0006\u0010i\u001a\u00020\u001cJ\u0016\u0010x\u001a\u00020y2\u0006\u0010T\u001a\u00020\u001c2\u0006\u0010z\u001a\u00020yJ\u000e\u0010{\u001a\u00020-2\u0006\u0010T\u001a\u00020\u001cJ\u0016\u0010|\u001a\u00020-2\u0006\u0010}\u001a\u00020\u001c2\u0006\u0010~\u001a\u00020\u001cJ\u000e\u0010\u007f\u001a\u00020-2\u0006\u0010i\u001a\u00020\u001cJ\u0017\u0010\u0080\u0001\u001a\u00020-2\u0006\u0010T\u001a\u00020\u001c2\u0006\u0010Z\u001a\u00020,J\u000f\u0010\u0081\u0001\u001a\u00020-2\u0006\u0010T\u001a\u00020\u001cJ\u0011\u0010\u0082\u0001\u001a\u00020I2\u0006\u0010T\u001a\u00020\u001cH\u0002J\u0011\u0010\u0083\u0001\u001a\u00020I2\u0006\u0010T\u001a\u00020\u001cH\u0002J\u001b\u0010\u0084\u0001\u001a\u00020I2\u0007\u0010\u0085\u0001\u001a\u00020e2\u0007\u0010\u0086\u0001\u001a\u00020\u0016H\u0002J\u0007\u0010\u0087\u0001\u001a\u00020IJ\u001e\u0010\u0088\u0001\u001a\u00030\u0089\u00012\b\u0010\u008a\u0001\u001a\u00030\u008b\u00012\b\b\u0002\u0010T\u001a\u00020\u001cH\u0007J$\u0010\u0088\u0001\u001a\u00030\u0089\u00012\u0006\u0010l\u001a\u00020y2\b\u0010\u008a\u0001\u001a\u00030\u008b\u00012\u0006\u0010T\u001a\u00020\u001cH\u0002J\u0010\u0010\u0088\u0001\u001a\u00030\u0089\u00012\u0006\u0010T\u001a\u00020\u001cJ\u0018\u0010\u008c\u0001\u001a\u00020\u00162\u0007\u0010\u008d\u0001\u001a\u00020e2\u0006\u0010T\u001a\u00020\u001cJ\u0010\u0010\u008e\u0001\u001a\u00030\u008f\u00012\u0006\u0010T\u001a\u00020\u001cJ\u001a\u0010\u0090\u0001\u001a\u00030\u0089\u00012\b\u0010\u008a\u0001\u001a\u00030\u008b\u00012\u0006\u0010T\u001a\u00020\u001cJ\u0007\u0010\u0091\u0001\u001a\u00020IJ)\u0010\u0092\u0001\u001a\u00020I2\u0006\u0010T\u001a\u00020\u001c2\n\b\u0002\u0010\u0093\u0001\u001a\u00030\u0094\u00012\n\b\u0002\u0010P\u001a\u0004\u0018\u00010QH\u0007J\u000f\u0010\u0095\u0001\u001a\u00020I2\u0006\u0010Z\u001a\u00020,J\u0017\u0010\u0096\u0001\u001a\u00020,2\u0006\u0010Z\u001a\u00020,2\u0006\u0010#\u001a\u00020\u001cJ \u0010\u0096\u0001\u001a\u00020,2\u0006\u0010Z\u001a\u00020,2\u0006\u0010#\u001a\u00020\u001c2\u0007\u0010\u0097\u0001\u001a\u00020QJ\u0013\u0010\u0098\u0001\u001a\u00020I2\b\u0010=\u001a\u0004\u0018\u00010>H\u0007J\u0007\u0010\u0099\u0001\u001a\u00020IJ\u001a\u0010\u009a\u0001\u001a\u00020I2\u0006\u0010T\u001a\u00020\u001c2\u0007\u0010\u009b\u0001\u001a\u00020\u001cH\u0002J\t\u0010\u009c\u0001\u001a\u00020IH\u0002J\"\u0010\u009d\u0001\u001a\u00020\u001c2\u0006\u0010l\u001a\u00020y2\u0007\u0010\u009e\u0001\u001a\u00020\u00162\b\u0010\u009f\u0001\u001a\u00030\u00a0\u0001J\t\u0010\u00a1\u0001\u001a\u00020IH\u0002J\u0010\u0010\u00a2\u0001\u001a\u00020\u001c2\u0007\u0010\u00a3\u0001\u001a\u00020kJ\"\u0010\u00a2\u0001\u001a\u00020\u001c2\u0006\u0010l\u001a\u00020y2\u0007\u0010\u009e\u0001\u001a\u00020\u00162\b\u0010\u009f\u0001\u001a\u00030\u00a0\u0001J\u0010\u0010\u00a4\u0001\u001a\u00020\u001c2\u0007\u0010\u00a3\u0001\u001a\u00020kJ\"\u0010\u00a4\u0001\u001a\u00020\u001c2\u0006\u0010l\u001a\u00020y2\u0007\u0010\u009e\u0001\u001a\u00020\u00162\b\u0010\u009f\u0001\u001a\u00030\u00a0\u0001J\u0019\u0010\u00a4\u0001\u001a\u00020\u001c2\u0007\u0010\u009f\u0001\u001a\u00020e2\u0007\u0010\u0086\u0001\u001a\u00020\u0016JD\u0010\u00a5\u0001\u001a\n\u0012\u0005\u0012\u0003H\u00a7\u00010\u00a6\u0001\"\u0007\b\u0000\u0010\u00a7\u0001\u0018\u0001*\n\u0012\u0005\u0012\u0003H\u00a7\u00010\u00a8\u00012\u0015\u0010\u00a9\u0001\u001a\u0010\u0012\u0005\u0012\u0003H\u00a7\u0001\u0012\u0004\u0012\u00020I0\u00aa\u0001H\u0082\b\u00a2\u0006\u0003\u0010\u00ab\u0001R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00108\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001eR\u0011\u0010!\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001eR\u0011\u0010#\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001eR\u0011\u0010%\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001eR\u001e\u0010(\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0018R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010.\u001a\u00020-2\u0006\u0010'\u001a\u00020-@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u000e\u00100\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u00101\u001a\u0002028F\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0011\u00105\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u001eR\u0011\u00107\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u001eR\u001e\u00109\u001a\u0012\u0012\u0004\u0012\u00020:0\nj\b\u0012\u0004\u0012\u00020:`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010=\u001a\u0004\u0018\u00010>8\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b?\u0010@R\u0011\u0010A\u001a\u00020,8F\u00a2\u0006\u0006\u001a\u0004\bB\u0010CR\u000e\u0010D\u001a\u00020EX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010F\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\bG\u0010\u001e\u00a8\u0006\u00ad\u0001"}, d2={"Ljetbrains/exodus/log/Log;", "Ljava/io/Closeable;", "config", "Ljetbrains/exodus/log/LogConfig;", "(Ljetbrains/exodus/log/LogConfig;)V", "allFileAddresses", "", "getAllFileAddresses", "()[J", "blockListeners", "Ljava/util/ArrayList;", "Ljetbrains/exodus/log/BlockListener;", "Lkotlin/collections/ArrayList;", "bufferedWriter", "Ljetbrains/exodus/log/BufferedDataWriter;", "cache", "Ljetbrains/exodus/log/LogCache;", "cacheHitRate", "", "getCacheHitRate", "()F", "cachePageSize", "", "getCachePageSize", "()I", "getConfig", "()Ljetbrains/exodus/log/LogConfig;", "created", "", "getCreated", "()J", "diskUsage", "getDiskUsage", "fileLengthBound", "getFileLengthBound", "highAddress", "getHighAddress", "highFileAddress", "getHighFileAddress", "<set-?>", "identity", "getIdentity", "internalTip", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljetbrains/exodus/log/LogTip;", "", "isClosing", "()Z", "lastSyncTicks", "location", "", "getLocation", "()Ljava/lang/String;", "lowAddress", "getLowAddress", "numberOfFiles", "getNumberOfFiles", "readBytesListeners", "Ljetbrains/exodus/log/ReadBytesListener;", "reader", "Ljetbrains/exodus/io/DataReader;", "testConfig", "Ljetbrains/exodus/log/LogTestConfig;", "getTestConfig$annotations", "()V", "tip", "getTip", "()Ljetbrains/exodus/log/LogTip;", "writer", "Ljetbrains/exodus/io/DataWriter;", "writtenHighAddress", "getWrittenHighAddress", "abortWrite", "", "addBlockListener", "listener", "addReadBytesListener", "beforeWrite", "beginWrite", "checkLogConsistency", "blockSetMutable", "Ljetbrains/exodus/log/BlockSet$Mutable;", "clear", "clearFileFromLogCache", "address", "offset", "close", "closeFullFileIfNecessary", "closeWriter", "compareAndSetTip", "logTip", "updatedTip", "doPadWithNulls", "endWrite", "ensureWriter", "flush", "forceSync", "forgetFile", "forgetFiles", "files", "getCachedPage", "", "pageAddress", "getFileAddress", "getFileSize", "fileAddress", "getFirstLoggableOfType", "Ljetbrains/exodus/log/Loggable;", "type", "getHighPage", "alignedAddress", "getHighPageAddress", "getLastFileSize", "getLastLoggableOfType", "getLastLoggableOfTypeBefore", "beforeAddress", "getLoggableIterator", "Ljetbrains/exodus/log/LoggableIterator;", "startAddress", "getNextFileAddress", "getWrittenLoggableType", "", "max", "hasAddress", "hasAddressRange", "from", "to", "isImmutableFile", "isLastFileAddress", "isLastWrittenFileAddress", "notifyBlockCreated", "notifyBlockModified", "notifyReadBytes", "bytes", "count", "padWithNulls", "read", "Ljetbrains/exodus/log/RandomAccessLoggable;", "it", "Ljetbrains/exodus/log/ByteIteratorWithAddress;", "readBytes", "output", "readIteratorFrom", "Ljetbrains/exodus/log/DataIterator;", "readNotNull", "release", "removeFile", "rbt", "Ljetbrains/exodus/io/RemoveBlockType;", "revertWrite", "setHighAddress", "blockSet", "setLogTestConfig", "sync", "truncateFile", "length", "tryLock", "tryWrite", "structureId", "data", "Ljetbrains/exodus/ByteIterable;", "updateLogIdentity", "write", "loggable", "writeContinuously", "notifyListeners", "", "T", "", "call", "Lkotlin/Function1;", "(Ljava/util/List;Lkotlin/jvm/functions/Function1;)[Ljava/lang/Object;", "Companion", "xodus-environment"})
public final class Log
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LogConfig config;
    private final long created;
    @JvmField
    @NotNull
    public final LogCache cache;
    private volatile boolean isClosing;
    private int identity;
    @NotNull
    private final DataReader reader;
    @NotNull
    private final DataWriter writer;
    @NotNull
    private final AtomicReference<LogTip> internalTip;
    @Nullable
    private BufferedDataWriter bufferedWriter;
    private long lastSyncTicks;
    @NotNull
    private final ArrayList<BlockListener> blockListeners;
    @NotNull
    private final ArrayList<ReadBytesListener> readBytesListeners;
    private final int cachePageSize;
    private final long fileLengthBound;
    @Nullable
    private LogTestConfig testConfig;
    @NotNull
    private static final IdGenerator identityGenerator = new IdGenerator();
    @Nullable
    private static volatile SharedLogCache sharedCache;

    public Log(@NotNull LogConfig config) {
        LogCache logCache;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.created = System.currentTimeMillis();
        DataReader dataReader = this.config.getReader();
        Intrinsics.checkNotNullExpressionValue((Object)dataReader, (String)"config.reader");
        this.reader = dataReader;
        dataReader = this.config.getWriter();
        Intrinsics.checkNotNullExpressionValue((Object)dataReader, (String)"config.writer");
        this.writer = dataReader;
        this.blockListeners = new ArrayList(2);
        this.readBytesListeners = new ArrayList(2);
        this.cachePageSize = this.config.getCachePageSize();
        this.tryLock();
        long fileLength = this.config.getFileSize() * 1024L;
        if (fileLength % (long)this.cachePageSize != 0L) {
            throw new InvalidSettingException("File size should be a multiple of cache page size.");
        }
        this.fileLengthBound = fileLength;
        BlockSet.Mutable blockSetMutable = new BlockSet.Immutable(fileLength, null, 2, null).beginWrite();
        if (this.reader instanceof FileDataReader) {
            ((FileDataReader)this.reader).setLog(this);
        }
        this.checkLogConsistency(blockSetMutable);
        BlockSet.Immutable blockSetImmutable = blockSetMutable.endWrite();
        long memoryUsage = this.config.getMemoryUsage();
        boolean nonBlockingCache = this.config.isNonBlockingCache();
        boolean useSoftReferences = this.config.getCacheUseSoftReferences();
        int generationCount = this.config.getCacheGenerationCount();
        if (memoryUsage != 0L) {
            logCache = this.config.isSharedCache() ? Log.Companion.getSharedCache(memoryUsage, this.cachePageSize, nonBlockingCache, useSoftReferences, generationCount) : (LogCache)new SeparateLogCache(memoryUsage, this.cachePageSize, nonBlockingCache, useSoftReferences, generationCount);
        } else {
            int memoryUsagePercentage = this.config.getMemoryUsagePercentage();
            logCache = this.config.isSharedCache() ? Log.Companion.getSharedCache(memoryUsagePercentage, this.cachePageSize, nonBlockingCache, useSoftReferences, generationCount) : (LogCache)new SeparateLogCache(memoryUsagePercentage, this.cachePageSize, nonBlockingCache, useSoftReferences, generationCount);
        }
        this.cache = logCache;
        DeferredIO.getJobProcessor();
        this.isClosing = false;
        Long lastFileAddress = blockSetMutable.getMaximum();
        this.updateLogIdentity();
        if (lastFileAddress == null) {
            this.internalTip = new AtomicReference<LogTip>(new LogTip(this.fileLengthBound));
        } else {
            long currentHighAddress = lastFileAddress + blockSetMutable.getBlock(lastFileAddress).length();
            long highPageAddress = this.getHighPageAddress(currentHighAddress);
            byte[] highPageContent = new byte[this.cachePageSize];
            LogTip tmpTip = new LogTip(highPageContent, highPageAddress, this.cachePageSize, currentHighAddress, currentHighAddress, blockSetImmutable);
            this.internalTip = new AtomicReference<LogTip>(tmpTip);
            int highPageSize = currentHighAddress == 0L ? 0 : this.readBytes(highPageContent, highPageAddress);
            LogTip proposedTip = new LogTip(highPageContent, highPageAddress, highPageSize, currentHighAddress, currentHighAddress, blockSetImmutable);
            this.internalTip.set(proposedTip);
            LoggableIterator lastFileLoggables = new LoggableIterator(this, lastFileAddress);
            final Ref.LongRef approvedHighAddress = new Ref.LongRef();
            approvedHighAddress.element = lastFileAddress;
            try {
                while (lastFileLoggables.hasNext()) {
                    long approvedHighAddressCandidate;
                    int dataLength;
                    RandomAccessLoggable loggable = lastFileLoggables.next();
                    int n = dataLength = NullLoggable.isNullLoggable(loggable) ? 0 : loggable.getDataLength();
                    if (dataLength > 0) {
                        ByteIteratorWithAddress data = loggable.getData().iterator();
                        int n2 = 0;
                        while (n2 < dataLength) {
                            int i = n2++;
                            if (!data.hasNext()) {
                                throw new ExodusException(Intrinsics.stringPlus((String)"Can't read loggable fully", (Object)LogUtil.getWrongAddressErrorMessage(data.getAddress(), this.fileLengthBound)));
                            }
                            data.next();
                        }
                    } else if (dataLength < 0) break;
                    if ((approvedHighAddressCandidate = loggable.getAddress() + (long)loggable.length()) <= currentHighAddress) {
                        approvedHighAddress.element = approvedHighAddressCandidate;
                        continue;
                    }
                    break;
                }
            }
            catch (ExodusException e) {
                Companion.getLogger().info((Throwable)e, (Function0)new Function0<Object>(){

                    @Nullable
                    public final Object invoke() {
                        return Intrinsics.stringPlus((String)"Exception on Log recovery. Approved high address = ", (Object)approvedHighAddress.element);
                    }
                });
            }
            this.internalTip.set(proposedTip.withApprovedAddress(approvedHighAddress.element));
        }
        this.sync();
        if (this.config.isWarmup()) {
            LogWarmupKt.warmup(this);
        }
    }

    @NotNull
    public final LogConfig getConfig() {
        return this.config;
    }

    public final long getCreated() {
        return this.created;
    }

    public final boolean isClosing() {
        return this.isClosing;
    }

    public final int getIdentity() {
        return this.identity;
    }

    @NotNull
    public final LogTip getTip() {
        LogTip logTip = this.internalTip.get();
        Intrinsics.checkNotNullExpressionValue((Object)logTip, (String)"internalTip.get()");
        return logTip;
    }

    public final int getCachePageSize() {
        return this.cachePageSize;
    }

    public final long getFileLengthBound() {
        return this.fileLengthBound;
    }

    @Deprecated(message="for tests only")
    private static /* synthetic */ void getTestConfig$annotations() {
    }

    @NotNull
    public final String getLocation() {
        String string = this.reader.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reader.location");
        return string;
    }

    public final long getNumberOfFiles() {
        return this.getTip().blockSet.size();
    }

    @NotNull
    public final long[] getAllFileAddresses() {
        return this.getTip().blockSet.getArray();
    }

    public final long getHighAddress() {
        return this.getTip().highAddress;
    }

    public final long getWrittenHighAddress() {
        return this.ensureWriter().getHighAddress();
    }

    public final long getLowAddress() {
        Long result;
        Long l = result = this.getTip().blockSet.getMinimum();
        return l == null ? -1L : l;
    }

    public final long getHighFileAddress() {
        return this.getFileAddress(this.getHighAddress());
    }

    public final long getDiskUsage() {
        long[] allFiles = this.getTip().getAllFiles();
        int filesCount = allFiles.length;
        return filesCount == 0 ? 0L : (long)(filesCount - 1) * this.fileLengthBound + this.getLastFileSize(allFiles[filesCount - 1], this.getTip());
    }

    public final float getCacheHitRate() {
        return this.cache.hitRate();
    }

    private final void checkLogConsistency(BlockSet.Mutable blockSetMutable) {
        boolean bl;
        Iterator blockIterator = this.reader.getBlocks().iterator();
        if (!blockIterator.hasNext()) {
            return;
        }
        if (this.config.isCleanDirectoryExpected()) {
            throw new ExodusException("Clean log is expected");
        }
        DataReaderWriterProvider dataReaderWriterProvider = this.config.getReaderWriterProvider();
        boolean rwIsReadonly = dataReaderWriterProvider == null ? false : (bl = dataReaderWriterProvider.isReadonly());
        boolean clearInvalidLog = this.config.isClearInvalidLog();
        boolean hasNext = false;
        do {
            Block block = (Block)blockIterator.next();
            long address = block.getAddress();
            long blockLength = block.length();
            String clearLogReason = null;
            hasNext = blockIterator.hasNext();
            if (blockLength > this.fileLengthBound || hasNext && blockLength != this.fileLengthBound) {
                clearLogReason = Intrinsics.stringPlus((String)"Unexpected file length", (Object)LogUtil.getWrongAddressErrorMessage(address, this.fileLengthBound));
            }
            if (clearLogReason == null && address != this.getFileAddress(address)) {
                if (rwIsReadonly || !clearInvalidLog) {
                    throw new ExodusException("Unexpected file address " + LogUtil.getLogFilename(address) + LogUtil.getWrongAddressErrorMessage(address, this.fileLengthBound));
                }
                clearLogReason = "Unexpected file address " + LogUtil.getLogFilename(address) + LogUtil.getWrongAddressErrorMessage(address, this.fileLengthBound);
            }
            if (clearLogReason != null) {
                if (rwIsReadonly || !clearInvalidLog) {
                    throw new ExodusException(clearLogReason);
                }
                Companion.getLogger().error(Intrinsics.stringPlus((String)"Clearing log due to: ", (Object)clearLogReason));
                blockSetMutable.clear();
                this.writer.clear();
                break;
            }
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"block");
            blockSetMutable.add(address, block);
        } while (hasNext);
    }

    @NotNull
    public final LogTip setHighAddress(@NotNull LogTip logTip, long highAddress) {
        Intrinsics.checkNotNullParameter((Object)logTip, (String)"logTip");
        return this.setHighAddress(logTip, highAddress, logTip.blockSet.beginWrite());
    }

    @NotNull
    public final LogTip setHighAddress(@NotNull LogTip logTip, long highAddress, @NotNull BlockSet.Mutable blockSet) {
        Intrinsics.checkNotNullParameter((Object)logTip, (String)"logTip");
        Intrinsics.checkNotNullParameter((Object)blockSet, (String)"blockSet");
        if (highAddress > logTip.highAddress) {
            throw new ExodusException("Only can decrease high address");
        }
        if (highAddress == logTip.highAddress) {
            if (this.bufferedWriter != null) {
                throw new IllegalStateException("Unexpected write in progress");
            }
            return logTip;
        }
        LogTestConfig testConfig = this.testConfig;
        if (testConfig != null && testConfig.isSettingHighAddressDenied()) {
            throw new ExodusException("Setting high address is denied");
        }
        this.closeWriter();
        LongArrayList blocksToDelete = new LongArrayList();
        long blockToTruncate = -1L;
        for (long blockAddress : blockSet.getArray()) {
            if (blockAddress <= highAddress) {
                blockToTruncate = blockAddress;
                break;
            }
            blocksToDelete.add(blockAddress);
        }
        int n = 0;
        int n2 = blocksToDelete.size();
        while (n < n2) {
            int i = n++;
            this.removeFile(blocksToDelete.get(i), RemoveBlockType.Delete, blockSet);
        }
        if (blockToTruncate >= 0L) {
            this.truncateFile(blockToTruncate, highAddress - blockToTruncate);
        }
        LogTip updatedTip = null;
        if (blockSet.isEmpty()) {
            this.updateLogIdentity();
            updatedTip = new LogTip(this.fileLengthBound);
        } else {
            long oldHighPageAddress = logTip.pageAddress;
            long approvedHighAddress = logTip.approvedHighAddress;
            if (highAddress < approvedHighAddress) {
                approvedHighAddress = highAddress;
            }
            long highPageAddress = this.getHighPageAddress(highAddress);
            BlockSet.Immutable blockSetImmutable = blockSet.endWrite();
            int highPageSize = (int)(highAddress - highPageAddress);
            if (oldHighPageAddress == highPageAddress) {
                LogTip logTip2 = logTip.withResize(highPageSize, highAddress, approvedHighAddress, blockSetImmutable);
                Intrinsics.checkNotNullExpressionValue((Object)logTip2, (String)"logTip.withResize(highPa\u2026dress, blockSetImmutable)");
                updatedTip = logTip2;
            } else {
                this.updateLogIdentity();
                byte[] highPageContent = new byte[this.cachePageSize];
                if (highPageSize > 0 && this.readBytes(highPageContent, highPageAddress) < highPageSize) {
                    throw new ExodusException("Can't read expected high page bytes");
                }
                updatedTip = new LogTip(highPageContent, highPageAddress, highPageSize, highAddress, approvedHighAddress, blockSetImmutable);
            }
        }
        this.compareAndSetTip(logTip, updatedTip);
        this.bufferedWriter = null;
        return updatedTip;
    }

    private final void closeWriter() {
        if (this.bufferedWriter != null) {
            throw new IllegalStateException("Unexpected write in progress");
        }
        this.writer.close();
    }

    @NotNull
    public final LogTip beginWrite() {
        BufferedDataWriter writer;
        this.bufferedWriter = writer = new BufferedDataWriter(this, this.writer, this.getTip());
        LogTip logTip = writer.getStartingTip();
        Intrinsics.checkNotNullExpressionValue((Object)logTip, (String)"writer.startingTip");
        return logTip;
    }

    public final void abortWrite() {
        this.bufferedWriter = null;
    }

    public final void revertWrite(@NotNull LogTip logTip) {
        Intrinsics.checkNotNullParameter((Object)logTip, (String)"logTip");
        BufferedDataWriter writer = this.ensureWriter();
        Object object = writer.getBlockSetMutable();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"writer.blockSetMutable");
        BlockSet.Mutable blockSet = object;
        this.abortWrite();
        object = writer.getUpdatedTip();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"writer.updatedTip");
        this.setHighAddress(this.compareAndSetTip(logTip, (LogTip)object), logTip.highAddress, blockSet);
    }

    @NotNull
    public final LogTip endWrite() {
        BufferedDataWriter writer = this.ensureWriter();
        LogTip logTip = writer.getStartingTip();
        Intrinsics.checkNotNullExpressionValue((Object)logTip, (String)"writer.startingTip");
        LogTip logTip2 = logTip;
        LogTip logTip3 = writer.getUpdatedTip();
        Intrinsics.checkNotNullExpressionValue((Object)logTip3, (String)"writer.updatedTip");
        LogTip updatedTip = logTip3;
        this.compareAndSetTip(logTip2, updatedTip);
        this.bufferedWriter = null;
        return updatedTip;
    }

    @NotNull
    public final LogTip compareAndSetTip(@NotNull LogTip logTip, @NotNull LogTip updatedTip) {
        Intrinsics.checkNotNullParameter((Object)logTip, (String)"logTip");
        Intrinsics.checkNotNullParameter((Object)updatedTip, (String)"updatedTip");
        if (!this.internalTip.compareAndSet(logTip, updatedTip)) {
            throw new ExodusException("write start/finish mismatch");
        }
        return updatedTip;
    }

    public final long getFileAddress(long address) {
        return address - address % this.fileLengthBound;
    }

    public final long getNextFileAddress(long fileAddress) {
        LongIterator files = this.getTip().blockSet.getFilesFrom(fileAddress);
        if (files.hasNext()) {
            long result = files.nextLong();
            if (result != fileAddress) {
                throw new ExodusException(Intrinsics.stringPlus((String)"There is no file by address ", (Object)fileAddress));
            }
            if (files.hasNext()) {
                return files.nextLong();
            }
        }
        return -1L;
    }

    public final boolean isLastFileAddress(long address, @NotNull LogTip logTip) {
        Intrinsics.checkNotNullParameter((Object)logTip, (String)"logTip");
        return this.getFileAddress(address) == this.getFileAddress(logTip.highAddress);
    }

    public final boolean isLastWrittenFileAddress(long address) {
        return this.getFileAddress(address) == this.getFileAddress(this.getWrittenHighAddress());
    }

    public final boolean hasAddress(long address) {
        long fileAddress = this.getFileAddress(address);
        LogTip logTip = this.getTip();
        LongIterator files = logTip.blockSet.getFilesFrom(fileAddress);
        if (!files.hasNext()) {
            return false;
        }
        long leftBound = files.nextLong();
        return leftBound == fileAddress && leftBound + this.getFileSize(leftBound, logTip) > address;
    }

    public final boolean hasAddressRange(long from, long to) {
        boolean bl;
        long fileAddress = this.getFileAddress(from);
        LogTip logTip = this.getTip();
        LongIterator files = logTip.blockSet.getFilesFrom(fileAddress);
        do {
            if (!files.hasNext() || files.nextLong() != fileAddress) {
                return false;
            }
            if (from + 1L <= (fileAddress += this.getFileSize(fileAddress, logTip))) {
                if (fileAddress <= to) {
                    bl = true;
                    continue;
                }
                bl = false;
                continue;
            }
            bl = false;
        } while (bl);
        return true;
    }

    @JvmOverloads
    public final long getFileSize(long fileAddress, @NotNull LogTip logTip) {
        Intrinsics.checkNotNullParameter((Object)logTip, (String)"logTip");
        return !this.isLastFileAddress(fileAddress, logTip) ? this.fileLengthBound : this.getLastFileSize(fileAddress, logTip);
    }

    public static /* synthetic */ long getFileSize$default(Log log, long l, LogTip logTip, int n, Object object) {
        if ((n & 2) != 0) {
            logTip = log.getTip();
        }
        return log.getFileSize(l, logTip);
    }

    private final long getLastFileSize(long fileAddress, LogTip logTip) {
        long highAddress = logTip.highAddress;
        long result = highAddress % this.fileLengthBound;
        return result == 0L && highAddress != fileAddress ? this.fileLengthBound : result;
    }

    @Nullable
    public final byte[] getHighPage(long alignedAddress) {
        LogTip tip = this.getTip();
        return tip.pageAddress == alignedAddress && tip.count >= 0 ? tip.bytes : null;
    }

    @NotNull
    public final byte[] getCachedPage(long pageAddress) {
        return this.cache.getPage(this, pageAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addBlockListener(@NotNull BlockListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        ArrayList<BlockListener> arrayList = this.blockListeners;
        synchronized (arrayList) {
            boolean bl = false;
            boolean bl2 = this.blockListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addReadBytesListener(@NotNull ReadBytesListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        ArrayList<ReadBytesListener> arrayList = this.readBytesListeners;
        synchronized (arrayList) {
            boolean bl = false;
            boolean bl2 = this.readBytesListeners.add(listener);
        }
    }

    @NotNull
    public final RandomAccessLoggable read(long address) {
        return this.read(this.readIteratorFrom(address), address);
    }

    public final byte getWrittenLoggableType(long address, byte max) {
        return this.ensureWriter().getByte(address, max);
    }

    @JvmOverloads
    @NotNull
    public final RandomAccessLoggable read(@NotNull ByteIteratorWithAddress it, long address) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        byte type = (byte)(it.next() ^ 0xFFFFFF80);
        return NullLoggable.isNullLoggable(type) ? (RandomAccessLoggable)new NullLoggable(address) : this.read(type, it, address);
    }

    public static /* synthetic */ RandomAccessLoggable read$default(Log log, ByteIteratorWithAddress byteIteratorWithAddress, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = byteIteratorWithAddress.getAddress();
        }
        return log.read(byteIteratorWithAddress, l);
    }

    @NotNull
    public final RandomAccessLoggable readNotNull(@NotNull ByteIteratorWithAddress it, long address) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return this.read((byte)(it.next() ^ 0xFFFFFF80), it, address);
    }

    private final RandomAccessLoggable read(byte type, ByteIteratorWithAddress it, long address) {
        int structureId = CompressedUnsignedLongByteIterable.getInt(it);
        int dataLength = CompressedUnsignedLongByteIterable.getInt(it);
        long dataAddress = it.getAddress();
        if (dataLength > 0 && it.availableInCurrentPage(dataLength)) {
            return new RandomAccessLoggableAndArrayByteIterable(address, type, structureId, dataAddress, it.getCurrentPage(), it.getOffset(), dataLength);
        }
        RandomAccessByteIterable data = new RandomAccessByteIterable(dataAddress, this);
        return new RandomAccessLoggableImpl(address, type, data, dataLength, structureId);
    }

    @NotNull
    public final LoggableIterator getLoggableIterator(long startAddress) {
        return new LoggableIterator(this, startAddress);
    }

    public final long tryWrite(byte type, int structureId, @NotNull ByteIterable data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        long result = this.writeContinuously(type, structureId, data);
        if (result < 0L) {
            this.doPadWithNulls();
        }
        return result;
    }

    public final long write(@NotNull Loggable loggable) {
        Intrinsics.checkNotNullParameter((Object)loggable, (String)"loggable");
        byte by = loggable.getType();
        int n = loggable.getStructureId();
        ByteIterable byteIterable = loggable.getData();
        Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"loggable.data");
        return this.write(by, n, byteIterable);
    }

    public final long write(byte type, int structureId, @NotNull ByteIterable data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        long result = this.writeContinuously(type, structureId, data);
        if (result < 0L) {
            this.doPadWithNulls();
            result = this.writeContinuously(type, structureId, data);
            if (result < 0L) {
                throw new TooBigLoggableException();
            }
        }
        return result;
    }

    @Nullable
    public final Loggable getFirstLoggableOfType(int type) {
        LogTip logTip = this.getTip();
        LongIterator files = logTip.blockSet.getFilesFrom(0L);
        long approvedHighAddress = logTip.approvedHighAddress;
        block0: while (files.hasNext()) {
            RandomAccessLoggable loggable;
            long fileAddress = files.nextLong();
            LoggableIterator it = this.getLoggableIterator(fileAddress);
            while (it.hasNext() && (loggable = it.next()) != null && loggable.getAddress() < fileAddress + this.fileLengthBound) {
                if (loggable.getType() == type) {
                    return loggable;
                }
                if (loggable.getAddress() + (long)loggable.length() != approvedHighAddress) continue;
                continue block0;
            }
        }
        return null;
    }

    @Nullable
    public final Loggable getLastLoggableOfType(int type) {
        Loggable result = null;
        LogTip logTip = this.getTip();
        long approvedHighAddress = logTip.approvedHighAddress;
        long[] lArray = logTip.blockSet.getArray();
        int n = 0;
        int n2 = lArray.length;
        block0: while (n < n2) {
            RandomAccessLoggable loggable;
            long fileAddress = lArray[n];
            ++n;
            if (result != null) break;
            LoggableIterator it = this.getLoggableIterator(fileAddress);
            while (it.hasNext() && (loggable = it.next()) != null && loggable.getAddress() < fileAddress + this.fileLengthBound) {
                if (loggable.getType() == type) {
                    result = loggable;
                }
                if (loggable.getAddress() + (long)loggable.length() != approvedHighAddress) continue;
                continue block0;
            }
        }
        return result;
    }

    @Nullable
    public final Loggable getLastLoggableOfTypeBefore(int type, long beforeAddress, @NotNull LogTip logTip) {
        Intrinsics.checkNotNullParameter((Object)logTip, (String)"logTip");
        Loggable result = null;
        long[] lArray = logTip.blockSet.getArray();
        int n = 0;
        int n2 = lArray.length;
        while (n < n2) {
            RandomAccessLoggable loggable;
            long address;
            long fileAddress = lArray[n];
            ++n;
            if (result != null) break;
            if (fileAddress >= beforeAddress) continue;
            LoggableIterator it = this.getLoggableIterator(fileAddress);
            while (it.hasNext() && it.next() != null && (address = loggable.getAddress()) < beforeAddress && address < fileAddress + this.fileLengthBound) {
                if (loggable.getType() != type) continue;
                result = loggable;
            }
        }
        return result;
    }

    public final boolean isImmutableFile(long fileAddress) {
        return fileAddress + this.fileLengthBound <= this.getTip().approvedHighAddress;
    }

    @JvmOverloads
    public final void flush(boolean forceSync) {
        this.ensureWriter().flush();
        if (forceSync || this.config.isDurableWrite()) {
            this.sync();
        }
    }

    public static /* synthetic */ void flush$default(Log log, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        log.flush(bl);
    }

    public final void sync() {
        this.writer.sync();
        this.lastSyncTicks = System.currentTimeMillis();
    }

    @Override
    public void close() {
        LogTip logTip = this.getTip();
        this.isClosing = true;
        this.sync();
        this.reader.close();
        this.closeWriter();
        this.compareAndSetTip(logTip, new LogTip(this.fileLengthBound, logTip.pageAddress, logTip.highAddress));
        this.release();
    }

    public final void release() {
        this.writer.release();
    }

    @NotNull
    public final LogTip clear() {
        LogTip logTip = this.getTip();
        this.cache.clear();
        this.reader.close();
        this.closeWriter();
        this.writer.clear();
        LogTip updatedTip = new LogTip(this.fileLengthBound);
        this.compareAndSetTip(logTip, updatedTip);
        this.bufferedWriter = null;
        this.updateLogIdentity();
        return updatedTip;
    }

    @Deprecated(message="for tests only")
    public final void forgetFile(long address) {
        this.beginWrite();
        long[] lArray = new long[]{address};
        this.forgetFiles(lArray);
        this.endWrite();
    }

    public final void forgetFiles(@NotNull long[] files) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        BlockSet.Mutable mutable = this.ensureWriter().getBlockSetMutable();
        Intrinsics.checkNotNullExpressionValue((Object)mutable, (String)"ensureWriter().blockSetMutable");
        BlockSet.Mutable blockSetMutable = mutable;
        for (long file : files) {
            blockSetMutable.remove(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public final void removeFile(long address, @NotNull RemoveBlockType rbt, @Nullable BlockSet.Mutable blockSetMutable) {
        BlockListener[] listeners$iv;
        BlockListener[] $i$a$-synchronized-Log$notifyListeners$listeners$1$iv22;
        Intrinsics.checkNotNullParameter((Object)rbt, (String)"rbt");
        Block block = this.getTip().blockSet.getBlock(address);
        Log log = this;
        List $this$notifyListeners$iv = this.blockListeners;
        boolean $i$f$notifyListeners = false;
        synchronized ($this$notifyListeners$iv) {
            boolean $i$a$-synchronized-Log$notifyListeners$listeners$1$iv22 = false;
            Collection $this$toTypedArray$iv$iv = $this$notifyListeners$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            BlockListener[] blockListenerArray = thisCollection$iv$iv.toArray(new BlockListener[0]);
            if (blockListenerArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            $i$a$-synchronized-Log$notifyListeners$listeners$1$iv22 = blockListenerArray;
        }
        BlockListener[] $this$forEach$iv$iv = listeners$iv = $i$a$-synchronized-Log$notifyListeners$listeners$1$iv22;
        boolean $i$f$forEach = false;
        for (BlockListener element$iv$iv : $this$forEach$iv$iv) {
            BlockListener it$iv = element$iv$iv;
            boolean bl = false;
            BlockListener it = it$iv;
            boolean bl2 = false;
            it.beforeBlockDeleted(block, this.reader, this.writer);
        }
        BlockListener[] listeners = listeners$iv;
        try {
            DataReaderWriterProvider dataReaderWriterProvider = this.config.getReaderWriterProvider();
            if (!(dataReaderWriterProvider == null ? false : dataReaderWriterProvider.isReadonly())) {
                this.writer.removeBlock(address, rbt);
            }
            BlockSet.Mutable mutable = blockSetMutable;
            if (mutable != null) {
                mutable.remove(address);
            }
            Log.clearFileFromLogCache$default(this, address, 0L, 2, null);
        }
        finally {
            BlockListener[] $this$forEach$iv = listeners;
            boolean $i$f$forEach2 = false;
            for (BlockListener element$iv : $this$forEach$iv) {
                BlockListener it = element$iv;
                boolean bl = false;
                it.afterBlockDeleted(address, this.reader, this.writer);
            }
        }
    }

    public static /* synthetic */ void removeFile$default(Log log, long l, RemoveBlockType removeBlockType, BlockSet.Mutable mutable, int n, Object object) {
        if ((n & 2) != 0) {
            removeBlockType = RemoveBlockType.Delete;
        }
        if ((n & 4) != 0) {
            mutable = null;
        }
        log.removeFile(l, removeBlockType, mutable);
    }

    @NotNull
    public final BufferedDataWriter ensureWriter() {
        BufferedDataWriter bufferedDataWriter = this.bufferedWriter;
        if (bufferedDataWriter == null) {
            throw new ExodusException("write not in progress");
        }
        return bufferedDataWriter;
    }

    private final void truncateFile(long address, long length) {
        DataReaderWriterProvider dataReaderWriterProvider = this.config.getReaderWriterProvider();
        if (!(dataReaderWriterProvider == null ? false : dataReaderWriterProvider.isReadonly())) {
            this.writer.truncateBlock(address, length);
        }
        this.writer.openOrCreateBlock(address, length);
        this.clearFileFromLogCache(address, length - length % (long)this.cachePageSize);
    }

    public final void clearFileFromLogCache(long address, long offset) {
        for (long off = offset; off < this.fileLengthBound; off += (long)this.cachePageSize) {
            this.cache.removePage$xodus_environment(this, address + off);
        }
    }

    public static /* synthetic */ void clearFileFromLogCache$default(Log log, long l, long l2, int n, Object object) {
        if ((n & 2) != 0) {
            l2 = 0L;
        }
        log.clearFileFromLogCache(l, l2);
    }

    public final void padWithNulls() {
        this.beforeWrite(this.ensureWriter());
        this.doPadWithNulls();
    }

    public final void doPadWithNulls() {
        byte[] cachedTailPage;
        BufferedDataWriter writer = this.ensureWriter();
        long bytesToWrite = this.fileLengthBound - writer.getLastWrittenFileLength(this.fileLengthBound);
        if (bytesToWrite == 0L) {
            throw new ExodusException("Nothing to pad");
        }
        if (bytesToWrite >= (long)this.cachePageSize && (cachedTailPage = LogCache.Companion.getCachedTailPage(this.cachePageSize)) != null) {
            do {
                writer.write(cachedTailPage, this.cachePageSize);
                writer.incHighAddress(this.cachePageSize);
            } while ((bytesToWrite -= (long)this.cachePageSize) >= (long)this.cachePageSize);
        }
        if (bytesToWrite == 0L) {
            writer.commit();
            this.closeFullFileIfNecessary(writer);
        } else {
            while (true) {
                long l = bytesToWrite;
                bytesToWrite = l + -1L;
                if (l <= 0L) break;
                NullLoggable nullLoggable = NullLoggable.create();
                Intrinsics.checkNotNullExpressionValue((Object)nullLoggable, (String)"create()");
                this.writeContinuously(nullLoggable);
            }
        }
    }

    public final int readBytes(@NotNull byte[] output, long address) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        long fileAddress = this.getFileAddress(address);
        LogTip logTip = this.getTip();
        LongIterator files = logTip.blockSet.getFilesFrom(fileAddress);
        if (files.hasNext()) {
            long leftBound = files.nextLong();
            long fileSize = this.getFileSize(leftBound, logTip);
            if (leftBound == fileAddress && fileAddress + fileSize > address) {
                Block block = logTip.blockSet.getBlock(fileAddress);
                int readBytes = block.read(output, address - fileAddress, 0, output.length);
                StreamCipherProvider cipherProvider = this.config.getCipherProvider();
                if (cipherProvider != null) {
                    byte[] byArray = this.config.getCipherKey();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"config.cipherKey");
                    EnvKryptKt.cryptBlocksMutable(cipherProvider, byArray, this.config.getCipherBasicIV(), address, output, 0, readBytes, 1024);
                }
                this.notifyReadBytes(output, readBytes);
                return readBytes;
            }
            Long l = logTip.blockSet.getMinimum();
            if (fileAddress < (l == null ? -1L : l)) {
                BlockNotFoundException.raise("Address is out of log space, underflow", this, address);
            }
            Long l2 = logTip.blockSet.getMaximum();
            if (fileAddress >= (l2 == null ? -1L : l2)) {
                BlockNotFoundException.raise("Address is out of log space, overflow", this, address);
            }
        }
        BlockNotFoundException.raise(this, address);
        return 0;
    }

    @NotNull
    public final DataIterator readIteratorFrom(long address) {
        return new DataIterator(this, address);
    }

    private final void tryLock() {
        long lockTimeout;
        if (!this.config.isLockIgnored() && !this.writer.lock(lockTimeout = this.config.getLockTimeout())) {
            throw new ExodusException("Can't acquire environment lock after " + lockTimeout + " ms.\n\n Lock owner info: \n" + this.writer.lockInfo());
        }
    }

    public final long getHighPageAddress(long highAddress) {
        int alignment = (int)highAddress & this.cachePageSize - 1;
        if (alignment == 0 && highAddress > 0L) {
            alignment = this.cachePageSize;
        }
        return highAddress - (long)alignment;
    }

    public final long writeContinuously(@NotNull Loggable loggable) {
        Intrinsics.checkNotNullParameter((Object)loggable, (String)"loggable");
        byte by = loggable.getType();
        int n = loggable.getStructureId();
        ByteIterable byteIterable = loggable.getData();
        Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"loggable.data");
        return this.writeContinuously(by, n, byteIterable);
    }

    public final long writeContinuously(byte type, int structureId, @NotNull ByteIterable data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        BufferedDataWriter writer = this.ensureWriter();
        long result = this.beforeWrite(writer);
        boolean isNull = NullLoggable.isNullLoggable(type);
        int recordLength = 1;
        if (isNull) {
            writer.write((byte)(type ^ 0xFFFFFF80));
        } else {
            ByteIterable structureIdIterable = CompressedUnsignedLongByteIterable.getIterable(structureId);
            int dataLength = data.getLength();
            ByteIterable dataLengthIterable = CompressedUnsignedLongByteIterable.getIterable(dataLength);
            recordLength += structureIdIterable.getLength();
            recordLength += dataLengthIterable.getLength();
            if ((long)(recordLength += dataLength) > this.fileLengthBound - writer.getLastWrittenFileLength(this.fileLengthBound)) {
                return -1L;
            }
            writer.write((byte)(type ^ 0xFFFFFF80));
            Intrinsics.checkNotNullExpressionValue((Object)structureIdIterable, (String)"structureIdIterable");
            Log.Companion.writeByteIterable(writer, structureIdIterable);
            Intrinsics.checkNotNullExpressionValue((Object)dataLengthIterable, (String)"dataLengthIterable");
            Log.Companion.writeByteIterable(writer, dataLengthIterable);
            if (dataLength > 0) {
                Log.Companion.writeByteIterable(writer, data);
            }
        }
        writer.commit();
        writer.incHighAddress(recordLength);
        this.closeFullFileIfNecessary(writer);
        return result;
    }

    public final long writeContinuously(@NotNull byte[] data, int count) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        BufferedDataWriter writer = this.ensureWriter();
        long result = this.beforeWrite(writer);
        if ((long)count > this.fileLengthBound - writer.getLastWrittenFileLength(this.fileLengthBound)) {
            return -1L;
        }
        BufferedDataWriter $this$writeContinuously_u24lambda_u2d4 = writer;
        boolean bl = false;
        $this$writeContinuously_u24lambda_u2d4.write(data, count);
        $this$writeContinuously_u24lambda_u2d4.commit();
        $this$writeContinuously_u24lambda_u2d4.incHighAddress(count);
        this.closeFullFileIfNecessary($this$writeContinuously_u24lambda_u2d4);
        return result;
    }

    private final long beforeWrite(BufferedDataWriter writer) {
        long result = writer.getHighAddress();
        LogTestConfig testConfig = this.testConfig;
        if (testConfig != null) {
            long maxHighAddress = testConfig.getMaxHighAddress();
            boolean bl = 0L <= maxHighAddress ? maxHighAddress <= result : false;
            if (bl) {
                throw new ExodusException(Intrinsics.stringPlus((String)"Can't write more than ", (Object)maxHighAddress));
            }
        }
        if (!this.writer.isOpen()) {
            boolean fileCreated;
            long fileAddress = this.getFileAddress(result);
            Block block = writer.openOrCreateBlock(fileAddress, writer.getLastWrittenFileLength(this.fileLengthBound));
            boolean bl = fileCreated = !writer.getBlockSetMutable().contains(fileAddress);
            if (fileCreated) {
                BlockSet.Mutable mutable = writer.getBlockSetMutable();
                Intrinsics.checkNotNullExpressionValue((Object)block, (String)"block");
                mutable.add(fileAddress, block);
                this.writer.syncDirectory();
                this.notifyBlockCreated(fileAddress);
            } else {
                this.notifyBlockModified(fileAddress);
            }
        }
        return result;
    }

    private final void closeFullFileIfNecessary(BufferedDataWriter writer) {
        boolean shouldCreateNewFile;
        boolean bl = shouldCreateNewFile = writer.getLastWrittenFileLength(this.fileLengthBound) == 0L;
        if (shouldCreateNewFile) {
            this.flush(true);
            this.writer.close();
            BlockSet.Mutable mutable = writer.getBlockSetMutable();
            Intrinsics.checkNotNullExpressionValue((Object)mutable, (String)"writer.blockSetMutable");
            BlockSet.Mutable blockSet = mutable;
            Long lastFile = blockSet.getMaximum();
            if (lastFile != null) {
                long length;
                Block refreshed;
                Block block = blockSet.getBlock(lastFile);
                if (block != (refreshed = block.refresh())) {
                    long l = lastFile;
                    Intrinsics.checkNotNullExpressionValue((Object)refreshed, (String)"refreshed");
                    blockSet.add(l, refreshed);
                }
                if ((length = refreshed.length()) < this.fileLengthBound) {
                    throw new IllegalStateException("File's too short (" + LogUtil.getLogFilename(lastFile) + "), block.length() = " + length + ", fileLengthBound = " + this.fileLengthBound);
                }
                if (this.config.isFullFileReadonly() && block instanceof File) {
                    ((File)block).setReadOnly();
                }
            }
        } else if (System.currentTimeMillis() > this.lastSyncTicks + this.config.getSyncPeriod()) {
            this.flush(true);
        }
    }

    @Deprecated(message="for tests only")
    public final void setLogTestConfig(@Nullable LogTestConfig testConfig) {
        this.testConfig = testConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void notifyBlockCreated(long address) {
        BlockListener[] listeners$iv;
        BlockListener[] $i$a$-synchronized-Log$notifyListeners$listeners$1$iv22;
        Block block = this.getTip().blockSet.getBlock(address);
        Log log = this;
        List $this$notifyListeners$iv = this.blockListeners;
        boolean $i$f$notifyListeners = false;
        synchronized ($this$notifyListeners$iv) {
            boolean $i$a$-synchronized-Log$notifyListeners$listeners$1$iv22 = false;
            Collection $this$toTypedArray$iv$iv = $this$notifyListeners$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            BlockListener[] blockListenerArray = thisCollection$iv$iv.toArray(new BlockListener[0]);
            if (blockListenerArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            $i$a$-synchronized-Log$notifyListeners$listeners$1$iv22 = blockListenerArray;
        }
        BlockListener[] $this$forEach$iv$iv = listeners$iv = $i$a$-synchronized-Log$notifyListeners$listeners$1$iv22;
        boolean $i$f$forEach = false;
        for (BlockListener element$iv$iv : $this$forEach$iv$iv) {
            BlockListener it$iv = element$iv$iv;
            boolean bl = false;
            BlockListener it = it$iv;
            boolean bl2 = false;
            it.blockCreated(block, this.reader, this.writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void notifyBlockModified(long address) {
        BlockListener[] listeners$iv;
        BlockListener[] $i$a$-synchronized-Log$notifyListeners$listeners$1$iv22;
        Block block = this.getTip().blockSet.getBlock(address);
        Log log = this;
        List $this$notifyListeners$iv = this.blockListeners;
        boolean $i$f$notifyListeners = false;
        synchronized ($this$notifyListeners$iv) {
            boolean $i$a$-synchronized-Log$notifyListeners$listeners$1$iv22 = false;
            Collection $this$toTypedArray$iv$iv = $this$notifyListeners$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            BlockListener[] blockListenerArray = thisCollection$iv$iv.toArray(new BlockListener[0]);
            if (blockListenerArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            $i$a$-synchronized-Log$notifyListeners$listeners$1$iv22 = blockListenerArray;
        }
        BlockListener[] $this$forEach$iv$iv = listeners$iv = $i$a$-synchronized-Log$notifyListeners$listeners$1$iv22;
        boolean $i$f$forEach = false;
        for (BlockListener element$iv$iv : $this$forEach$iv$iv) {
            BlockListener it$iv = element$iv$iv;
            boolean bl = false;
            BlockListener it = it$iv;
            boolean bl2 = false;
            it.blockModified(block, this.reader, this.writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void notifyReadBytes(byte[] bytes, int count) {
        ReadBytesListener[] listeners$iv;
        ReadBytesListener[] $i$a$-synchronized-Log$notifyListeners$listeners$1$iv22;
        Log log = this;
        List $this$notifyListeners$iv = this.readBytesListeners;
        boolean $i$f$notifyListeners = false;
        synchronized ($this$notifyListeners$iv) {
            boolean $i$a$-synchronized-Log$notifyListeners$listeners$1$iv22 = false;
            Collection $this$toTypedArray$iv$iv = $this$notifyListeners$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ReadBytesListener[] readBytesListenerArray = thisCollection$iv$iv.toArray(new ReadBytesListener[0]);
            if (readBytesListenerArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            $i$a$-synchronized-Log$notifyListeners$listeners$1$iv22 = readBytesListenerArray;
        }
        ReadBytesListener[] $this$forEach$iv$iv = listeners$iv = $i$a$-synchronized-Log$notifyListeners$listeners$1$iv22;
        boolean $i$f$forEach = false;
        for (ReadBytesListener element$iv$iv : $this$forEach$iv$iv) {
            ReadBytesListener it$iv = element$iv$iv;
            boolean bl = false;
            ReadBytesListener it = it$iv;
            boolean bl2 = false;
            it.bytesRead(bytes, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final /* synthetic */ <T> T[] notifyListeners(List<? extends T> $this$notifyListeners, Function1<? super T, Unit> call) {
        boolean $i$f$notifyListeners = false;
        synchronized ($this$notifyListeners) {
            Object[] listeners;
            Object[] $i$a$-synchronized-Log$notifyListeners$listeners$22;
            try {
                boolean $i$a$-synchronized-Log$notifyListeners$listeners$22 = false;
                Collection $this$toTypedArray$iv = $this$notifyListeners;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Intrinsics.reifiedOperationMarker((int)0, (String)"T?");
                Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
                if (objectArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                $i$a$-synchronized-Log$notifyListeners$listeners$22 = objectArray;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                // MONITOREXIT @DISABLED, blocks:[1, 3] lbl17 : MonitorExitStatement: MONITOREXIT : $this$notifyListeners
                InlineMarker.finallyEnd((int)1);
            }
            Object[] $this$forEach$iv = listeners = $i$a$-synchronized-Log$notifyListeners$listeners$22;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object it = element$iv;
                boolean bl = false;
                call.invoke(it);
            }
            return listeners;
        }
    }

    private final void updateLogIdentity() {
        this.identity = identityGenerator.nextId();
    }

    @JvmOverloads
    public final long getFileSize(long fileAddress) {
        return Log.getFileSize$default(this, fileAddress, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final RandomAccessLoggable read(@NotNull ByteIteratorWithAddress it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return Log.read$default(this, it, 0L, 2, null);
    }

    @JvmOverloads
    public final void flush() {
        Log.flush$default(this, false, 1, null);
    }

    @JvmOverloads
    public final void removeFile(long address, @NotNull RemoveBlockType rbt) {
        Intrinsics.checkNotNullParameter((Object)rbt, (String)"rbt");
        Log.removeFile$default(this, address, rbt, null, 4, null);
    }

    @JvmOverloads
    public final void removeFile(long address) {
        Log.removeFile$default(this, address, null, null, 6, null);
    }

    @JvmStatic
    @Deprecated(message="for tests only")
    public static final void invalidateSharedCache() {
        Companion.invalidateSharedCache();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J0\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\nH\u0002J0\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\nH\u0002J\b\u0010\u0016\u001a\u00020\bH\u0007J\u0018\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ljetbrains/exodus/log/Log$Companion;", "Lmu/KLogging;", "()V", "identityGenerator", "Ljetbrains/exodus/util/IdGenerator;", "sharedCache", "Ljetbrains/exodus/log/SharedLogCache;", "checkCachePageSize", "", "pageSize", "", "cache", "Ljetbrains/exodus/log/LogCache;", "checkUseSoftReferences", "useSoftReferences", "", "getSharedCache", "memoryUsagePercentage", "nonBlocking", "cacheGenerationCount", "memoryUsage", "", "invalidateSharedCache", "writeByteIterable", "writer", "Ljetbrains/exodus/log/BufferedDataWriter;", "iterable", "Ljetbrains/exodus/ByteIterable;", "xodus-environment"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @Deprecated(message="for tests only")
        public final void invalidateSharedCache() {
            Class<Log> clazz = Log.class;
            synchronized (clazz) {
                boolean bl = false;
                sharedCache = null;
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final LogCache getSharedCache(long memoryUsage, int pageSize, boolean nonBlocking, boolean useSoftReferences, int cacheGenerationCount) {
            Object object;
            SharedLogCache result = null;
            result = sharedCache;
            if (result == null) {
                object = Log.class;
                synchronized (object) {
                    boolean $i$a$-synchronized-Log$Companion$getSharedCache$22 = false;
                    if (sharedCache == null) {
                        sharedCache = new SharedLogCache(memoryUsage, pageSize, nonBlocking, useSoftReferences, cacheGenerationCount);
                    }
                    result = sharedCache;
                    Unit $i$a$-synchronized-Log$Companion$getSharedCache$22 = Unit.INSTANCE;
                }
            }
            object = KodusKt.getNotNull((Object)result);
            SharedLogCache cache = (SharedLogCache)object;
            boolean bl = false;
            Companion.checkCachePageSize(pageSize, cache);
            Companion.checkUseSoftReferences(useSoftReferences, cache);
            return (LogCache)object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final LogCache getSharedCache(int memoryUsagePercentage, int pageSize, boolean nonBlocking, boolean useSoftReferences, int cacheGenerationCount) {
            Object object;
            SharedLogCache result = null;
            result = sharedCache;
            if (result == null) {
                object = Log.class;
                synchronized (object) {
                    boolean $i$a$-synchronized-Log$Companion$getSharedCache$42 = false;
                    if (sharedCache == null) {
                        sharedCache = new SharedLogCache(memoryUsagePercentage, pageSize, nonBlocking, useSoftReferences, cacheGenerationCount);
                    }
                    result = sharedCache;
                    Unit $i$a$-synchronized-Log$Companion$getSharedCache$42 = Unit.INSTANCE;
                }
            }
            object = KodusKt.getNotNull((Object)result);
            SharedLogCache cache = (SharedLogCache)object;
            boolean bl = false;
            Companion.checkCachePageSize(pageSize, cache);
            Companion.checkUseSoftReferences(useSoftReferences, cache);
            return (LogCache)object;
        }

        private final void checkCachePageSize(int pageSize, LogCache cache) {
            if (cache.getPageSize$xodus_environment() != pageSize) {
                throw new ExodusException("SharedLogCache was created with page size " + cache.getPageSize$xodus_environment() + " and then requested with page size " + pageSize + ". EnvironmentConfig.LOG_CACHE_PAGE_SIZE is set manually.");
            }
        }

        private final void checkUseSoftReferences(boolean useSoftReferences, SharedLogCache cache) {
            if (cache.getUseSoftReferences$xodus_environment() != useSoftReferences) {
                throw new ExodusException("SharedLogCache was created with useSoftReferences = " + cache.getUseSoftReferences$xodus_environment() + " and then requested with useSoftReferences = " + useSoftReferences + ". EnvironmentConfig.LOG_CACHE_USE_SOFT_REFERENCES is set manually.");
            }
        }

        private final void writeByteIterable(BufferedDataWriter writer, ByteIterable iterable) {
            int length = iterable.getLength();
            if (iterable instanceof ArrayByteIterable) {
                byte[] bytes = iterable.getBytesUnsafe();
                if (length == 1) {
                    writer.write(bytes[0]);
                } else {
                    writer.write(bytes, length);
                }
            } else if (length >= 3) {
                writer.write(iterable.getBytesUnsafe(), length);
            } else {
                ByteIterator iterator = iterable.iterator();
                writer.write(iterator.next());
                if (length == 2) {
                    writer.write(iterator.next());
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

