/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.typetracker;

import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.ITypeInfoExtractor;
import eu.cqse.check.framework.typetracker.abap.AbapTypeInfoExtractor;
import eu.cqse.check.framework.typetracker.cpp.CppTypeInfoExtractor;
import eu.cqse.check.framework.typetracker.cs.CsTypeInfoExtractor;
import eu.cqse.check.framework.typetracker.java.JavaTypeInfoExtractor;
import eu.cqse.check.framework.typetracker.objc.ObjcTypeInfoExtractor;
import eu.cqse.check.framework.typetracker.objc.ObjectiveCppTypeInfoExtractor;
import java.util.EnumSet;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class TypeInfoExtractorFactory {
    private static final EnumSet<ELanguage> SUPPORTED_LANGUAGES = EnumSet.of(ELanguage.ABAP, new ELanguage[]{ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.CS, ELanguage.JAVA, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP});

    public static ITypeInfoExtractor getTypeInfoExtractor(ELanguage language, List<ShallowEntity> rootEntities) {
        CCSMAssert.isTrue((boolean)TypeInfoExtractorFactory.supportsLanguage(language), (String)("No type info extractor is defined for " + language.getReadableName()));
        switch (language) {
            case ABAP: {
                return new AbapTypeInfoExtractor(rootEntities);
            }
            case C: 
            case CPP: 
            case CPP_MS_CLI: {
                return new CppTypeInfoExtractor();
            }
            case CS: {
                return new CsTypeInfoExtractor();
            }
            case JAVA: {
                return new JavaTypeInfoExtractor();
            }
            case OBJECTIVE_C: {
                return new ObjcTypeInfoExtractor();
            }
            case OBJECTIVE_CPP: {
                return new ObjectiveCppTypeInfoExtractor();
            }
        }
        CCSMAssert.fail((String)("No type info extractor is available for " + language.getReadableName()));
        return null;
    }

    public static boolean supportsLanguage(ELanguage language) {
        return SUPPORTED_LANGUAGES.contains(language);
    }
}

