/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.typetracker;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class TypedVariable
implements Serializable {
    private static final long serialVersionUID = -7915139441846763832L;
    public static final String UNKNOWN_TYPE_NAME = "<unknown type>";
    private final String variableName;
    private String typeNameWithoutGenericTypeParameter;
    private final List<IToken> modifiers;
    private final transient ShallowEntity declaringEntity;
    private final String genericTypeParameters;

    public TypedVariable(String variableName, String typeNameWithoutGenericTypeParameter, List<IToken> modifiers, ShallowEntity definitionEntity) {
        this(variableName, typeNameWithoutGenericTypeParameter, modifiers, definitionEntity, null);
    }

    public TypedVariable(String variableName, String typeNameWithoutGenericTypeParameter, List<IToken> modifiers, ShallowEntity definitionEntity, String genericTypeParameters) {
        CCSMAssert.isNotNull((Object)variableName);
        CCSMAssert.isNotNull(modifiers);
        CCSMAssert.isNotNull((Object)definitionEntity);
        this.variableName = variableName;
        this.typeNameWithoutGenericTypeParameter = typeNameWithoutGenericTypeParameter;
        if (typeNameWithoutGenericTypeParameter == null) {
            this.typeNameWithoutGenericTypeParameter = UNKNOWN_TYPE_NAME;
        }
        this.modifiers = new ArrayList<IToken>(modifiers);
        this.declaringEntity = definitionEntity;
        this.genericTypeParameters = genericTypeParameters;
    }

    public String getTypeName() {
        if (this.genericTypeParameters == null) {
            return this.getTypeNameWithoutGenericTypeParameter();
        }
        return this.typeNameWithoutGenericTypeParameter + "<" + this.genericTypeParameters + ">";
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String getTypeNameWithoutGenericTypeParameter() {
        return this.typeNameWithoutGenericTypeParameter;
    }

    public boolean hasModifier(ETokenType modifierType) {
        return this.modifiers.stream().anyMatch(token -> token.getType() == modifierType);
    }

    public List<IToken> getModifiers() {
        return CollectionUtils.asUnmodifiable(this.modifiers);
    }

    public ShallowEntity getDeclaringEntity() {
        return this.declaringEntity;
    }

    public String getGenericTypeParameters() {
        return this.genericTypeParameters;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.modifiers.size() > 0) {
            builder.append(StringUtils.concat((Iterable)CollectionUtils.map(this.modifiers, IToken::getText), (String)" "));
            builder.append(" ");
        }
        builder.append(this.typeNameWithoutGenericTypeParameter);
        if (this.genericTypeParameters != null) {
            builder.append("<");
            builder.append(this.genericTypeParameters);
            builder.append(">");
        }
        builder.append(" ");
        builder.append(this.variableName);
        return builder.toString();
    }
}

