/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util;

import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.ILanguageFeatureParser;
import eu.cqse.check.framework.util.python.PythonVariableNameExtractor;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;

public class PythonLanguageFeatureParser
implements ILanguageFeatureParser {
    private static final Set<String> BUILT_IN_NAMES = CollectionUtils.asHashSet((Object[])new String[]{"abs", "dict", "help", "min", "setattr", "all", "dir", "hex", "next", "slice", "any", "divmod", "id", "object", "sorted", "ascii", "enumerate", "input", "oct", "staticmethod", "bin", "eval", "int", "open", "str", "bool", "exec", "isinstance", "ord", "sum", "bytearray", "filter", "issubclass", "pow", "super", "bytes", "float", "iter", "print", "tuple", "callable", "format", "len", "property", "type", "chr", "frozenset", "list", "range", "vars", "classmethod", "getattr", "locals", "repr", "zip", "compile", "globals", "map", "reversed", "__import__", "complex", "hasattr", "max", "round", "delattr", "hash", "memoryview", "set"});
    private static final PythonVariableNameExtractor VARIABLE_NAME_EXTRACTOR = new PythonVariableNameExtractor();

    PythonLanguageFeatureParser() {
    }

    public boolean isBuiltInName(String name) {
        return BUILT_IN_NAMES.contains(name);
    }

    public List<IToken> getDeclaredVariableNames(ShallowEntity entity) {
        return VARIABLE_NAME_EXTRACTOR.extractVariableNames(entity);
    }

    public boolean isClass(ShallowEntity shallowEntity) {
        return shallowEntity.getType() == EShallowEntityType.TYPE && shallowEntity.getSubtype().equals("class");
    }

    public boolean isDefinedOnClass(ShallowEntity entity) {
        ShallowEntity parentEntity = entity.getParent();
        if (parentEntity == null) {
            return false;
        }
        return parentEntity.getType() == EShallowEntityType.TYPE;
    }

    public boolean isMethod(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.METHOD;
    }

    public boolean isConstructor(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.METHOD && Objects.equals(entity.getName(), "__init__");
    }

    @Override
    public ELanguage getLanguage() {
        return ELanguage.PYTHON;
    }
}

