/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.model.option;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.ConfigurationBase;
import com.teamscale.core.analysis.configuration.model.option.IConfigOptionDescriptorBehaviour;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

class WriteToFieldDescriptorBehaviour
implements IConfigOptionDescriptorBehaviour {
    private final Field field;
    private final IObjectInstanceRetriever instanceRetriever;

    public WriteToFieldDescriptorBehaviour(@NonNull Field field, @NonNull IObjectInstanceRetriever instanceRetriever) {
        CCSMAssert.isNotNull((Object)field);
        CCSMAssert.isNotNull((Object)instanceRetriever);
        if (field.getType() == String.class || field.getType().isPrimitive()) {
            CCSMAssert.isFalse((boolean)Modifier.isFinal(field.getModifiers()), (String)("The auto-exposed field '" + field.getName() + "' of class " + field.getDeclaringClass().getName() + " is final and has a primitive type or type String. Setting a value in the UI will probably have no effect since its default value has been inlined by the compiler. Please remove the final qualifier and set the field to public."));
        }
        this.field = field;
        this.instanceRetriever = instanceRetriever;
    }

    @Override
    public Object retrieveValue(CodeScopeName codeScopeName) {
        try {
            if (WriteToFieldDescriptorBehaviour.isCodeScopeAwareField(this.field)) {
                CodeScopeAware<?> codeScopeAware = this.getCodeScopeAwareObjectInstance(this.field);
                return codeScopeAware.getValue(codeScopeName);
            }
            return this.field.get(this.instanceRetriever.getObjectInstance());
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new AssertionError("Could not retrieve value: " + e.getMessage(), e);
        }
    }

    @Override
    public Object retrieveDefaultValue() {
        try {
            if (WriteToFieldDescriptorBehaviour.isCodeScopeAwareField(this.field)) {
                CodeScopeAware<?> codeScopeAware = this.getCodeScopeAwareObjectInstance(this.field);
                return codeScopeAware.defaultValue();
            }
            return this.field.get(this.instanceRetriever.getObjectInstance());
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new AssertionError("Could not retrieve default value: " + e.getMessage(), e);
        }
    }

    @Override
    public @NonNull UnmodifiableList<?> retrieveValues() {
        try {
            if (WriteToFieldDescriptorBehaviour.isCodeScopeAwareField(this.field)) {
                CodeScopeAware<?> codeScopeAware = this.getCodeScopeAwareObjectInstance(this.field);
                return CollectionUtils.asUnmodifiable(codeScopeAware.getValues());
            }
            return CollectionUtils.asUnmodifiable(Collections.singletonList(this.retrieveDefaultValue()));
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new AssertionError("Could not retrieve value: " + e.getMessage(), e);
        }
    }

    @Override
    public void storeValue(Object value, CodeScopeName codeScopeName) {
        try {
            if (WriteToFieldDescriptorBehaviour.isCodeScopeAwareField(this.field)) {
                ConfigurationBase config = this.instanceRetriever.getObjectInstance();
                CodeScopeAware<?> codeScopeParam = config.getCodeScopeObject(this.field.getName());
                Class<?> typeOfCodeScopeParameter = CodeScopeAware.getTypeOfCodeScopeParameter(this.field);
                CCSMAssert.isNotNull(typeOfCodeScopeParameter);
                CCSMAssert.isTrue((boolean)typeOfCodeScopeParameter.isInstance(value), (String)"expected value to be of type '%s', but was '%s'".formatted(typeOfCodeScopeParameter.getName(), value.getClass().getName()));
                codeScopeParam.setGenericValue(codeScopeName, value);
                return;
            }
            this.field.set(this.instanceRetriever.getObjectInstance(), value);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            throw new AssertionError("Could not set value: " + e.getMessage(), e);
        }
    }

    @Override
    public String getTypeName() {
        Class<?> type = this.field.getType();
        if (Enum.class.isAssignableFrom(type)) {
            return "Enum";
        }
        if (CodeScopeAware.class.isAssignableFrom(type)) {
            Class<?> typeOfCodeScopeParameter = CodeScopeAware.getTypeOfCodeScopeParameter(this.field);
            CCSMAssert.isNotNull(typeOfCodeScopeParameter);
            return typeOfCodeScopeParameter.getSimpleName();
        }
        return type.getSimpleName();
    }

    private static boolean isCodeScopeAwareField(Field field) {
        return field.getType() == CodeScopeAware.class;
    }

    private CodeScopeAware<?> getCodeScopeAwareObjectInstance(Field field) throws IllegalAccessException {
        return (CodeScopeAware)field.get(this.instanceRetriever.getObjectInstance());
    }

    public static interface IObjectInstanceRetriever {
        public ConfigurationBase getObjectInstance();
    }
}

