/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.migrators;

import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.store.BranchBasedStoreBatchMigratorBase;
import com.teamscale.core.migration.store.EStorageMigratorType;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.SerializedValueMigratorBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.RandomAccess;
import java.util.SequencedSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.serialization.SerializedEntityParser;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.SerializedEntitySerializer;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.classes.SerializedFieldBase;
import org.conqat.lib.commons.serialization.classes.SerializedObjectField;
import org.conqat.lib.commons.serialization.objects.SerializedClassValues;
import org.conqat.lib.commons.serialization.objects.SerializedObject;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public abstract class MigrateVersion174UnmodifiableCollectionsBase
extends SerializedValueMigratorBase {
    private static final EStorageSystemVersion VERSION = EStorageSystemVersion.STORAGE_SYSTEM_V174;
    private final String storeName;
    private final EStorageMigratorType type;

    protected MigrateVersion174UnmodifiableCollectionsBase(String storeName, boolean compressed, EStorageMigratorType type) {
        super(compressed);
        this.storeName = storeName;
        this.type = type;
    }

    @Override
    public final EStorageSystemVersion getVersion() {
        return VERSION;
    }

    @Override
    public final String getStoreName() {
        return this.storeName;
    }

    @Override
    public final EStorageMigratorType getType() {
        return this.type;
    }

    @Override
    protected void migrate(SerializedEntityPool entityPool) throws StorageException, IOException, MigrationException {
        MigrateVersion174UnmodifiableCollectionsBase.doMigrate(entityPool);
    }

    public static void doMigrate(SerializedEntityPool entityPool) throws IOException {
        MigrateVersion174UnmodifiableCollectionsBase.migrateUnmodifiableSortedMap(entityPool);
        MigrateVersion174UnmodifiableCollectionsBase.migrateUnmodifiableSortedSet(entityPool);
        MigrateVersion174UnmodifiableCollectionsBase.migrateUnmodifiableMap(entityPool);
        MigrateVersion174UnmodifiableCollectionsBase.migrateUnmodifiableList(entityPool);
        MigrateVersion174UnmodifiableCollectionsBase.migrateUnmodifiableSet(entityPool);
        MigrateVersion174UnmodifiableCollectionsBase.migrateUnmodifiableCollection(entityPool);
    }

    private static void migrateUnmodifiableCollection(SerializedEntityPool entityPool) throws IOException {
        MigrateVersion174UnmodifiableCollectionsBase.migrateUnmodifiable(entityPool, "UnmodifiableCollection", "c", "collection", "java.util.Collection");
    }

    private static void migrateUnmodifiableList(SerializedEntityPool entityPool) throws IOException {
        MigrateVersion174UnmodifiableCollectionsBase.migrateUnmodifiable(entityPool, "UnmodifiableList", "l", "list", "java.util.List");
        MigrateVersion174UnmodifiableCollectionsBase.migrateUnmodifiableRandomAccessList(entityPool);
    }

    private static void migrateUnmodifiableRandomAccessList(SerializedEntityPool entityPool) throws IOException {
        SerializedClass unmodifiableListClass = entityPool.findClass("org.conqat.lib.commons.collections.UnmodifiableListImpl");
        if (unmodifiableListClass == null) {
            return;
        }
        List unmodifiableListEntities = entityPool.getEntities(unmodifiableListClass);
        for (SerializedObject unmodifiableListEntity : unmodifiableListEntities) {
            Class<?> underlyingListClass;
            SerializedObject underlyingList = (SerializedObject)entityPool.getEntity(((Integer)unmodifiableListEntity.getFieldValue("list")).intValue(), SerializedObject.class);
            try {
                underlyingListClass = Class.forName(underlyingList.getSerializedClass().getName());
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            if (!RandomAccess.class.isAssignableFrom(underlyingListClass)) continue;
            SerializedClass randomAccessClass = entityPool.getOrCreateClass("org.conqat.lib.commons.collections.UnmodifiableRandomAccessListImpl", new SerializedFieldBase[0]);
            randomAccessClass.setSuperClassHandle(unmodifiableListClass.getHandle());
            unmodifiableListEntity.addFieldSet(new SerializedClassValues(0), 1);
            unmodifiableListEntity.setClassHandle(randomAccessClass.getHandle());
        }
    }

    private static void migrateUnmodifiableMap(SerializedEntityPool entityPool) throws IOException {
        MigrateVersion174UnmodifiableCollectionsBase.migrateUnmodifiable(entityPool, "UnmodifiableMap", "map", "map", "java.util.Map");
    }

    private static void migrateUnmodifiableSet(SerializedEntityPool entityPool) throws IOException {
        MigrateVersion174UnmodifiableCollectionsBase.migrateUnmodifiable(entityPool, "UnmodifiableSet", "c", "set", "java.util.Set");
    }

    private static void migrateUnmodifiableSortedMap(SerializedEntityPool entityPool) throws IOException {
        MigrateVersion174UnmodifiableCollectionsBase.migrateUnmodifiable(entityPool, "UnmodifiableSortedMap", "m", "sortedMap", "java.util.SortedMap");
    }

    private static void migrateUnmodifiableSortedSet(SerializedEntityPool entityPool) throws IOException {
        MigrateVersion174UnmodifiableCollectionsBase.migrateUnmodifiable(entityPool, "UnmodifiableSortedSet", "s", "sortedSet", "java.util.SortedSet");
    }

    private static void migrateUnmodifiable(SerializedEntityPool entityPool, String className, String oldFieldName, String newFieldName, String newFieldType) throws IOException {
        SerializedClass collectionClass = entityPool.findClass("org.conqat.lib.commons.collections." + className);
        if (collectionClass == null) {
            return;
        }
        List collections = entityPool.getEntities(collectionClass);
        for (SerializedObject collection : collections) {
            MigrateVersion174UnmodifiableCollectionsBase.replaceWithSingleField(collection, oldFieldName);
        }
        MigrateVersion174UnmodifiableCollectionsBase.fixClassDeclaration(collectionClass, newFieldName, newFieldType);
    }

    private static void replaceWithSingleField(SerializedObject collection, String oldFieldName) throws IOException {
        Object collectionValue = collection.getFieldValue(oldFieldName);
        MigrateVersion174UnmodifiableCollectionsBase.removeAllFieldSets(collection);
        SerializedClassValues fieldSet = new SerializedClassValues(1);
        fieldSet.setValue(0, collectionValue);
        collection.addFieldSet(fieldSet, 0);
    }

    private static void removeAllFieldSets(SerializedObject object) {
        int fieldSetCount = object.getFieldSetCount();
        for (int i = fieldSetCount - 1; i >= 0; --i) {
            object.removeFieldSet(i);
        }
    }

    private static void fixClassDeclaration(SerializedClass collectionClass, String newFieldName, String newFieldType) {
        new ArrayList<SerializedFieldBase>((Collection<SerializedFieldBase>)collectionClass.getFields()).forEach(field -> collectionClass.removeField(field.getName()));
        collectionClass.addField((SerializedFieldBase)new SerializedObjectField(newFieldName, SerializedObjectField.createJvmNotationFromPlainClassName((String)newFieldType)));
        collectionClass.setSuperClassHandle(0);
        collectionClass.setName(collectionClass.getName() + "Impl");
    }

    @ThreadSafe
    public static final class MigrateVersion174UnmodifiableCollectionsBranchedStores
    extends BranchBasedStoreBatchMigratorBase {
        private static final SequencedSet<String> STORE_NAMES = new LinkedHashSet<String>(Set.of("external-analysis-results", "element-review-uploads", "finding-blacklist-staging", "external-architecture-uploads"));

        public MigrateVersion174UnmodifiableCollectionsBranchedStores() {
            super(VERSION, true);
        }

        @Override
        protected byte[] migrateValue(byte[] key, byte[] value) throws StorageException {
            try {
                SerializedEntityPool entityPool = SerializedEntityParser.parse((byte[])value);
                MigrateVersion174UnmodifiableCollectionsBase.doMigrate(entityPool);
                return SerializedEntitySerializer.serializeToBytes((List)entityPool.getRootEntities());
            }
            catch (IOException e) {
                throw new StorageException((Throwable)e);
            }
        }

        @Override
        public String getStoreName() {
            return (String)STORE_NAMES.getFirst();
        }

        @Override
        public Set<String> getAdditionalStoreNames() {
            return STORE_NAMES.stream().skip(1L).collect(Collectors.toSet());
        }
    }

    @ThreadSafe
    public static final class MigrateVersion174UnmodifiableCollectionsExternalAnalysisImportSessionIndex
    extends MigrateVersion174UnmodifiableCollectionsBase {
        private static final byte[] COMMIT_INDEX_PREFIX = StringUtils.stringToBytes((String)"c$%$");
        private static final byte[] UNSCHEDULED_SESSION_INDEX_PREFIX = StringUtils.stringToBytes((String)"u$%$");
        private static final byte[] VALUE_INDEX_PREFIX = StringUtils.stringToBytes((String)"v");
        private static final byte[] SCATTERED_COLLECTION_INDEX_SIZE_STORE_INFIX = StringUtils.stringToBytes((String)"$%$s$%$");

        public MigrateVersion174UnmodifiableCollectionsExternalAnalysisImportSessionIndex() {
            super("external-analysis-session", true, EStorageMigratorType.PROJECT);
        }

        @Override
        protected boolean isHiddenKey(byte[] key) {
            return super.isHiddenKey(key) || MigrateVersion174UnmodifiableCollectionsExternalAnalysisImportSessionIndex.isFromCommitIndex(key) || MigrateVersion174UnmodifiableCollectionsExternalAnalysisImportSessionIndex.isFromUnscheduledSessionsIndex(key) || MigrateVersion174UnmodifiableCollectionsExternalAnalysisImportSessionIndex.isSizeEntryInScatteredCollectionValueIndex(key);
        }

        private static boolean isFromCommitIndex(byte[] key) {
            return ByteArrayUtils.isPrefix((byte[])COMMIT_INDEX_PREFIX, (byte[])key);
        }

        private static boolean isFromUnscheduledSessionsIndex(byte[] key) {
            return ByteArrayUtils.isPrefix((byte[])UNSCHEDULED_SESSION_INDEX_PREFIX, (byte[])key);
        }

        private static boolean isSizeEntryInScatteredCollectionValueIndex(byte[] key) {
            return ByteArrayUtils.isPrefix((byte[])VALUE_INDEX_PREFIX, (byte[])key) && ByteArrayUtils.contains((byte[])SCATTERED_COLLECTION_INDEX_SIZE_STORE_INFIX, (byte[])key);
        }
    }

    @ThreadSafe
    public static final class MigrateVersion174UnmodifiableCollectionsProjectCompressedUnbranchedStores
    extends MigrateVersion174UnmodifiableCollectionsBase {
        private static final SequencedSet<String> STORE_NAMES = new LinkedHashSet<String>(Set.of("voting-records", "tasks", "dot-net-program-versions", "pareto-list"));

        public MigrateVersion174UnmodifiableCollectionsProjectCompressedUnbranchedStores() {
            super((String)STORE_NAMES.getFirst(), true, EStorageMigratorType.PROJECT);
        }

        @Override
        public Set<String> getAdditionalStoreNames() {
            return STORE_NAMES.stream().skip(1L).collect(Collectors.toSet());
        }
    }

    @ThreadSafe
    public static final class MigrateVersion174UnmodifiableCollectionsGlobalUncompressedStores
    extends MigrateVersion174UnmodifiableCollectionsBase {
        public MigrateVersion174UnmodifiableCollectionsGlobalUncompressedStores() {
            super("quality-reports-index", false, EStorageMigratorType.GLOBAL);
        }
    }

    @ThreadSafe
    public static final class MigrateVersion174UnmodifiableCollectionsUserIndex
    extends MigrateVersion174UnmodifiableCollectionsBase {
        private static final List<byte[]> HIDDEN_PREFIXES = List.of(StringUtils.stringToBytes((String)"enabled-users$%$"), StringUtils.stringToBytes((String)"last-change$%$"));

        public MigrateVersion174UnmodifiableCollectionsUserIndex() {
            super("users", true, EStorageMigratorType.GLOBAL);
        }

        @Override
        protected boolean isHiddenKey(byte[] key) {
            return super.isHiddenKey(key) || HIDDEN_PREFIXES.stream().anyMatch(prefix -> ByteArrayUtils.isPrefix((byte[])prefix, (byte[])key));
        }
    }

    @ThreadSafe
    public static final class MigrateVersion174UnmodifiableCollectionsGlobalCompressedStores
    extends MigrateVersion174UnmodifiableCollectionsBase {
        private static final SequencedSet<String> STORE_NAMES = new LinkedHashSet<String>(Set.of("slide-render-data", "project-notification-rules", "metric-notification-rules", "dashboard-templates", "analysis-profile-versions", "retrospectives"));

        public MigrateVersion174UnmodifiableCollectionsGlobalCompressedStores() {
            super((String)STORE_NAMES.getFirst(), true, EStorageMigratorType.GLOBAL);
        }

        @Override
        public Set<String> getAdditionalStoreNames() {
            return STORE_NAMES.stream().skip(1L).collect(Collectors.toSet());
        }
    }
}

