/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.store;

import com.teamscale.core.migration.store.DiscardingStore;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.DelegatingStorageSystemBase;

class RenamingAndRemovingStorageSystem
extends DelegatingStorageSystemBase {
    private final Map<String, String> storeRenames;
    private final Set<String> deletedStores;

    public RenamingAndRemovingStorageSystem(Map<String, String> storeRenames, Set<String> deletedStores, IStorageSystem delegateStorageSystem) {
        super(delegateStorageSystem);
        this.storeRenames = storeRenames;
        this.deletedStores = deletedStores;
    }

    public IStore openStore(String name) throws StorageException {
        if (this.deletedStores.contains(name)) {
            return new DiscardingStore();
        }
        if (this.storeRenames.containsKey(name)) {
            name = this.storeRenames.get(name);
        }
        return super.openStore(name);
    }
}

