/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.worker;

import com.teamscale.core.runtime.impl.worker.ICrossProjectLockSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.conqat.engine.persistence.distribution.ILockProvider;
import org.conqat.engine.persistence.index.IMountableStorageIndex;
import org.conqat.engine.persistence.index.IStorageIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.index.schema.SchemaEntry;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class MountedStorageSystemLockSupport
implements ICrossProjectLockSupport {
    private static final String CROSS_PROJECT_LOCK_NAME = "cross-project-lock";
    private static final String ACQUIRE_CROSS_STORAGE_SYSTEM_ACCESS_LOCKS_LOCK_NAME = "acquire-cross-storage-system-access-locks";
    private final List<Lock> storageSystemLocks = new ArrayList<Lock>();
    private final ILockProvider lockProvider;

    public MountedStorageSystemLockSupport(ILockProvider lockProvider) {
        this.lockProvider = lockProvider;
    }

    @Override
    public void collectNeededLocks(SchemaEntry schemaEntry, IStore store) {
        if (schemaEntry.getStorageOptions().contains((Object)EStorageOption.CROSS_PROJECT_MOUNTABLE)) {
            this.storageSystemLocks.add(store.obtainLock(CROSS_PROJECT_LOCK_NAME));
        }
    }

    @Override
    public void collectNeededLocks(SchemaEntry schemaEntry, IStorageIndex storageIndex) {
        if (schemaEntry.getStorageOptions().contains((Object)EStorageOption.CROSS_PROJECT_MOUNTABLE)) {
            CCSMAssert.isInstanceOf((Object)storageIndex, IMountableStorageIndex.class);
            this.storageSystemLocks.add(((IMountableStorageIndex)storageIndex).obtainStoreLock(CROSS_PROJECT_LOCK_NAME));
        }
    }

    @Override
    public void lock() {
        Lock acquireLocksLock = this.lockProvider.obtainLock(ACQUIRE_CROSS_STORAGE_SYSTEM_ACCESS_LOCKS_LOCK_NAME);
        try {
            acquireLocksLock.lock();
            this.storageSystemLocks.forEach(Lock::lock);
        }
        finally {
            acquireLocksLock.unlock();
        }
    }

    @Override
    public void unlock() {
        this.storageSystemLocks.forEach(Lock::unlock);
    }
}

